/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class PskKeyExchangeModesExtension
extends Extension {
    private final List<TlsConstants.PskKeyExchangeMode> keyExchangeModes = new ArrayList<TlsConstants.PskKeyExchangeMode>();

    public PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode keyExchangeMode) {
        this.keyExchangeModes.add(keyExchangeMode);
    }

    public PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode ... keyExchangeModes) {
        for (TlsConstants.PskKeyExchangeMode keyExchangeMode : keyExchangeModes) {
            this.keyExchangeModes.add(keyExchangeMode);
        }
    }

    public PskKeyExchangeModesExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.psk_key_exchange_modes, 2);
        int pskKeyExchangeModesLength = buffer.get();
        if (extensionDataLength != 1 + pskKeyExchangeModesLength) {
            throw new DecodeErrorException("inconsistent length");
        }
        for (int i = 0; i < pskKeyExchangeModesLength; ++i) {
            byte modeByte = buffer.get();
            TlsConstants.decodePskKeyExchangeMode(modeByte).ifPresent(m -> this.keyExchangeModes.add((TlsConstants.PskKeyExchangeMode)((Object)m)));
        }
    }

    @Override
    public byte[] getBytes() {
        short extensionLength = (short)(1 + this.keyExchangeModes.size());
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.psk_key_exchange_modes.value);
        buffer.putShort(extensionLength);
        buffer.put((byte)this.keyExchangeModes.size());
        this.keyExchangeModes.forEach(mode -> buffer.put(mode.value));
        return buffer.array();
    }

    public List<TlsConstants.PskKeyExchangeMode> getKeyExchangeModes() {
        return this.keyExchangeModes;
    }
}

