/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class CertificateAuthoritiesExtension
extends Extension {
    private final List<X500Principal> authorities = new ArrayList<X500Principal>();

    public CertificateAuthoritiesExtension(X500Principal x500Principal) {
        this.authorities.add(x500Principal);
    }

    public CertificateAuthoritiesExtension(ByteBuffer buffer) throws DecodeErrorException {
        int dnLength;
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.certificate_authorities, 2);
        int authoritiesLength = buffer.getShort();
        if (extensionDataLength != authoritiesLength + 2) {
            throw new DecodeErrorException("inconsistent length fields");
        }
        for (int remaining = authoritiesLength; remaining > 0; remaining -= dnLength) {
            if (remaining < 2) {
                throw new DecodeErrorException("inconsistent length fields");
            }
            dnLength = buffer.getShort() & 0xFFFF;
            if (dnLength > (remaining -= 2)) {
                throw new DecodeErrorException("inconsistent length fields");
            }
            if (dnLength <= buffer.remaining()) {
                byte[] dn = new byte[dnLength];
                buffer.get(dn);
                try {
                    this.authorities.add(new X500Principal(dn));
                    continue;
                }
                catch (IllegalArgumentException encodingError) {
                    throw new DecodeErrorException("authority not in DER format");
                }
            }
            throw new DecodeErrorException("inconsistent length fields");
        }
    }

    @Override
    public byte[] getBytes() {
        int authoritiesLength = this.authorities.stream().mapToInt(x500principal -> x500principal.getEncoded().length).sum();
        int extensionLength = authoritiesLength + this.authorities.size() * 2 + 2 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.certificate_authorities.value);
        buffer.putShort((short)(extensionLength - 4));
        buffer.putShort((short)(extensionLength - 6));
        this.authorities.stream().forEach(authority -> {
            buffer.putShort((short)authority.getEncoded().length);
            buffer.put(authority.getEncoded());
        });
        return buffer.array();
    }

    public List<X500Principal> getAuthorities() {
        return this.authorities;
    }
}

