/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.handshake.HandshakeMessage;

public class TranscriptHash {
    private static ExtendedHandshakeType[] hashedMessages = new ExtendedHandshakeType[]{ExtendedHandshakeType.client_hello, ExtendedHandshakeType.server_hello, ExtendedHandshakeType.encrypted_extensions, ExtendedHandshakeType.certificate_request, ExtendedHandshakeType.server_certificate, ExtendedHandshakeType.server_certificate_verify, ExtendedHandshakeType.server_finished, ExtendedHandshakeType.client_certificate, ExtendedHandshakeType.client_certificate_verify, ExtendedHandshakeType.client_finished};
    private final MessageDigest hashFunction;
    private Map<ExtendedHandshakeType, byte[]> msgData = new ConcurrentHashMap<ExtendedHandshakeType, byte[]>();
    private Map<ExtendedHandshakeType, byte[]> hashes = new ConcurrentHashMap<ExtendedHandshakeType, byte[]>();

    public TranscriptHash(int hashLength) {
        String hashAlgorithm = "SHA-" + hashLength * 8;
        try {
            this.hashFunction = MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing " + hashAlgorithm + " support");
        }
    }

    public byte[] getHash(TlsConstants.HandshakeType msgType) {
        return this.getHash(this.convert(msgType));
    }

    public byte[] getClientHash(TlsConstants.HandshakeType msgType) {
        return this.getHash(this.convert(msgType, true));
    }

    public byte[] getServerHash(TlsConstants.HandshakeType msgType) {
        return this.getHash(this.convert(msgType, false));
    }

    public void record(HandshakeMessage msg) {
        List<TlsConstants.HandshakeType> ambigousTypes = List.of(TlsConstants.HandshakeType.certificate, TlsConstants.HandshakeType.certificate_verify, TlsConstants.HandshakeType.finished);
        if (ambigousTypes.contains((Object)msg.getType())) {
            throw new IllegalArgumentException();
        }
        this.msgData.put(this.convert(msg.getType()), msg.getBytes());
    }

    public void recordClient(HandshakeMessage msg) {
        this.msgData.put(this.convert(msg.getType(), true), msg.getBytes());
    }

    public void recordServer(HandshakeMessage msg) {
        this.msgData.put(this.convert(msg.getType(), false), msg.getBytes());
    }

    private byte[] getHash(ExtendedHandshakeType type) {
        if (!this.hashes.containsKey((Object)type)) {
            this.computeHash(type);
        }
        return this.hashes.get((Object)type);
    }

    private void computeHash(ExtendedHandshakeType requestedType) {
        for (ExtendedHandshakeType type : hashedMessages) {
            if (this.msgData.containsKey((Object)type)) {
                this.hashFunction.update(this.msgData.get((Object)type));
            }
            if (type == requestedType) break;
        }
        this.hashes.put(requestedType, this.hashFunction.digest());
    }

    private ExtendedHandshakeType convert(TlsConstants.HandshakeType type) {
        List<TlsConstants.HandshakeType> ambigousTypes = List.of(TlsConstants.HandshakeType.certificate, TlsConstants.HandshakeType.certificate_verify, TlsConstants.HandshakeType.finished);
        if (ambigousTypes.contains((Object)type)) {
            throw new IllegalArgumentException("cannot convert ambiguous type " + String.valueOf((Object)type));
        }
        return ExtendedHandshakeType.values()[type.ordinal()];
    }

    private ExtendedHandshakeType convert(TlsConstants.HandshakeType type, boolean client) {
        if (type == TlsConstants.HandshakeType.finished) {
            return client ? ExtendedHandshakeType.client_finished : ExtendedHandshakeType.server_finished;
        }
        if (type == TlsConstants.HandshakeType.certificate) {
            return client ? ExtendedHandshakeType.client_certificate : ExtendedHandshakeType.server_certificate;
        }
        if (type == TlsConstants.HandshakeType.certificate_verify) {
            return client ? ExtendedHandshakeType.client_certificate_verify : ExtendedHandshakeType.server_certificate_verify;
        }
        return ExtendedHandshakeType.values()[type.ordinal()];
    }

    static enum ExtendedHandshakeType {
        client_hello(1),
        server_hello(2),
        new_session_ticket(4),
        end_of_early_data(5),
        encrypted_extensions(8),
        certificate(11),
        certificate_request(13),
        certificate_verify(15),
        finished(20),
        key_update(24),
        server_certificate(249),
        server_certificate_verify(250),
        server_finished(251),
        client_certificate(252),
        client_certificate_verify(253),
        client_finished(254);

        public final byte value;

        private ExtendedHandshakeType(int value) {
            this.value = (byte)value;
        }
    }
}

