/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.utils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tech.kronicle.common.CaseUtils;

public final class EnumUtils {
    public static <T extends Enum<T>> List<T> getEnumListFromJsonValues(Class<T> enumType, List<String> values) {
        Objects.requireNonNull(enumType, "enumType");
        if (Objects.isNull(values)) {
            return List.of();
        }
        return values.stream().map(value -> EnumUtils.getEnumFromJsonValue(enumType, value)).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> T getEnumFromJsonValue(Class<T> enumType, String value) {
        Objects.requireNonNull(enumType, "enumType");
        return Enum.valueOf(enumType, CaseUtils.toScreamingSnakeCase((String)value));
    }

    private EnumUtils() {
    }
}

