/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugintestutils.scanners;

import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import tech.kronicle.pluginapi.scanners.models.Output;
import tech.kronicle.sdk.models.Component;
import tech.kronicle.sdk.models.ScannerError;
import tech.kronicle.testutils.BaseTest;

public class BaseScannerTest
extends BaseTest {
    protected <T> Output<T, Component> maskTransformer(Output<T, Component> output) {
        return new Output(output.getOutput(), null, output.getErrors(), output.getCacheTtl());
    }

    protected <T> Component getMutatedComponent(Output<T, Component> output) {
        return this.getMutatedComponent(output, Component.builder().build());
    }

    protected <T> Component getMutatedComponent(Output<T, Component> output, Component component) {
        Assertions.assertThat((List)output.getErrors()).isNotNull();
        if (output.getErrors().size() > 0) {
            throw new RuntimeException(((ScannerError)output.getErrors().get(0)).toString());
        }
        return this.getMutatedComponentIgnoringErrors(output, component);
    }

    protected <T> Component getMutatedComponentIgnoringErrors(Output<T, Component> output) {
        return this.getMutatedComponentIgnoringErrors(output, Component.builder().build());
    }

    protected <T> Component getMutatedComponentIgnoringErrors(Output<T, Component> output, Component component) {
        return Objects.nonNull(output.getTransformer()) ? (Component)output.getTransformer().apply(component) : component;
    }
}

