/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginapi.scanners.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.Component;
import tech.kronicle.sdk.models.ScannerError;

public final class Output<O> {
    private final O output;
    private final UnaryOperator<Component> componentTransformer;
    @NotNull
    private final List<ScannerError> errors;

    private Output(UnaryOperator<Component> componentTransformer) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        this.componentTransformer = componentTransformer;
        this.output = null;
        this.errors = List.of();
    }

    private Output(UnaryOperator<Component> componentTransformer, ScannerError error) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        Objects.requireNonNull(error, "error");
        this.componentTransformer = componentTransformer;
        this.output = null;
        this.errors = List.of(error);
    }

    private Output(UnaryOperator<Component> componentTransformer, List<ScannerError> errors) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        Objects.requireNonNull(errors, "errors");
        this.componentTransformer = componentTransformer;
        this.output = null;
        this.errors = List.copyOf(errors);
    }

    private Output(UnaryOperator<Component> componentTransformer, O output) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        Objects.requireNonNull(output, "output");
        this.componentTransformer = componentTransformer;
        this.output = output;
        this.errors = List.of();
    }

    private Output(UnaryOperator<Component> componentTransformer, O output, ScannerError error) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(error, "error");
        this.componentTransformer = componentTransformer;
        this.output = output;
        this.errors = List.of(error);
    }

    private Output(UnaryOperator<Component> componentTransformer, O output, List<ScannerError> errors) {
        Objects.requireNonNull(componentTransformer, "componentTransformer");
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(errors, "errors");
        this.componentTransformer = componentTransformer;
        this.output = output;
        this.errors = List.copyOf(errors);
    }

    private Output(ScannerError error) {
        Objects.requireNonNull(error, "error");
        this.componentTransformer = null;
        this.output = null;
        this.errors = List.of(error);
    }

    private Output(List<ScannerError> errors) {
        Objects.requireNonNull(errors, "errors");
        this.componentTransformer = null;
        this.output = null;
        this.errors = List.copyOf(errors);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer) {
        return new Output<O>(componentTransformer);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer, ScannerError error) {
        return new Output<ScannerError>(componentTransformer, error);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer, List<ScannerError> errors) {
        return new Output<List<ScannerError>>(componentTransformer, errors);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer, O output) {
        return new Output<O>(componentTransformer, output);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer, O output, ScannerError error) {
        return new Output<O>(componentTransformer, output, error);
    }

    public static <O> Output<O> of(UnaryOperator<Component> componentTransformer, O output, List<ScannerError> errors) {
        return new Output<O>(componentTransformer, output, errors);
    }

    public static <O> Output<O> of(ScannerError error) {
        return new Output<O>(error);
    }

    public static <O> Output<O> of(List<ScannerError> errors) {
        return new Output<O>(errors);
    }

    public boolean success() {
        return this.errors.isEmpty();
    }

    public boolean failed() {
        return !this.success();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public O getOutput() {
        return this.output;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UnaryOperator<Component> getComponentTransformer() {
        return this.componentTransformer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ScannerError> getErrors() {
        return this.errors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Output)) {
            return false;
        }
        Output other = (Output)o;
        O this$output = this.getOutput();
        O other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        UnaryOperator<Component> this$componentTransformer = this.getComponentTransformer();
        UnaryOperator<Component> other$componentTransformer = other.getComponentTransformer();
        if (this$componentTransformer == null ? other$componentTransformer != null : !this$componentTransformer.equals(other$componentTransformer)) {
            return false;
        }
        List<ScannerError> this$errors = this.getErrors();
        List<ScannerError> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        O $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        UnaryOperator<Component> $componentTransformer = this.getComponentTransformer();
        result = result * 59 + ($componentTransformer == null ? 43 : $componentTransformer.hashCode());
        List<ScannerError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Output(output=" + this.getOutput() + ", componentTransformer=" + this.getComponentTransformer() + ", errors=" + this.getErrors() + ")";
    }
}

