/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.apidoc.customizer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.core.Ordered;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Server;
import springfox.documentation.spring.web.plugins.Docket;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.apidoc.customizer.SpringfoxCustomizer;

public class JHipsterSpringfoxCustomizer
implements SpringfoxCustomizer,
Ordered {
    public static final int DEFAULT_ORDER = 0;
    private int order = 0;
    private final JHipsterProperties.ApiDocs properties;

    public JHipsterSpringfoxCustomizer(JHipsterProperties.ApiDocs properties) {
        this.properties = properties;
    }

    @Override
    public void customize(Docket docket) {
        Contact contact = new Contact(this.properties.getContactName(), this.properties.getContactUrl(), this.properties.getContactEmail());
        ApiInfo apiInfo = new ApiInfo(this.properties.getTitle(), this.properties.getDescription(), this.properties.getVersion(), this.properties.getTermsOfServiceUrl(), contact, this.properties.getLicense(), this.properties.getLicenseUrl(), new ArrayList());
        for (JHipsterProperties.ApiDocs.Server server : this.properties.getServers()) {
            docket.servers(new Server(server.getName(), server.getUrl(), server.getDescription(), Collections.emptyList(), Collections.emptyList()), new Server[0]);
        }
        docket.host(this.properties.getHost()).protocols(new HashSet<String>(Arrays.asList(this.properties.getProtocols()))).apiInfo(apiInfo).useDefaultResponseMessages(this.properties.isUseDefaultResponseMessages()).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).ignoredParameterTypes(new Class[]{Pageable.class}).ignoredParameterTypes(new Class[]{ServerHttpRequest.class}).select().paths(PathSelectors.regex((String)this.properties.getDefaultIncludePattern())).build();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

