/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.ext;

import java.time.LocalDate;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.time.ext.LocalDateIterator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0007H\u0086\u0004J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Ltech/harmonysoft/oss/common/time/ext/LocalDateProgression;", "", "Ljava/time/LocalDate;", "Lkotlin/ranges/ClosedRange;", "start", "endInclusive", "stepDays", "", "(Ljava/time/LocalDate;Ljava/time/LocalDate;J)V", "getEndInclusive", "()Ljava/time/LocalDate;", "getStart", "getStepDays", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "iterator", "", "step", "days", "toString", "", "harmonysoft-common"})
public final class LocalDateProgression
implements Iterable<LocalDate>,
ClosedRange<LocalDate>,
KMappedMarker {
    @NotNull
    private final LocalDate start;
    @NotNull
    private final LocalDate endInclusive;
    private final long stepDays;

    public LocalDateProgression(@NotNull LocalDate start, @NotNull LocalDate endInclusive, long stepDays) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
        this.stepDays = stepDays;
        if (this.getEndInclusive().compareTo(this.getStart()) < 0) {
            throw new IllegalArgumentException("end date (" + this.getEndInclusive() + ") must be not before the start date (" + this.getStart() + ")");
        }
    }

    public /* synthetic */ LocalDateProgression(LocalDate localDate, LocalDate localDate2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 1L;
        }
        this(localDate, localDate2, l);
    }

    @NotNull
    public LocalDate getStart() {
        return this.start;
    }

    @NotNull
    public LocalDate getEndInclusive() {
        return this.endInclusive;
    }

    public final long getStepDays() {
        return this.stepDays;
    }

    @Override
    @NotNull
    public Iterator<LocalDate> iterator() {
        return new LocalDateIterator(this.getStart(), this.getEndInclusive(), this.stepDays);
    }

    @NotNull
    public final LocalDateProgression step(long days) {
        return new LocalDateProgression(this.getStart(), this.getEndInclusive(), days);
    }

    public boolean contains(@NotNull LocalDate value2) {
        return ClosedRange.DefaultImpls.contains((ClosedRange)this, (Comparable)value2);
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    @NotNull
    public final LocalDate component1() {
        return this.start;
    }

    @NotNull
    public final LocalDate component2() {
        return this.endInclusive;
    }

    public final long component3() {
        return this.stepDays;
    }

    @NotNull
    public final LocalDateProgression copy(@NotNull LocalDate start, @NotNull LocalDate endInclusive, long stepDays) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new LocalDateProgression(start, endInclusive, stepDays);
    }

    public static /* synthetic */ LocalDateProgression copy$default(LocalDateProgression localDateProgression, LocalDate localDate, LocalDate localDate2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            localDate = localDateProgression.start;
        }
        if ((n & 2) != 0) {
            localDate2 = localDateProgression.endInclusive;
        }
        if ((n & 4) != 0) {
            l = localDateProgression.stepDays;
        }
        return localDateProgression.copy(localDate, localDate2, l);
    }

    @NotNull
    public String toString() {
        return "LocalDateProgression(start=" + this.start + ", endInclusive=" + this.endInclusive + ", stepDays=" + this.stepDays + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.endInclusive.hashCode();
        result = result * 31 + Long.hashCode(this.stepDays);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalDateProgression)) {
            return false;
        }
        LocalDateProgression localDateProgression = (LocalDateProgression)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)localDateProgression.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endInclusive, (Object)localDateProgression.endInclusive)) {
            return false;
        }
        return this.stepDays == localDateProgression.stepDays;
    }
}

