/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.collection.CollectionUtil;
import tech.harmonysoft.oss.common.string.util.StringUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0002J*\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\t2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\u0017"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil;", "", "()V", "flatten", "", "Lkotlin/Pair;", "", "path", "value", "", "data", "merge", "", "from", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "to", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "replaceDataHolders", "unflatten", "key", "input", "Data", "harmonysoft-common"})
public final class CollectionUtil {
    @NotNull
    public static final CollectionUtil INSTANCE = new CollectionUtil();

    private CollectionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> flatten(@NotNull Map<String, ? extends Object> data) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Map<String, ? extends Object> $this$flatMap$iv = data;
        boolean $i$f$flatMap = false;
        Map<String, ? extends Object> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            block4: {
                block3: {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    Object value2 = entry.getValue();
                    object = value2;
                    if (object == null) break block3;
                    Object it = object;
                    boolean bl2 = false;
                    Collection<Pair<String, Object>> collection = INSTANCE.flatten(key, it);
                    object = collection;
                    if (collection != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Pair<String, Object>> flatten(String path, Object value2) {
        Collection collection;
        block12: {
            block13: {
                Object object;
                block9: {
                    void $this$flatMapTo$iv$iv;
                    object = value2;
                    if (!(object instanceof Map)) break block9;
                    Iterable $this$flatMap$iv = ((Map)value2).entrySet();
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        Object object2;
                        block11: {
                            block10: {
                                Map.Entry entry = (Map.Entry)element$iv$iv;
                                boolean bl = false;
                                Object k = entry.getKey();
                                Object v = entry.getValue();
                                object2 = v;
                                if (object2 == null) break block10;
                                Object it = object2;
                                boolean bl2 = false;
                                Collection<Pair<String, Object>> collection2 = INSTANCE.flatten(path + '.' + k, v);
                                object2 = collection2;
                                if (collection2 != null) break block11;
                            }
                            object2 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = (Iterable)object2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    collection = (List)destination$iv$iv;
                    break block12;
                }
                if (!(object instanceof List)) break block13;
                Iterable iterable = (Iterable)value2;
                Collection collection3 = new ArrayList();
                int n = 0;
                for (Object t : iterable) {
                    Collection<Pair<String, Object>> collection4;
                    block15: {
                        block14: {
                            void v;
                            int n2;
                            if ((n2 = n++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Object list$iv$iv = t;
                            int index = n2;
                            boolean bl = false;
                            collection4 = v;
                            if (collection4 == null) break block14;
                            void it = collection4;
                            boolean bl3 = false;
                            Collection<Pair<String, Object>> collection5 = INSTANCE.flatten(path + '[' + index + ']', it);
                            collection4 = collection5;
                            if (collection5 != null) break block15;
                        }
                        collection4 = CollectionsKt.emptyList();
                    }
                    CollectionsKt.addAll((Collection)collection3, (Iterable)collection4);
                }
                collection = (List)collection3;
                break block12;
            }
            collection = CollectionsKt.listOf((Object)TuplesKt.to((Object)path, (Object)value2));
        }
        return collection;
    }

    @NotNull
    public final Map<String, Object> unflatten(@NotNull Map<String, ?> input) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Object result = null;
                for (Map.Entry<String, ?> entry : input.entrySet()) {
                    Unit unit;
                    Object it;
                    String key = entry.getKey();
                    Object value2 = entry.getValue();
                    if (value2 == null) continue;
                    boolean bl = false;
                    Data data = INSTANCE.unflatten(key, new Data.LeafData(it));
                    if (result != null) {
                        Map it2;
                        boolean bl2 = false;
                        INSTANCE.merge(data, (Data)((Object)it2));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) continue;
                    CollectionUtil $this$unflatten_u24lambda_u2d8_u24lambda_u2d7 = INSTANCE;
                    boolean bl3 = false;
                    result = data;
                }
                object = result;
                if (object == null) break block6;
                Map it = object;
                boolean bl = false;
                Object object2 = INSTANCE.replaceDataHolders((Data)((Object)it));
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map map = (Map)object2;
                object = map;
                if (map != null) break block7;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void merge(Data from, Data to) {
        Data data = from;
        if (data instanceof Data.MapData) {
            if (!(to instanceof Data.MapData)) throw new IllegalArgumentException("wrong data setup - there are values of type " + Reflection.getOrCreateKotlinClass(from.getClass()).getSimpleName() + " and " + Reflection.getOrCreateKotlinClass(to.getClass()).getSimpleName());
            this.merge((Data.MapData)from, (Data.MapData)to);
            return;
        } else if (data instanceof Data.ArrayData) {
            if (!(to instanceof Data.ArrayData)) throw new IllegalArgumentException("wrong data setup - there are values of type " + Reflection.getOrCreateKotlinClass(from.getClass()).getSimpleName() + " and " + Reflection.getOrCreateKotlinClass(to.getClass()).getSimpleName());
            this.merge((Data.ArrayData)from, (Data.ArrayData)to);
            return;
        } else {
            if (!(data instanceof Data.LeafData)) return;
            throw new IllegalArgumentException("wrong data setup - duplicate leaf value '" + ((Data.LeafData)from).getValue() + "' vs " + to);
        }
    }

    private final void merge(Data.MapData from, Data.MapData to) {
        for (Map.Entry<String, Data> entry : from.getData().entrySet()) {
            String key = entry.getKey();
            Data value2 = entry.getValue();
            Data existingValue = to.getData().get(key);
            if (existingValue == null) {
                to.getData().put(key, value2);
                continue;
            }
            this.merge(value2, existingValue);
        }
    }

    private final void merge(Data.ArrayData from, Data.ArrayData to) {
        for (Map.Entry<Integer, Data> entry : from.getByIndex().entrySet()) {
            int index = ((Number)entry.getKey()).intValue();
            Data value2 = entry.getValue();
            Data existingValue = to.getByIndex().get(index);
            if (existingValue == null) {
                Integer n = index;
                to.getByIndex().put(n, value2);
                continue;
            }
            this.merge(value2, existingValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object replaceDataHolders(Data from) {
        Object object;
        Data data = from;
        if (data instanceof Data.MapData) {
            void $this$mapValuesTo$iv$iv;
            Map<String, Data> $this$mapValues$iv = ((Data.MapData)from).getData();
            boolean $i$f$mapValues = false;
            Map<String, Data> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Data v = (Data)entry2.getValue();
                Object object2 = INSTANCE.replaceDataHolders(v);
                map3.put(k, object2);
            }
            object = destination$iv$iv;
        } else if (data instanceof Data.ArrayData) {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = ((Data.ArrayData)from).getByIndex().entrySet();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
                }
            });
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.replaceDataHolders((Data)it.getValue()));
            }
            object = (List)destination$iv$iv;
        } else if (data instanceof Data.LeafData) {
            object = ((Data.LeafData)from).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Data unflatten(String key, Data value2) {
        String currentKey = key;
        Data currentValue = value2;
        while (StringUtilKt.isNotBlankEffective(currentKey)) {
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)'.', (int)0, (boolean)false, (int)6, null);
            int bracketIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)']', (int)0, (boolean)false, (int)6, null);
            if (dotIndex < 0 && bracketIndex < 0) {
                currentValue = new Data.MapData(currentKey, currentValue);
                break;
            }
            if (dotIndex >= 0 && bracketIndex < dotIndex) {
                String subKey;
                Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(dotIndex + 1), (String)"this as java.lang.String).substring(startIndex)");
                currentValue = new Data.MapData(subKey, currentValue);
                Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(0, dotIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                continue;
            }
            int openingBracketIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)'[', (int)0, (boolean)false, (int)6, null);
            String string = currentKey.substring(openingBracketIndex + 1, bracketIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int index = Integer.parseInt(string);
            Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(0, openingBracketIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            currentValue = new Data.ArrayData(index, currentValue);
        }
        return currentValue;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "", "ArrayData", "LeafData", "MapData", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$LeafData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "harmonysoft-common"})
    private static interface Data {

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "index", "", "data", "(ILtech/harmonysoft/oss/common/collection/CollectionUtil$Data;)V", "byIndex", "", "getByIndex", "()Ljava/util/Map;", "toString", "", "harmonysoft-common"})
        public static final class ArrayData
        implements Data {
            @NotNull
            private final Map<Integer, Data> byIndex;

            /*
             * WARNING - void declaration
             */
            public ArrayData(int index, @NotNull Data data) {
                void $this$byIndex_u24lambda_u2d0;
                Map map;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Map map2 = map = (Map)new LinkedHashMap();
                ArrayData arrayData = this;
                boolean bl = false;
                Integer n = index;
                $this$byIndex_u24lambda_u2d0.put(n, data);
                arrayData.byIndex = map;
            }

            @NotNull
            public final Map<Integer, Data> getByIndex() {
                return this.byIndex;
            }

            @NotNull
            public String toString() {
                return CollectionsKt.joinToString$default((Iterable)this.byIndex.entrySet(), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "key", "", "value", "(Ljava/lang/String;Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;)V", "data", "", "getData", "()Ljava/util/Map;", "toString", "harmonysoft-common"})
        public static final class MapData
        implements Data {
            @NotNull
            private final Map<String, Data> data;

            /*
             * WARNING - void declaration
             */
            public MapData(@NotNull String key, @NotNull Data value2) {
                void $this$data_u24lambda_u2d0;
                Map map;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Map map2 = map = (Map)new LinkedHashMap();
                MapData mapData = this;
                boolean bl = false;
                $this$data_u24lambda_u2d0.put(key, value2);
                mapData.data = map;
            }

            @NotNull
            public final Map<String, Data> getData() {
                return this.data;
            }

            @NotNull
            public String toString() {
                return this.data.toString();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$LeafData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "value", "", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "toString", "", "harmonysoft-common"})
        public static final class LeafData
        implements Data {
            @NotNull
            private final Object value;

            public LeafData(@NotNull Object value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.value = value2;
            }

            @NotNull
            public final Object getValue() {
                return this.value;
            }

            @NotNull
            public String toString() {
                return this.value.toString();
            }
        }
    }
}

