/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.base.phoneinfo;

import android.app.Application;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;

public class PhoneInfoHelper {
    public static int screenWidth;
    public static int screenHeight;
    public static int dpi;
    public static int osv;
    public static String model;
    public static String sv;
    public static String net;
    public static String idfa;
    public static String platform;

    public static void init(Application context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        screenHeight = displayMetrics.heightPixels;
        screenWidth = displayMetrics.widthPixels;
        dpi = displayMetrics.densityDpi;
        model = Build.MODEL;
        osv = Build.VERSION.SDK_INT;
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        idfa = ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            sv = packInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        net = PhoneInfoHelper.getNetworkType(context);
        platform = Build.CPU_ABI;
    }

    public static String getNetworkType(Application context) {
        String strNetworkType = "";
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "wifi";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2g";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3g";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4g";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3g" : _strSubTypeName;
                    }
                }
            }
        }
        return strNetworkType;
    }
}

