/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import java.io.IOException;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.RenderListener;
import rst.pdfbox.layout.text.DrawContext;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.Annotated;
import rst.pdfbox.layout.text.annotations.AnnotationProcessor;
import rst.pdfbox.layout.text.annotations.AnnotationProcessorFactory;

public class AnnotationDrawListener
implements DrawListener,
RenderListener {
    private final DrawContext drawContext;
    private final Iterable<AnnotationProcessor> annotationProcessors;

    public AnnotationDrawListener(DrawContext drawContext) {
        this.drawContext = drawContext;
        this.annotationProcessors = AnnotationProcessorFactory.createAnnotationProcessors();
    }

    @Override
    public void drawn(Object drawnObject, Position upperLeft, float width, float height) {
        if (!(drawnObject instanceof Annotated)) {
            return;
        }
        for (AnnotationProcessor annotationProcessor : this.annotationProcessors) {
            try {
                annotationProcessor.annotatedObjectDrawn((Annotated)drawnObject, this.drawContext, upperLeft, width, height);
            }
            catch (IOException e) {
                throw new RuntimeException("exception on annotation processing", e);
            }
        }
    }

    @Deprecated
    public void finalizeAnnotations() throws IOException {
        this.afterRender();
    }

    @Override
    public void beforePage(RenderContext renderContext) throws IOException {
        for (AnnotationProcessor annotationProcessor : this.annotationProcessors) {
            try {
                annotationProcessor.beforePage(this.drawContext);
            }
            catch (IOException e) {
                throw new RuntimeException("exception on annotation processing", e);
            }
        }
    }

    @Override
    public void afterPage(RenderContext renderContext) throws IOException {
        for (AnnotationProcessor annotationProcessor : this.annotationProcessors) {
            try {
                annotationProcessor.afterPage(this.drawContext);
            }
            catch (IOException e) {
                throw new RuntimeException("exception on annotation processing", e);
            }
        }
    }

    public void afterRender() throws IOException {
        for (AnnotationProcessor annotationProcessor : this.annotationProcessors) {
            try {
                annotationProcessor.afterRender(this.drawContext.getPdDocument());
            }
            catch (IOException e) {
                throw new RuntimeException("exception on annotation processing", e);
            }
        }
    }
}

