/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.ControlFragment;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.SpaceUnit;
import rst.pdfbox.layout.text.StyledText;

public class Indent
extends ControlFragment {
    public static final Indent UNINDENT = new Indent(0.0f);
    protected float indentWidth = 4.0f;
    protected SpaceUnit indentUnit = SpaceUnit.em;
    protected Alignment alignment = Alignment.Left;
    protected StyledText styledText;

    public Indent(float indentWidth, SpaceUnit indentUnit) throws IOException {
        this("", indentWidth, indentUnit, DEFAULT_FONT_DESCRIPTOR, Alignment.Left, Color.black);
    }

    public Indent(String label, float indentWidth, SpaceUnit indentUnit, float fontSize, PDFont font) throws IOException {
        this(label, indentWidth, indentUnit, fontSize, font, Alignment.Left, Color.black);
    }

    public Indent(String label, float indentWidth, SpaceUnit indentUnit, float fontSize, PDFont font, Alignment alignment) throws IOException {
        this(label, indentWidth, indentUnit, fontSize, font, alignment, Color.black);
    }

    public Indent(String label, float indentWidth, SpaceUnit indentUnit, float fontSize, PDFont font, Alignment alignment, Color color) throws IOException {
        this(label, indentWidth, indentUnit, new FontDescriptor(font, fontSize), alignment, color);
    }

    public Indent(String label, float indentWidth, SpaceUnit indentUnit, FontDescriptor fontDescriptor, Alignment alignment, Color color) throws IOException {
        super("INDENT", label, fontDescriptor, color);
        float indent = this.calculateIndent(indentWidth, indentUnit, fontDescriptor);
        float textWidth = 0.0f;
        if (label != null && !label.isEmpty()) {
            textWidth = fontDescriptor.getSize() * fontDescriptor.getFont().getStringWidth(label) / 1000.0f;
        }
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (textWidth < indent) {
            switch (alignment) {
                case Left: {
                    marginRight = indent - textWidth;
                    break;
                }
                case Right: {
                    marginLeft = indent - textWidth;
                    break;
                }
                default: {
                    marginRight = marginLeft = (indent - textWidth) / 2.0f;
                }
            }
        }
        this.styledText = new StyledText(label, this.getFontDescriptor(), this.getColor(), 0.0f, marginLeft, marginRight);
    }

    public Indent(float indentPt) {
        super("", DEFAULT_FONT_DESCRIPTOR);
        this.styledText = new StyledText("", this.getFontDescriptor(), this.getColor(), 0.0f, indentPt, 0.0f);
    }

    private float calculateIndent(float indentWidth, SpaceUnit indentUnit, FontDescriptor fontDescriptor) throws IOException {
        if (indentWidth < 0.0f) {
            return 0.0f;
        }
        return indentUnit.toPt(indentWidth, fontDescriptor);
    }

    @Override
    public float getWidth() throws IOException {
        return this.styledText.getWidth();
    }

    public StyledText toStyledText() {
        return this.styledText;
    }

    @Override
    public String toString() {
        return "ControlFragment [" + this.getName() + ", " + this.styledText + "]";
    }
}

