/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Cutter;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.VerticalSpacer;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.WidthRespecting;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class ImageElement
implements Element,
Drawable,
Dividable,
WidthRespecting {
    public static final float SCALE_TO_RESPECT_WIDTH = -1.0f;
    private BufferedImage image;
    private float width;
    private float height;
    private float maxWidth = -1.0f;
    private Position absolutePosition;

    public ImageElement(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageElement(InputStream inputStream) throws IOException {
        this(ImageIO.read(inputStream));
    }

    public ImageElement(String filePath) throws IOException {
        this(ImageIO.read(new File(filePath)));
    }

    @Override
    public float getWidth() throws IOException {
        if (this.width == -1.0f) {
            if (this.getMaxWidth() > 0.0f && (float)this.image.getWidth() > this.getMaxWidth()) {
                return this.getMaxWidth();
            }
            return this.image.getWidth();
        }
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() throws IOException {
        if (this.height == -1.0f) {
            if (this.getMaxWidth() > 0.0f && (float)this.image.getWidth() > this.getMaxWidth()) {
                return this.getMaxWidth() / (float)this.image.getWidth() * (float)this.image.getHeight();
            }
            return this.image.getHeight();
        }
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @Override
    public Dividable.Divided divide(float remainingHeight, float nextPageHeight) throws IOException {
        if (this.getHeight() <= nextPageHeight) {
            return new Dividable.Divided(new VerticalSpacer(remainingHeight), this);
        }
        return new Cutter(this).divide(remainingHeight, nextPageHeight);
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public Position getAbsolutePosition() {
        return this.absolutePosition;
    }

    public void setAbsolutePosition(Position absolutePosition) {
        this.absolutePosition = absolutePosition;
    }

    @Override
    public void draw(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, DrawListener drawListener) throws IOException {
        CompatibilityHelper.drawImage(this.image, pdDocument, contentStream, upperLeft, this.getWidth(), this.getHeight());
        if (drawListener != null) {
            drawListener.drawn(this, upperLeft, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Drawable removeLeadingEmptyVerticalSpace() {
        return this;
    }
}

