package rst.pdfbox.layout.elements;

/**
 * In order to avoid dependencies to AWT, we use our own Rectangle class here.
 */
public class Rectangle extends Dimension {

    private final float x;
    private final float y;

    public Rectangle(float x, float y, float width, float height) {
	super(width, height);
	this.x = x;
	this.y = y;
    }

    public float getX() {
	return x;
    }

    public float getY() {
	return y;
    }

    @Override
    public String toString() {
	return "Rectangle [x=" + x + ", y=" + y + ", width=" + getWidth()
		+ ", height=" + getHeight() + "]";
    }

    @Override
    public int hashCode() {
	final int prime = 31;
	int result = super.hashCode();
	result = prime * result + Float.floatToIntBits(x);
	result = prime * result + Float.floatToIntBits(y);
	return result;
    }

    @Override
    public boolean equals(Object obj) {
	if (this == obj)
	    return true;
	if (!super.equals(obj))
	    return false;
	if (getClass() != obj.getClass())
	    return false;
	Rectangle other = (Rectangle) obj;
	if (Float.floatToIntBits(x) != Float.floatToIntBits(other.x))
	    return false;
	if (Float.floatToIntBits(y) != Float.floatToIntBits(other.y))
	    return false;
	return true;
    }

}
