/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;

public record JsonFile(String filePath) implements Supplier<String>,
Consumer<String>
{
    @Override
    public String get() {
        try {
            return Files.readString(Paths.get(this.filePath(), new String[0]).toAbsolutePath()).replaceAll("[\u0000-\u001f]", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(String jsonString) {
        try {
            Path path = Paths.get(this.filePath(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

