/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;

public record ByteFile(String filePath) implements Supplier<byte[]>,
Consumer<byte[]>
{
    @Override
    public byte[] get() {
        try {
            return Files.readAllBytes(Paths.get(this.filePath(), new String[0]).toAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(byte[] bytes) {
        try {
            Path path = Paths.get(this.filePath(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

