/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import tech.deplant.commons.Objs;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.jtype.SdkDocs;
import tech.deplant.java4ever.binding.generator.jtype.SdkDummy;
import tech.deplant.java4ever.binding.generator.jtype.SdkEnum;
import tech.deplant.java4ever.binding.generator.jtype.SdkFunction;
import tech.deplant.java4ever.binding.generator.jtype.SdkInterface;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.jtype.SdkRecord;
import tech.deplant.java4ever.binding.generator.reference.ApiFunction;
import tech.deplant.java4ever.binding.generator.reference.ApiModule;
import tech.deplant.java4ever.binding.generator.reference.ApiReference;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.EnumOfConsts;
import tech.deplant.java4ever.binding.generator.reference.EnumOfTypes;
import tech.deplant.java4ever.binding.generator.reference.RefType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.javapoet.CodeBlock;
import tech.deplant.javapoet.JavaFile;
import tech.deplant.javapoet.TypeSpec;

public class ParserEngine {
    private static final System.Logger logger = System.getLogger(ParserEngine.class.getName());

    public static ApiReference ofJsonString(String resourceName) throws JsonProcessingException {
        return (ApiReference)JsonContext.SDK_JSON_MAPPER().readValue(resourceName, ApiReference.class);
    }

    public static void parse(ApiReference parsedApiReference) throws IOException {
        String apiVersion = parsedApiReference.version();
        HashMap<SdkType, SdkObject> typeLibrary = new HashMap<SdkType, SdkObject>();
        HashMap<SdkType, SdkInterfaceParent> eotReferences = new HashMap<SdkType, SdkInterfaceParent>();
        for (ApiModule module : parsedApiReference.modules()) {
            String moduleCapitalName = ParserUtils.capitalize(module.name());
            HashMap<String, TypeSpec.Builder> appObjects = new HashMap<String, TypeSpec.Builder>();
            block10: for (ApiType type : module.types()) {
                ApiType apiType;
                Objects.requireNonNull(type);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnumOfConsts.class, StructType.class, EnumOfTypes.class}, (Object)apiType, n)) {
                    case 0: {
                        EnumOfConsts en = (EnumOfConsts)apiType;
                        SdkEnum jEnum = new SdkEnum(en.name(), en.enum_consts(), new SdkDocs(en.summary(), en.description()));
                        typeLibrary.put(new SdkType(moduleCapitalName, en.name()), jEnum);
                        continue block10;
                    }
                    case 1: {
                        StructType struct = (StructType)apiType;
                        boolean isParams = false;
                        boolean isResult = false;
                        if (struct.name().length() >= 8) {
                            isParams = "ParamsOf".equals(struct.name().substring(0, 8));
                            isResult = "ResultOf".equals(struct.name().substring(0, 8));
                        }
                        boolean isSimpleWrapper = struct.struct_fields().length == 1;
                        typeLibrary.put(new SdkType(moduleCapitalName, struct.name()), new SdkRecord(struct, struct.name(), null, isSimpleWrapper, isParams, isResult, typeLibrary));
                        continue block10;
                    }
                    case 2: {
                        EnumOfTypes eot = (EnumOfTypes)apiType;
                        ArrayList<SdkRecord> records = new ArrayList<SdkRecord>();
                        String interfaceName = "Abi".equals(eot.name()) ? "ABI" : eot.name();
                        boolean isAppObject = Strings.safeSubstrEquals((String)interfaceName, (int)0, (int)11, (boolean)false, (String)"ParamsOfApp") || Strings.safeSubstrEquals((String)interfaceName, (int)0, (int)11, (boolean)false, (String)"ResultOfApp");
                        String appObjectName = "";
                        if (isAppObject) {
                            appObjectName = Strings.substr((String)interfaceName, (int)8);
                            if (!appObjects.containsKey(appObjectName)) {
                                logger.log(System.Logger.Level.WARNING, appObjectName);
                                appObjects.put(appObjectName, TypeSpec.interfaceBuilder((String)appObjectName));
                            } else {
                                logger.log(System.Logger.Level.WARNING, "Has appObject: " + appObjectName);
                            }
                        }
                        block11: for (ApiType eotChildType : eot.enum_types()) {
                            ApiType apiType2;
                            Objects.requireNonNull(eotChildType);
                            int n2 = 0;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructType.class, RefType.class}, (Object)apiType2, n2)) {
                                case 0: {
                                    StructType str = (StructType)apiType2;
                                    records.add(SdkRecord.ofApiType(str, typeLibrary, new SdkInterfaceParent(moduleCapitalName, interfaceName, str.name())));
                                    continue block11;
                                }
                                case 1: {
                                    RefType ref = (RefType)apiType2;
                                    eotReferences.put(TypeReference.fromApiType(ref).toSdkType(), new SdkInterfaceParent(moduleCapitalName, interfaceName, ref.name()));
                                    continue block11;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected value: " + String.valueOf(eotChildType));
                                }
                            }
                        }
                        SdkInterface javaInterface = new SdkInterface(eot, interfaceName, new SdkDocs(eot.summary(), eot.description()), records);
                        typeLibrary.put(new SdkType(moduleCapitalName, interfaceName), javaInterface);
                        continue block10;
                    }
                    default: {
                        typeLibrary.put(new SdkType(moduleCapitalName, type.name()), new SdkDummy(type));
                    }
                }
            }
        }
        eotReferences.forEach((typ, sup) -> Objs.notNullDo((Object)((SdkObject)typeLibrary.get(typ)), jtype -> typeLibrary.put((SdkType)typ, ((SdkRecord)jtype).withSuperInterface((SdkInterfaceParent)sup))));
        for (ApiModule module : parsedApiReference.modules()) {
            if ("debot".equals(module.name())) continue;
            TypeSpec.Builder moduleBuilder = ParserEngine.moduleToBuilder(module, ParserUtils.capitalize(module.name()), apiVersion);
            String moduleCapitalName = ParserUtils.capitalize(module.name());
            List<SdkObject> types = typeLibrary.entrySet().stream().filter(entry -> moduleCapitalName.equals(((SdkType)entry.getKey()).module())).map(Map.Entry::getValue).toList();
            eotReferences.forEach((typ, sup) -> {});
            for (SdkObject typeRef : types) {
                TypeSpec.Builder builder = typeRef.poeticize();
                if (Objects.isNull(builder)) continue;
                moduleBuilder.addType(builder.build());
            }
            for (ApiFunction function : module.functions()) {
                moduleBuilder.addMethod(new SdkFunction(module.name().toLowerCase(), function, typeLibrary).poeticize().build());
            }
            JavaFile javaFile = JavaFile.builder((String)"tech.deplant.java4ever.binding", (TypeSpec)moduleBuilder.build()).build();
            javaFile.writeTo(Paths.get("src/gen/java", new String[0]));
        }
    }

    public static TypeSpec.Builder moduleToBuilder(ApiModule module, String moduleNameCapitalized, String version) {
        return TypeSpec.classBuilder((String)moduleNameCapitalized).addJavadoc(ParserEngine.moduleDocs(module, moduleNameCapitalized, version).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    public static CodeBlock.Builder moduleDocs(ApiModule module, String moduleNameCapitalized, String version) {
        return CodeBlock.builder().add(String.format("<strong>%s</strong>\nContains methods of \"%s\" module of EVER-SDK API\n<p>\n%s %s\n@version %s\n", moduleNameCapitalized, module.name(), Objects.requireNonNullElse(module.summary(), ""), Objects.requireNonNullElse(module.description(), ""), version), new Object[0]);
    }

    public record SdkType(String module, String name) {
    }

    public record SdkInterfaceParent(String module, String name, String variantName) {
    }
}

