/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.deplant.commons.regex.AnyOf;
import tech.deplant.commons.regex.GroupOf;
import tech.deplant.commons.regex.Occurences;
import tech.deplant.commons.regex.RegExpBuilder;
import tech.deplant.commons.regex.Special;
import tech.deplant.commons.regex.Symbol;
import tech.deplant.commons.regex.Then;
import tech.deplant.commons.regex.Word;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;

public record AbiType(AbiTypePrefix prefix, int size, boolean isArray) {
    private static final System.Logger logger = System.getLogger(AbiType.class.getName());

    public AbiType(AbiTypePrefix prefix, int size) {
        this(prefix, size, false);
    }

    public AbiType(AbiTypePrefix prefix) {
        this(prefix, 0, false);
    }

    public static AbiType of(String typeString) throws EverSdkException {
        if (typeString.contains("optional")) {
            return new AbiType(AbiTypePrefix.OPTIONAL, 0, false);
        }
        Pattern expr = new Then(new RegExpBuilder[]{new GroupOf((RegExpBuilder)new Occurences((RegExpBuilder)new AnyOf(new Word((CharSequence)"a-zA-Z")), Integer.valueOf(1))), new GroupOf((RegExpBuilder)new Occurences((RegExpBuilder)Special.DIGIT, Integer.valueOf(1), Integer.valueOf(3)))}).toPattern();
        Matcher matcher = expr.matcher(typeString);
        if (matcher.find()) {
            return new AbiType(AbiTypePrefix.valueOf(matcher.group(1).toUpperCase()), Integer.parseInt(matcher.group(2)), AbiType.arrayMatcher(typeString));
        }
        matcher = Pattern.compile("([a-zA-Z]+)").matcher(typeString);
        if (matcher.find()) {
            return new AbiType(AbiTypePrefix.valueOf(matcher.group(1).toUpperCase()), 0, AbiType.arrayMatcher(typeString));
        }
        EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-300L, "ABI Type parsing failed! Type: " + typeString), (Throwable)new RuntimeException());
        logger.log(System.Logger.Level.WARNING, () -> "ABI type parsing failed! Type: " + typeString);
        throw ex;
    }

    public static boolean arrayMatcher(String typeString) {
        Pattern arrayPattern = new Then(new RegExpBuilder[]{new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Occurences((RegExpBuilder)new AnyOf(new Word((CharSequence)"a-zA-Z")), Integer.valueOf(1)), new Occurences((RegExpBuilder)Special.DIGIT, Integer.valueOf(0), Integer.valueOf(3))})), new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Symbol('['), new Symbol(']')}))}).toPattern();
        Matcher matcher = arrayPattern.matcher(typeString);
        return matcher.find();
    }

    boolean hasSize() {
        return switch (this.prefix()) {
            case AbiTypePrefix.INT, AbiTypePrefix.UINT, AbiTypePrefix.BYTES -> {
                if (this.size() > 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public Abi.AbiParam toAbiParam(String paramName, Abi.AbiParam[] components) {
        return new Abi.AbiParam(paramName, this.abiName(), null, null);
    }

    public String abiName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.prefix().name().toLowerCase(Locale.ROOT));
        if (this.hasSize()) {
            builder.append(this.size());
        }
        return builder.toString();
    }
}

