/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract.multisig;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DeployHandle;
import tech.deplant.java4ever.framework.contract.GiverContract;
import tech.deplant.java4ever.framework.contract.multisig.MultisigContract;
import tech.deplant.java4ever.framework.template.SafeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SetcodeMultisigWalletTemplate;
import tech.deplant.java4ever.framework.template.SurfMultisigWalletTemplate;

public class MultisigBuilder {
    private final Set<BigInteger> publicKeys = new HashSet<BigInteger>();
    private MultisigContract.Type type = MultisigContract.Type.SURF;
    private int confirmations = 1;
    private Credentials deployKeys;

    public DeployHandle<? extends MultisigContract> prepare(int contextId, Credentials deployKeys) throws JsonProcessingException {
        BigInteger[] owners = null;
        owners = this.publicKeys.isEmpty() ? new BigInteger[]{deployKeys.publicKeyBigInt()} : (BigInteger[])this.publicKeys.toArray(BigInteger[]::new);
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case MultisigContract.Type.SURF -> new SurfMultisigWalletTemplate().prepareDeploy(contextId, (int)EverSdk.getDefaultWorkchainId((int)contextId), deployKeys, owners, this.confirmations);
            case MultisigContract.Type.SAFE -> new SafeMultisigWalletTemplate().prepareDeploy(contextId, (int)EverSdk.getDefaultWorkchainId((int)contextId), deployKeys, owners, this.confirmations);
            case MultisigContract.Type.SETCODE -> new SetcodeMultisigWalletTemplate().prepareDeploy(contextId, (int)EverSdk.getDefaultWorkchainId((int)contextId), deployKeys, owners, this.confirmations);
        };
    }

    public MultisigContract prepareAndDeploy(int contextId, Credentials deployKeys, GiverContract giver, BigInteger value) throws JsonProcessingException, EverSdkException {
        BigInteger[] owners = null;
        owners = this.publicKeys.isEmpty() ? new BigInteger[]{deployKeys.publicKeyBigInt()} : (BigInteger[])this.publicKeys.toArray(BigInteger[]::new);
        return this.prepare(contextId, deployKeys).deployWithGiver(giver, value);
    }

    public Credentials deployKeys() {
        return this.deployKeys;
    }

    public MultisigBuilder setDeployKeys(Credentials deployKeys) {
        this.deployKeys = deployKeys;
        return this;
    }

    public MultisigBuilder addOwner(BigInteger pubkey) {
        this.publicKeys.add(pubkey);
        return this;
    }

    public MultisigBuilder removeOwner(BigInteger pubkey) {
        this.publicKeys.remove(pubkey);
        return this;
    }

    public MultisigContract.Type type() {
        return this.type;
    }

    public MultisigBuilder setType(MultisigContract.Type type) {
        this.type = type;
        return this;
    }

    public int confirmations() {
        return this.confirmations;
    }

    public MultisigBuilder setConfirmations(int confirmations) {
        this.confirmations = confirmations;
        return this;
    }
}

