/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DebugOptions;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.contract.AbstractContract;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.contract.GiverContract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.template.AbstractTemplate;
import tech.deplant.java4ever.framework.template.Template;

public record DeployHandle<RETURN extends AbstractContract>(Class<RETURN> clazz, int sdk, Template template, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader, String abiVersion, DebugOptions debugOptions) {
    private static System.Logger logger = System.getLogger(DeployHandle.class.getName());

    public DeployHandle(Class<RETURN> clazz, int sdk, ContractAbi abi, Tvc tvc, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader) {
        this(clazz, sdk, new AbstractTemplate(abi, tvc), workchainId, credentials, initialDataFields, constructorInputs, constructorHeader);
    }

    public DeployHandle(Class<RETURN> clazz, int sdk, Template template, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader) {
        this(clazz, sdk, template, workchainId, credentials, initialDataFields, constructorInputs, constructorHeader, "2.2", new DebugOptions(false, 60000L, false, 50L, new ContractAbi[0]));
    }

    public String encodeInitialDataBase64() throws EverSdkException {
        Abi.ResultOfEncodeInitialData result = (Abi.ResultOfEncodeInitialData)EverSdk.await((CompletableFuture)Abi.encodeInitialData((int)this.sdk(), (Abi.ABI)this.template().abi().ABI(), (JsonNode)((JsonNode)JsonContext.convertAbiMap(this.initialDataFields(), JsonNode.class)), (String)this.credentials().publicKey(), null));
        return result.data();
    }

    public DeployHandle<RETURN> withDebugTree(boolean enabled, long timeout, boolean throwErrors, long maxTransactionCount, ContractAbi ... treeAbis) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader(), this.abiVersion(), new DebugOptions(enabled, timeout, throwErrors, maxTransactionCount, treeAbis));
    }

    public DeployHandle<RETURN> withDebugTree(DebugOptions debugOptions) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader(), this.abiVersion(), debugOptions);
    }

    public <T extends AbstractContract> DeployHandle<T> withReturnClass(Class<T> returnClass) {
        return new DeployHandle<T>(returnClass, this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withConstructorHeader(Abi.FunctionHeader constructorHeader) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), constructorHeader);
    }

    public DeployHandle<RETURN> withConstructorInputs(Map<String, Object> constructorInputs) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), constructorInputs, this.constructorHeader());
    }

    public DeployHandle<RETURN> withInitDataFields(Map<String, Object> initialDataFields) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), initialDataFields, this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withCredentials(Credentials credentials) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), credentials, this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public Abi.DeploySet toDeploySet() throws EverSdkException {
        return new Abi.DeploySet(this.template().tvc().base64String(), null, null, Long.valueOf(this.workchainId()), JsonContext.ABI_JSON_MAPPER().valueToTree(this.template().abi().convertInitDataInputs(this.initialDataFields())), Objects.requireNonNullElse(this.credentials(), Credentials.NONE).publicKey());
    }

    public Abi.CallSet toConstructorCallSet() throws EverSdkException {
        return new Abi.CallSet("constructor", this.constructorHeader(), JsonContext.ABI_JSON_MAPPER().valueToTree(this.template().abi().convertFunctionInputs("constructor", this.constructorInputs())));
    }

    public Abi.Signer toSigner() {
        return ((Credentials)Objs.notNullElse((Object)this.credentials(), (Object)Credentials.NONE)).signer();
    }

    public Address toAddress() throws EverSdkException {
        return new Address(((Abi.ResultOfEncodeMessage)EverSdk.await((CompletableFuture)Abi.encodeMessage((int)this.sdk(), (Abi.ABI)this.template().abi().ABI(), null, (Abi.DeploySet)this.toDeploySet(), null, (Abi.Signer)this.toSigner(), null, null))).address());
    }

    public RETURN deployWithGiver(GiverContract giver, BigInteger value) throws EverSdkException {
        Address address = this.toAddress();
        try {
            AbstractContract uninitContract = new AbstractContract(this.sdk(), address, this.template().abi(), Credentials.NONE);
            CompletableFuture waiter = new CompletableFuture();
            Consumer<JsonNode> eventConsumer = waiter::complete;
            uninitContract.subscribeOnTransactions(eventConsumer, "in_message", "{ src }", "aborted", "status").subscribeUntilFirst(this.sdk());
            giver.give(address, value).call();
            waiter.get(10L, TimeUnit.MINUTES);
            return this.deploy(address);
        }
        catch (InterruptedException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Wait for giver funds interrupted! Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Wait for giver funds timeout! Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-402L, "EVER-SDK Execution expired on Timeout!"), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Wait for giver funds failed! Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call failed!"), (Throwable)e);
        }
    }

    public RETURN deploy() throws EverSdkException {
        Address address = this.toAddress();
        return this.deploy(address);
    }

    private RETURN deploy(Address address) throws EverSdkException {
        EverSdk.await((CompletableFuture)Processing.processMessage((int)this.sdk(), (Abi.ABI)this.template().abi().ABI(), (String)address.makeAddrStd(), (Abi.DeploySet)this.toDeploySet(), (Abi.CallSet)this.toConstructorCallSet(), (Abi.Signer)this.toSigner(), null, null, (Boolean)false));
        Map<String, Credentials> contractMap = Map.of("sdk", this.sdk(), "address", address, "abi", this.template().abi(), "credentials", this.credentials());
        Object contract = Contract.instantiate(this.clazz(), this.sdk(), address.makeAddrStd(), this.template().abi(), this.credentials());
        logger.log(System.Logger.Level.TRACE, () -> "Contract deployed and instantiated: %s".formatted(contract == null ? "" : contract.toString()));
        return contract;
    }
}

