/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.contract.AbstractContract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;

public interface Contract {
    public static final System.Logger logger = System.getLogger(Contract.class.getName());

    public static <IMPL extends AbstractContract> IMPL instantiate(Class<IMPL> clazz, int sdk, String address, ContractAbi abi, Credentials credentials) {
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (!Arrays.equals(c.getParameterTypes(), new Class[]{Integer.TYPE, String.class, ContractAbi.class, Credentials.class})) continue;
            try {
                return (IMPL)((AbstractContract)c.newInstance(sdk, address, abi, credentials));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    default public BigInteger accountBalance() throws EverSdkException {
        return Uint.of(128, (Object)this.account().balance()).toJava();
    }

    default public Account account() throws EverSdkException {
        return Account.ofAddress(this.contextId(), this.address());
    }

    public int contextId();

    public Address address();

    public ContractAbi abi();

    public Credentials credentials();

    default public FunctionHandle<Map<String, Object>> prepareCall(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) {
        return new FunctionHandle<Map<String, Object>>(this.contextId(), this.address(), this.abi(), this.credentials(), functionName, functionInputs, functionHeader);
    }

    default public Abi.DecodedMessageBody decodeMessageBoc(TvmCell messageBoc) throws EverSdkException {
        return (Abi.DecodedMessageBody)EverSdk.await((CompletableFuture)Abi.decodeMessage((int)this.contextId(), (Abi.ABI)this.abi().ABI(), (String)messageBoc.cellBoc(), (Boolean)false, null, null));
    }
}

