/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.subscription.Subscriptions;

public class AbstractContract
implements Contract {
    private final int contextId;
    private final Address address;
    private final ContractAbi abi;
    private Credentials credentials;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") Address address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this.contextId = contextId;
        this.address = address;
        this.abi = abi;
        this.credentials = credentials;
    }

    public AbstractContract(@JsonProperty(value="contextId") int contextId, @JsonProperty(value="address") String address, @JsonProperty(value="abi") ContractAbi abi, @JsonProperty(value="credentials") Credentials credentials) {
        this.contextId = contextId;
        this.address = new Address(address);
        this.abi = abi;
        this.credentials = credentials;
    }

    public Subscriptions.Builder subscribeOnIncomingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onMessages(resultFields).addFilterOnSubscription("dst: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnOutgoingMessages(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onMessages(resultFields).addFilterOnSubscription("src: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnAccount(String resultFields, Consumer<JsonNode> subscribeEventConsumer) throws EverSdkException {
        return Subscriptions.onAccounts(resultFields).addFilterOnSubscription("id: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public Subscriptions.Builder subscribeOnTransactions(Consumer<JsonNode> subscribeEventConsumer, String ... resultFields) throws EverSdkException {
        return Subscriptions.onAccounts(resultFields).addFilterOnSubscription("id: { eq: \"%s\" }".formatted(this.address().toString())).addCallbackConsumer(subscribeEventConsumer);
    }

    public FunctionHandle.Builder functionCallBuilder() {
        return new FunctionHandle.Builder(JsonNode.class).setContract(this);
    }

    @Override
    public int contextId() {
        return this.contextId;
    }

    @Override
    public Address address() {
        return this.address;
    }

    @Override
    public ContractAbi abi() {
        return this.abi;
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    public int hashCode() {
        return Objects.hash(this.address(), this.abi(), this.credentials());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractContract)) {
            return false;
        }
        AbstractContract that = (AbstractContract)o;
        return Objects.equals(this.address(), that.address()) && Objects.equals(this.abi(), that.abi()) && Objects.equals(this.credentials(), that.credentials());
    }
}

