/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.gql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.SubscribeEvent;
import tech.deplant.java4ever.framework.Sdk;

public record SubscribeHandle(Sdk sdk, long handle) {
    private static System.Logger logger = System.getLogger(SubscribeHandle.class.getName());

    public static SubscribeHandle subscribe(Sdk sdk, String queryText, Consumer<SubscribeEvent> subscribeEventConsumer) throws EverSdkException {
        Net.ResultOfSubscribeCollection result = Net.subscribe((EverSdkContext)sdk.context(), (String)queryText, (JsonNode)JsonContext.EMPTY_NODE(), handler -> {
            try {
                subscribeEventConsumer.accept(new SubscribeEvent(JsonContext.ABI_JSON_MAPPER().readTree(handler.params())));
            }
            catch (JsonProcessingException e) {
                logger.log(System.Logger.Level.WARNING, () -> ((JsonProcessingException)e).getMessage());
                subscribeEventConsumer.accept(new SubscribeEvent(null));
            }
        });
        return new SubscribeHandle(sdk, result.handle());
    }

    public void unsubscribe() throws EverSdkException {
        Net.unsubscribe((EverSdkContext)this.sdk.context(), (Net.ResultOfSubscribeCollection)new Net.ResultOfSubscribeCollection(Long.valueOf(this.handle())));
    }
}

