/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.Bool;
import tech.deplant.java4ever.framework.datatype.SolBytes;
import tech.deplant.java4ever.framework.datatype.SolString;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.TypePrefix;
import tech.deplant.java4ever.framework.datatype.Uint;

public interface AbiType<JAVA_TYPE, JSON_TYPE> {
    public static AbiType of(TypePrefix prefix, int size, Object inputValue) throws EverSdkException {
        return switch (prefix) {
            default -> throw new MatchException(null, null);
            case TypePrefix.UINT, TypePrefix.INT -> Uint.fromJava(size, inputValue);
            case TypePrefix.STRING -> SolString.fromJava(inputValue);
            case TypePrefix.BYTES, TypePrefix.BYTE -> SolBytes.fromJava(inputValue);
            case TypePrefix.ADDRESS -> Address.fromJava(inputValue);
            case TypePrefix.BOOL -> Bool.fromJava(inputValue);
            case TypePrefix.CELL, TypePrefix.SLICE, TypePrefix.BUILDER -> TvmCell.fromJava(inputValue);
            case TypePrefix.TUPLE, TypePrefix.OPTIONAL -> {
                EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-301, "ABI Parsing unexpected! Shouldn't get here!"), (Throwable)new RuntimeException());
                System.getLogger(AbiType.class.getName()).log(System.Logger.Level.WARNING, () -> ex.toString());
                throw ex;
            }
        };
    }

    public static AbiType ofABI(TypePrefix prefix, int size, Object inputValue) throws EverSdkException {
        return switch (prefix) {
            default -> throw new MatchException(null, null);
            case TypePrefix.UINT, TypePrefix.INT -> Uint.fromJava(size, inputValue);
            case TypePrefix.STRING -> SolString.fromABI(inputValue.toString());
            case TypePrefix.BYTES, TypePrefix.BYTE -> SolBytes.fromABI(inputValue.toString());
            case TypePrefix.ADDRESS -> Address.fromABI(inputValue);
            case TypePrefix.BOOL -> Bool.fromJava(inputValue);
            case TypePrefix.CELL, TypePrefix.SLICE, TypePrefix.BUILDER -> TvmCell.fromJava(inputValue);
            case TypePrefix.TUPLE, TypePrefix.OPTIONAL -> {
                EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-301, "ABI Parsing unexpected! Shouldn't get here!"), (Throwable)new RuntimeException());
                System.getLogger(AbiType.class.getName()).log(System.Logger.Level.WARNING, () -> ex.toString());
                throw ex;
            }
        };
    }

    public Abi.AbiParam toAbiParam(String var1);

    public String abiTypeName();

    public JAVA_TYPE toJava();

    public JSON_TYPE toABI();
}

