/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.List;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.CurrencyUnit;
import tech.deplant.java4ever.framework.DeployHandle;
import tech.deplant.java4ever.framework.MessageFlag;
import tech.deplant.java4ever.framework.ResultOfTree;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.MultisigWallet;
import tech.deplant.java4ever.framework.contract.TIP3TokenRoot;
import tech.deplant.java4ever.framework.contract.TIP3TokenWallet;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.template.TIP3TokenRootTemplate;
import tech.deplant.java4ever.framework.template.TIP3TokenWalletTemplate;

public interface TIP3 {
    public static TIP3TokenRoot deployRoot(Sdk sdk, Credentials deployKeys, BigInteger nonce, Contract owner, Giver giver, String name, String symbol, int decimals) throws JsonProcessingException, EverSdkException {
        Address ownerAddr = new Address(owner.address());
        DeployHandle<TIP3TokenRoot> deployStatement = new TIP3TokenRootTemplate().prepareDeploy(sdk, deployKeys, name, symbol, decimals, ownerAddr, TIP3TokenWalletTemplate.DEFAULT_TVC().codeCell(sdk), nonce, Address.ZERO, Address.ZERO, BigInteger.ZERO, BigInteger.ZERO, false, false, false, ownerAddr);
        return deployStatement.deployWithGiver(giver, CurrencyUnit.VALUE((CurrencyUnit)CurrencyUnit.Ever.EVER, "5"));
    }

    public static TIP3TokenWallet deployWallet(Sdk sdk, TIP3TokenRoot root, MultisigWallet rootOwner, Address tokenOwnerAddress) throws JsonProcessingException, EverSdkException {
        TvmCell payload = root.deployWallet(tokenOwnerAddress, CurrencyUnit.VALUE((CurrencyUnit)CurrencyUnit.Ever.EVER, "1")).toPayload();
        ResultOfTree<Void> result = rootOwner.sendTransaction(new Address(root.address()), CurrencyUnit.VALUE((CurrencyUnit)CurrencyUnit.Ever.EVER, "2"), true, MessageFlag.FEE_EXTRA.flag(), payload).callTree(true, List.of(TIP3TokenRootTemplate.DEFAULT_ABI(), TIP3TokenWalletTemplate.DEFAULT_ABI()));
        String walletAddress = result.extractDeployAddress(root.address());
        return new TIP3TokenWallet(sdk, walletAddress);
    }

    public static interface TIP31Root {
        public String name();

        public String symbol();

        public Integer decimals();

        public BigInteger totalSupply();

        public TvmCell walletCode();
    }
}

