/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Convert;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.abi.datatype.Uint;
import tech.deplant.java4ever.framework.crypto.Credentials;

public class OwnedContract {
    private static System.Logger logger = System.getLogger(OwnedContract.class.getName());
    protected final Sdk sdk;
    protected final String address;
    protected final ContractAbi abi;
    protected final Credentials credentials;

    public OwnedContract(Sdk sdk, String address, ContractAbi abi, Credentials credentials) {
        this.sdk = sdk;
        this.address = address;
        this.abi = abi;
        this.credentials = credentials;
    }

    public OwnedContract(Sdk sdk, String address, ContractAbi abi) {
        this(sdk, address, abi, Credentials.NONE);
    }

    public Sdk sdk() {
        return this.sdk;
    }

    public String address() {
        return this.address;
    }

    public ContractAbi abi() {
        return this.abi;
    }

    public BigInteger balance() throws EverSdkException {
        return Uint.fromJava(128, this.account().balance()).toJava();
    }

    public Account account() throws EverSdkException {
        return Account.ofAddress(this.sdk, this.address);
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String tvmPubkey() throws EverSdkException {
        return this.account().tvmPubkey(this.sdk(), this.abi());
    }

    public String encodeInternalPayload(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return Abi.encodeMessageBody((Context)this.sdk().context(), (Abi.ABI)this.abi().ABI(), (Abi.CallSet)new Abi.CallSet(functionName, functionHeader, this.abi().convertFunctionInputs(functionName, functionInputs)), (Boolean)true, (Abi.Signer)Credentials.NONE.signer(), null, (String)this.address()).body();
    }

    public Map<String, Object> runGetter(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return this.account().runGetter(this.sdk(), this.abi(), functionName, functionInputs, functionHeader, credentials);
    }

    public Map<String, Object> runGetter(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.runGetter(functionName, functionInputs, functionHeader, this.credentials);
    }

    public Map<String, Object> runGetter(Integer functionId, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return this.runGetter(Uint.fromJava(32, functionId).toABI(), functionInputs, functionHeader, credentials);
    }

    public Map<String, Object> runGetter(Integer functionId, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.runGetter(functionId, functionInputs, functionHeader, this.credentials);
    }

    private Processing.ResultOfProcessMessage processExternalCall(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return Processing.processMessage((Context)this.sdk.context(), (Abi.ABI)this.abi().ABI(), (String)this.address(), null, (Abi.CallSet)new Abi.CallSet(functionName, functionHeader, this.abi().convertFunctionInputs(functionName, functionInputs)), (Abi.Signer)Objects.requireNonNullElse(credentials, Credentials.NONE).signer(), null, (Boolean)false);
    }

    public ResultOfQueryTransactionTreeAndCallOutput callExternalDebugTree(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials, boolean debugThrowOnTreeErrors, List<ContractAbi> debugAbisForDecode) throws EverSdkException {
        Abi.ABI[] abiArray = (Abi.ABI[])Stream.concat(Stream.of(this.abi()), debugAbisForDecode.stream()).map(ContractAbi::ABI).toArray(Abi.ABI[]::new);
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall(functionName, functionInputs, functionHeader, credentials);
        String msgId = resultOfProcess.transaction().get("in_msg").toString();
        Net.ResultOfQueryTransactionTree debugOutResult = Net.queryTransactionTree((Context)this.sdk().context(), (String)msgId, (Abi.ABI[])abiArray, (Integer)this.sdk().debugTreeTimeout(), (Integer)0);
        for (Net.TransactionNode tr : debugOutResult.transactions()) {
            Net.MessageNode msg = Arrays.stream(debugOutResult.messages()).filter(msgElem -> msgElem.id().equals(tr.inMsg())).findFirst().get();
            Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", LogUtils.typeOfMessage(msg), LogUtils.nameOfMessage(msg), tr.id(), msg.id(), LogUtils.sourceOfMessage(msg), Convert.hexToDecOrZero(msg.value(), 9).toPlainString(), LogUtils.destOfMessage(msg), (int)tr.exitCode(), LogUtils.nameOfMessage(msg), Convert.hexToDecOrZero(tr.totalFees(), 9).toPlainString(), LogUtils.enquotedListAgg(tr.outMsgs()));
            if (tr.aborted().booleanValue() && debugThrowOnTreeErrors) {
                LogUtils.error(logger, lazyFormatLogMessage);
                throw new EverSdkException(new EverSdkException.ErrorResult(tr.exitCode().intValue(), "One of the message tree transaction was aborted!"), (Throwable)new Exception());
            }
            if (tr.aborted().booleanValue()) {
                LogUtils.warn(logger, lazyFormatLogMessage);
                continue;
            }
            LogUtils.info(logger, lazyFormatLogMessage);
        }
        return new ResultOfQueryTransactionTreeAndCallOutput(debugOutResult, resultOfProcess.decoded().output());
    }

    public Map<String, Object> callExternal(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        Processing.ResultOfProcessMessage resultOfProcess = this.processExternalCall(functionName, functionInputs, functionHeader, credentials);
        BigDecimal balanceDeltaStr = Convert.hexToDec(resultOfProcess.transaction().get("balance_delta").toString(), 9);
        Supplier<String> lazyFormatLogMessage = () -> String.format("\n|-----------------------------------------------------------\n|%s (%s):\n|  TR_ID: %s\n|  MSG_ID: %s\n|  (%s)--{%s E}-->(%s)\n|  Result: %d (%s)\n|  Fees: %s E\n|  Out Messages: [%s]\n|-----------------------------------------------------------\n", "EXTERNAL CALL", functionName, resultOfProcess.transaction().get("id").toString(), resultOfProcess.transaction().get("in_msg").toString(), "ext", new BigDecimal(Uint.fromJava(128, resultOfProcess.fees().totalFwdFees()).toJava(), 9).toPlainString(), resultOfProcess.transaction().get("account_addr").toString(), 0, functionName, new BigDecimal(Uint.fromJava(128, resultOfProcess.fees().totalAccountFees()).toJava(), 9).toPlainString(), "");
        LogUtils.info(logger, lazyFormatLogMessage);
        return Optional.ofNullable(resultOfProcess.decoded().output()).orElse(new HashMap());
    }

    public Map<String, Object> callExternal(String functionName, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.callExternal(functionName, functionInputs, functionHeader, this.credentials);
    }

    public Map<String, Object> callExternal(Integer functionId, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader, Credentials credentials) throws EverSdkException {
        return this.callExternal(Uint.fromJava(32, functionId).toABI(), functionInputs, functionHeader, credentials);
    }

    public Map<String, Object> callExternal(Integer functionId, Map<String, Object> functionInputs, Abi.FunctionHeader functionHeader) throws EverSdkException {
        return this.callExternal(functionId, functionInputs, functionHeader, this.credentials);
    }

    public record ResultOfQueryTransactionTreeAndCallOutput(Net.ResultOfQueryTransactionTree queryTree, Map<String, Object> decodedOutuput) {
    }
}

