/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.framework.EnvironmentConfig;
import tech.deplant.java4ever.framework.ExplorerConfig;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.crypto.Credentials;

public record Sdk(Context context, long debugTreeTimeout, Client.ClientConfig clientConfig, ExplorerConfig explorerConfig, EnvironmentConfig environmentConfig) {
    public String[] endpoints() {
        return this.clientConfig().network().endpoints();
    }

    public String version() throws EverSdkException {
        return Client.version((Context)this.context()).version();
    }

    public <T> T convertMap(Map<String, Object> inputMap, Class<T> outputClass) {
        return (T)this.context().mapper().convertValue(inputMap, outputClass);
    }

    public JsonNode parseStruct(Object struct) throws JsonProcessingException {
        return this.context().mapper().readTree(this.serialize(struct));
    }

    public <T> T deserialize(String inputString, Class<T> outputClass) throws JsonProcessingException {
        return (T)this.context().mapper().readValue(inputString, outputClass);
    }

    public String serialize(Object inputObject) throws JsonProcessingException {
        return this.context().mapper().writeValueAsString(inputObject);
    }

    public void saveContract(String name, OwnedContract contract) throws IOException {
        this.explorerConfig().addContract(name, contract);
    }

    public void saveKeys(String name, Credentials keys) throws IOException {
        this.explorerConfig().credentials().put(name, keys);
        this.explorerConfig().sync();
    }

    public Tvm.ExecutionOptions executionOptions() {
        return null;
    }
}

