/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.giver;

import java.math.BigInteger;
import java.util.HashMap;
import lombok.Generated;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.giver.Giver;

public final class MultiSigGiver
implements Giver {
    private final Credentials credentials;
    private final Account account;

    public MultiSigGiver(Sdk sdk, Address address, Credentials credentials) throws Sdk.SdkException {
        this.credentials = credentials;
        this.account = Account.ofAddress(sdk, address, ContractAbi.SAFE_MULTISIG);
    }

    @Override
    public void give(Address to, BigInteger amount) throws Sdk.SdkException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dest", to.makeAddrStd());
        params.put("value", amount);
        params.put("bounce", false);
        params.put("flags", 0);
        params.put("payload", "");
        this.account.callExternal(this.credentials, "sendTransaction", params);
    }

    @Generated
    public Credentials credentials() {
        return this.credentials;
    }

    @Generated
    public Account account() {
        return this.account;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiSigGiver)) {
            return false;
        }
        MultiSigGiver other = (MultiSigGiver)o;
        Credentials this$credentials = this.credentials();
        Credentials other$credentials = other.credentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        Account this$account = this.account();
        Account other$account = other.account();
        return !(this$account == null ? other$account != null : !((Object)this$account).equals(other$account));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Credentials $credentials = this.credentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        Account $account = this.account();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MultiSigGiver(credentials=" + this.credentials() + ", account=" + this.account() + ")";
    }
}

