/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.framework.AccountController;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.Artifact;

public final class ExplorerConfig {
    @Generated
    private static final Logger log = LogManager.getLogger(ExplorerConfig.class);
    private final Map<String, ContractConfig> contracts = new HashMap<String, ContractConfig>();

    public static ExplorerConfig ofConfigFile(Artifact artifact) {
        return (ExplorerConfig)new Gson().fromJson(artifact.getAsJsonString(), ExplorerConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String path) throws IOException {
        FileWriter file = new FileWriter(path);
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            file.write(gson.toJson((Object)this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            file.flush();
            file.close();
        }
    }

    public ExplorerConfig removeAccountController(String name) {
        this.contracts.remove(name);
        return this;
    }

    public ExplorerConfig addAccountController(String name, AccountController accountController) {
        this.contracts.put(name, new ContractConfig(accountController.account().abi().abiJsonString(), accountController.account().address().makeAddrStd(), accountController.internalOwner() != null ? accountController.internalOwner().account().address().makeAddrStd() : null, accountController.externalOwner()));
        return this;
    }

    public AccountController accountController(String name, Sdk sdk) throws Sdk.SdkException {
        ContractConfig acc = this.contracts.get(name);
        if (acc == null) {
            return null;
        }
        return AccountController.ofAddress(new ContractAbi(acc.abi()), new Address(acc.address()), sdk, acc.externalOwner(), null);
    }

    @Generated
    public Map<String, ContractConfig> contracts() {
        return this.contracts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplorerConfig)) {
            return false;
        }
        ExplorerConfig other = (ExplorerConfig)o;
        Map<String, ContractConfig> this$contracts = this.contracts();
        Map<String, ContractConfig> other$contracts = other.contracts();
        return !(this$contracts == null ? other$contracts != null : !((Object)this$contracts).equals(other$contracts));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ContractConfig> $contracts = this.contracts();
        result = result * 59 + ($contracts == null ? 43 : ((Object)$contracts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExplorerConfig(contracts=" + this.contracts() + ")";
    }

    public static final class ContractConfig {
        private final String abi;
        private final String address;
        private final String internalOwner;
        private final Credentials externalOwner;

        @Generated
        public ContractConfig(String abi, String address, String internalOwner, Credentials externalOwner) {
            this.abi = abi;
            this.address = address;
            this.internalOwner = internalOwner;
            this.externalOwner = externalOwner;
        }

        @Generated
        public String abi() {
            return this.abi;
        }

        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public String internalOwner() {
            return this.internalOwner;
        }

        @Generated
        public Credentials externalOwner() {
            return this.externalOwner;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractConfig)) {
                return false;
            }
            ContractConfig other = (ContractConfig)o;
            String this$abi = this.abi();
            String other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$internalOwner = this.internalOwner();
            String other$internalOwner = other.internalOwner();
            if (this$internalOwner == null ? other$internalOwner != null : !this$internalOwner.equals(other$internalOwner)) {
                return false;
            }
            Credentials this$externalOwner = this.externalOwner();
            Credentials other$externalOwner = other.externalOwner();
            return !(this$externalOwner == null ? other$externalOwner != null : !((Object)this$externalOwner).equals(other$externalOwner));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $internalOwner = this.internalOwner();
            result = result * 59 + ($internalOwner == null ? 43 : $internalOwner.hashCode());
            Credentials $externalOwner = this.externalOwner();
            result = result * 59 + ($externalOwner == null ? 43 : ((Object)$externalOwner).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExplorerConfig.ContractConfig(abi=" + this.abi() + ", address=" + this.address() + ", internalOwner=" + this.internalOwner() + ", externalOwner=" + this.externalOwner() + ")";
        }
    }
}

