/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.ContractTvc;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Message;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Solc;
import tech.deplant.java4ever.framework.TvmLinker;
import tech.deplant.java4ever.framework.artifact.FileArtifact;
import tech.deplant.java4ever.framework.giver.Giver;

public final class ContractTemplate {
    @Generated
    private static final Logger log = LogManager.getLogger(ContractTemplate.class);
    public static final ContractTemplate SAFE_MULTISIG = new ContractTemplate(FileArtifact.ofResourcePath("/artifacts/std/SafeMultisigWallet.abi.json").getAsABI(), FileArtifact.ofResourcePath("/artifacts/std/SafeMultisigWallet.tvc").getAsTVC());
    private final ContractAbi abi;
    private final ContractTvc tvc;

    public ContractTemplate(ContractAbi abi, ContractTvc tvc) {
        this.abi = abi;
        this.tvc = tvc;
    }

    public static ContractTemplate ofSoliditySource(Solc solc, TvmLinker tvmLinker, String solidityPath, String buildPath, String filename, String contractName) {
        try {
            Process pSolc = solc.compileContract(contractName, filename, solidityPath, buildPath).get(300L, TimeUnit.SECONDS);
            if (pSolc.exitValue() == 0) {
                Process pLinker = tvmLinker.assemblyContract(contractName, buildPath).get(300L, TimeUnit.SECONDS);
                if (pLinker.exitValue() == 0) {
                    return new ContractTemplate(FileArtifact.ofAbsolutePath(buildPath + "/" + contractName + ".abi.json").getAsABI(), FileArtifact.ofAbsolutePath(buildPath + "/" + contractName + ".tvc").getAsTVC());
                }
                log.error("TvmLinker exit code:" + pLinker.exitValue());
                return null;
            }
            log.error("Solc exit code:" + pSolc.exitValue());
            return null;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public ContractTemplate insertPublicKey() {
        return this;
    }

    public ContractTemplate updateInitialData() {
        return this;
    }

    public Map<String, Object> deploy(Sdk sdk, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws Sdk.SdkException {
        return Message.decodeOutputMessage((Processing.DecodedOutput)((Processing.ResultOfProcessMessage)sdk.syncCall(Processing.processMessage((Context)sdk.context(), (Abi.ABI)this.abi.abiJson(), null, (Abi.DeploySet)new Abi.DeploySet(this.tvc().tvcString(), (Number)workchainId, initialData, credentials.publicKey()), (Abi.CallSet)new Abi.CallSet("constructor", null, constructorInputs), (Abi.Signer)credentials.signer(), null, (Boolean)false, null))).decoded().orElseThrow());
    }

    public Map<String, Object> giveAndDeploy(Sdk sdk, Giver giver, BigInteger value, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws Sdk.SdkException {
        Address address = Address.ofFutureDeploy(sdk, this, 0, initialData, credentials);
        log.debug("Future address: " + address.makeAddrStd());
        giver.give(address, value);
        Processing.ResultOfProcessMessage result = (Processing.ResultOfProcessMessage)sdk.syncCall(Processing.processMessage((Context)sdk.context(), (Abi.ABI)this.abi.abiJson(), null, (Abi.DeploySet)new Abi.DeploySet(this.tvc.tvcString(), (Number)workchainId, initialData, credentials.publicKey()), (Abi.CallSet)new Abi.CallSet("constructor", null, constructorInputs), (Abi.Signer)credentials.signer(), null, (Boolean)false, null));
        return Message.decodeOutputMessage((Processing.DecodedOutput)result.decoded().get());
    }

    public Map<String, Object> deployFromMsig(Sdk sdk, Credentials credentials, BigInteger value, Address msigAddress, int workchainId, Map<String, Object> initialData, Map<String, Object> constructorInputs, BigInteger constructorValue) throws Sdk.SdkException {
        Address deployAddr = Address.ofFutureDeploy(sdk, this, workchainId, initialData, Credentials.NONE);
        String payload = ((Abi.ResultOfEncodeInternalMessage)sdk.syncCall(Abi.encodeInternalMessage((Context)sdk.context(), (Abi.ABI)this.abi.abiJson(), (String)deployAddr.makeAddrStd(), (String)msigAddress.makeAddrStd(), (Abi.DeploySet)new Abi.DeploySet(this.tvc.tvcString(), (Number)workchainId, initialData, Credentials.NONE.publicKey()), (Abi.CallSet)new Abi.CallSet("constructor", null, constructorInputs), (String)constructorValue.toString(), (Boolean)false, (Boolean)false))).message();
        HashMap<String, Object> msigInputs = new HashMap<String, Object>();
        msigInputs.put("dest", deployAddr.makeAddrStd());
        msigInputs.put("value", value.toString());
        msigInputs.put("bounce", false);
        msigInputs.put("flags", 0);
        msigInputs.put("payload", payload);
        return Message.decodeOutputMessage((Processing.DecodedOutput)((Processing.ResultOfProcessMessage)sdk.syncCall(Processing.processMessage((Context)sdk.context(), (Abi.ABI)ContractAbi.SAFE_MULTISIG.abiJson(), (String)msigAddress.makeAddrStd(), null, (Abi.CallSet)new Abi.CallSet("sendTransaction", null, msigInputs), (Abi.Signer)credentials.signer(), null, (Boolean)false, null))).decoded().orElseThrow());
    }

    @Generated
    public ContractAbi abi() {
        return this.abi;
    }

    @Generated
    public ContractTvc tvc() {
        return this.tvc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractTemplate)) {
            return false;
        }
        ContractTemplate other = (ContractTemplate)o;
        ContractAbi this$abi = this.abi();
        ContractAbi other$abi = other.abi();
        if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
            return false;
        }
        ContractTvc this$tvc = this.tvc();
        ContractTvc other$tvc = other.tvc();
        return !(this$tvc == null ? other$tvc != null : !this$tvc.equals(other$tvc));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractAbi $abi = this.abi();
        result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
        ContractTvc $tvc = this.tvc();
        result = result * 59 + ($tvc == null ? 43 : $tvc.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractTemplate(abi=" + this.abi() + ", tvc=" + this.tvc() + ")";
    }
}

