/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.framework.artifact.FileArtifact;

public final class ContractAbi {
    @Generated
    private static final Logger log = LogManager.getLogger(ContractAbi.class);
    public static ContractAbi SAFE_MULTISIG = ContractAbi.ofStored(FileArtifact.ofResourcePath("/artifacts/std/SafeMultisigWallet.abi.json"));
    private final String abiJsonString;
    private final List<String> headers = new ArrayList<String>();
    private final Map<String, Function> functions = new HashMap<String, Function>();

    public ContractAbi(String abiJsonString) {
        JsonObject jsonObj = JsonParser.parseString((String)abiJsonString).getAsJsonObject();
        jsonObj.get("functions").getAsJsonArray().iterator().forEachRemaining(func -> {
            JsonObject funcObj = func.getAsJsonObject();
            HashMap<String, String> inputsMap = new HashMap<String, String>();
            HashMap<String, String> outputsMap = new HashMap<String, String>();
            funcObj.get("inputs").getAsJsonArray().iterator().forEachRemaining(input -> {
                JsonObject inputObj = input.getAsJsonObject();
                inputsMap.put(inputObj.get("name").getAsString(), inputObj.get("type").getAsString());
            });
            funcObj.get("outputs").getAsJsonArray().iterator().forEachRemaining(output -> {
                JsonObject outputObj = output.getAsJsonObject();
                outputsMap.put(outputObj.get("name").getAsString(), outputObj.get("type").getAsString());
            });
            this.functions.put(funcObj.get("name").getAsString(), new Function(inputsMap, outputsMap));
        });
        jsonObj.get("header").getAsJsonArray().iterator().forEachRemaining(header -> this.headers.add(header.getAsString()));
        this.abiJsonString = abiJsonString;
    }

    public static ContractAbi ofStored(Artifact artifact) {
        return artifact.getAsABI();
    }

    public boolean hasHeader(String name) {
        return this.headers.contains(name);
    }

    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    public boolean hasInput(String functionName, String inputName) {
        return this.functions.get((Object)functionName).inputs.containsKey(inputName);
    }

    public boolean hasOutput(String functionName, String outputName) {
        return this.functions.get((Object)functionName).outputs.containsKey(outputName);
    }

    public String inputType(String functionName, String inputName) {
        return this.functions.get((Object)functionName).inputs.get(inputName);
    }

    public String outputType(String functionName, String outputName) {
        return this.functions.get((Object)functionName).outputs.get(outputName);
    }

    public Abi.ABI abiJson() {
        return new Abi.ABI.Json(this.abiJsonString);
    }

    @Generated
    public String abiJsonString() {
        return this.abiJsonString;
    }

    @Generated
    public List<String> headers() {
        return this.headers;
    }

    @Generated
    public Map<String, Function> functions() {
        return this.functions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractAbi)) {
            return false;
        }
        ContractAbi other = (ContractAbi)o;
        String this$abiJsonString = this.abiJsonString();
        String other$abiJsonString = other.abiJsonString();
        if (this$abiJsonString == null ? other$abiJsonString != null : !this$abiJsonString.equals(other$abiJsonString)) {
            return false;
        }
        List<String> this$headers = this.headers();
        List<String> other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Function> this$functions = this.functions();
        Map<String, Function> other$functions = other.functions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $abiJsonString = this.abiJsonString();
        result = result * 59 + ($abiJsonString == null ? 43 : $abiJsonString.hashCode());
        List<String> $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Function> $functions = this.functions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractAbi(abiJsonString=" + this.abiJsonString() + ", headers=" + this.headers() + ", functions=" + this.functions() + ")";
    }

    private record Function(Map<String, String> inputs, Map<String, String> outputs) {
    }

    public static enum AbiHeader {
        time,
        pubkey,
        expire;

    }

    public static enum AbiType {
        Contract,
        Json,
        Handle,
        Serialized;

    }
}

