/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.GraphQL;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.Data;
import tech.deplant.java4ever.framework.Message;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.type.AbiAddressConverter;

public final class Account {
    @Generated
    private static final Logger log = LogManager.getLogger(Account.class);
    private final Sdk sdk;
    private final Address address;
    private final ContractAbi abi;
    private final int status;
    private final BigDecimal balance;
    private final String boc;
    private final Instant lastPaidUtc;

    public Account(Sdk sdk, Address address, ContractAbi abi, int status, BigDecimal balance, String boc, Instant lastPaidUtc) {
        this.sdk = sdk;
        this.address = address;
        this.abi = abi;
        this.status = status;
        this.balance = balance;
        this.boc = boc;
        this.lastPaidUtc = lastPaidUtc;
    }

    public static Account ofAddress(Sdk sdk, Address address, ContractAbi abi) throws Sdk.SdkException {
        HashMap<String, GraphQL.Filter.In> filter = new HashMap<String, GraphQL.Filter.In>();
        filter.put("id", new GraphQL.Filter.In(new String[]{address.makeAddrStd()}));
        Map[] results = ((Net.ResultOfQueryCollection)sdk.syncCall(Net.queryCollection((Context)sdk.context(), (String)"accounts", filter, (String)"id acc_type balance boc last_paid", null, null))).result();
        AccountQueryCollection collection = (AccountQueryCollection)new Gson().fromJson(new Gson().toJson((Object)results[0]), AccountQueryCollection.class);
        return new Account(sdk, address, abi, collection.acc_type(), Data.hexToDec(collection.balance(), 9), collection.boc(), Instant.ofEpochSecond(collection.last_paid()));
    }

    public static List<Account> ofAddressList(Sdk sdk, List<Address> addresses, ContractAbi abi) throws Sdk.SdkException {
        HashMap<String, GraphQL.Filter.In> filter = new HashMap<String, GraphQL.Filter.In>();
        filter.put("id", new GraphQL.Filter.In((String[])addresses.stream().map(Address::makeAddrStd).toArray(String[]::new)));
        return Arrays.stream(((Net.ResultOfQueryCollection)sdk.syncCall(Net.queryCollection((Context)sdk.context(), (String)"accounts", filter, (String)"id acc_type balance boc last_paid", null, null))).result()).map(obj -> {
            AccountQueryCollection collection = (AccountQueryCollection)new Gson().fromJson(new Gson().toJson(obj), AccountQueryCollection.class);
            return new Account(sdk, new Address(collection.id()), abi, collection.acc_type(), Data.hexToDec(collection.balance(), 9), collection.boc(), Instant.ofEpochSecond(collection.last_paid()));
        }).toList();
    }

    private Abi.ResultOfEncodeMessage encodeMessage(@NonNull String abiFunction, Map<String, Object> input) throws Sdk.SdkException {
        if (abiFunction == null) {
            throw new NullPointerException("abiFunction is marked non-null but is null");
        }
        return (Abi.ResultOfEncodeMessage)this.sdk.syncCall(Abi.encodeMessage((Context)this.sdk().context(), (Abi.ABI)this.abi.abiJson(), (String)this.address.makeAddrStd(), null, (Abi.CallSet)new Abi.CallSet(abiFunction, null, input), (Abi.Signer)Abi.Signer.None, null));
    }

    public boolean isActive() {
        return this.status() == 1;
    }

    public Map<String, Object> runGetter(@NonNull String abiFunction, Map<String, Object> input) throws Sdk.SdkException {
        if (abiFunction == null) {
            throw new NullPointerException("abiFunction is marked non-null but is null");
        }
        Tvm.ResultOfRunTvm msg = (Tvm.ResultOfRunTvm)this.sdk.syncCall(Tvm.runTvm((Context)this.sdk().context(), (String)this.encodeMessage(abiFunction, input).message(), (String)this.boc(), null, (Abi.ABI)this.abi.abiJson(), null, (Boolean)false));
        if (msg.decoded().isPresent()) {
            return Message.decodeOutputMessage((Processing.DecodedOutput)msg.decoded().get());
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> callExternal(Credentials credentials, String functionName, Map<String, Object> functionInputs) throws Sdk.SdkException {
        return Message.decodeOutputMessage((Processing.DecodedOutput)((Processing.ResultOfProcessMessage)this.sdk.syncCall(Processing.processMessage((Context)this.sdk.context(), (Abi.ABI)this.abi.abiJson(), (String)this.address().makeAddrStd(), null, (Abi.CallSet)new Abi.CallSet(functionName, null, functionInputs), (Abi.Signer)credentials.signer(), null, (Boolean)false, null))).decoded().orElseThrow());
    }

    public Map<String, Object> callInternalFromMsig(Credentials credentials, Address msigAddress, BigInteger transactionValue, String functionName, BigInteger functionValue, Map<String, Object> functionInputs, boolean functionBounce) throws Sdk.SdkException {
        String payload = ((Abi.ResultOfEncodeMessageBody)this.sdk.syncCall(Abi.encodeMessageBody((Context)this.sdk.context(), (Abi.ABI)this.abi.abiJson(), (Abi.CallSet)new Abi.CallSet(functionName, null, functionInputs), (Boolean)true, (Abi.Signer)credentials.signer(), null))).body();
        HashMap<String, Object> msigInputs = new HashMap<String, Object>();
        msigInputs.put("dest", this.address.makeAddrStd());
        msigInputs.put("value", transactionValue.toString());
        msigInputs.put("bounce", true);
        msigInputs.put("flags", 0);
        msigInputs.put("payload", payload);
        return Message.decodeOutputMessage((Processing.DecodedOutput)((Processing.ResultOfProcessMessage)this.sdk.syncCall(Processing.processMessage((Context)this.sdk.context(), (Abi.ABI)ContractAbi.SAFE_MULTISIG.abiJson(), (String)msigAddress.makeAddrStd(), null, (Abi.CallSet)new Abi.CallSet("sendTransaction", null, msigInputs), (Abi.Signer)credentials.signer(), null, (Boolean)false, null))).decoded().orElseThrow());
    }

    private Map<String, Object> convertInputsToCompatible(String functionName, Map<String, Object> functionInputs) {
        HashMap<String, Object> convertedInputs = new HashMap<String, Object>();
        functionInputs.forEach((inputName, passedObject) -> {
            switch (this.abi.inputType(functionName, (String)inputName)) {
                case "address": {
                    convertedInputs.put((String)inputName, AbiAddressConverter.convert(passedObject));
                    break;
                }
                default: {
                    convertedInputs.put((String)inputName, passedObject);
                }
            }
        });
        return convertedInputs;
    }

    @Generated
    public Sdk sdk() {
        return this.sdk;
    }

    @Generated
    public Address address() {
        return this.address;
    }

    @Generated
    public ContractAbi abi() {
        return this.abi;
    }

    @Generated
    public int status() {
        return this.status;
    }

    @Generated
    public BigDecimal balance() {
        return this.balance;
    }

    @Generated
    public String boc() {
        return this.boc;
    }

    @Generated
    public Instant lastPaidUtc() {
        return this.lastPaidUtc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (this.status() != other.status()) {
            return false;
        }
        Sdk this$sdk = this.sdk();
        Sdk other$sdk = other.sdk();
        if (this$sdk == null ? other$sdk != null : !((Object)this$sdk).equals(other$sdk)) {
            return false;
        }
        Address this$address = this.address();
        Address other$address = other.address();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        ContractAbi this$abi = this.abi();
        ContractAbi other$abi = other.abi();
        if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
            return false;
        }
        BigDecimal this$balance = this.balance();
        BigDecimal other$balance = other.balance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        String this$boc = this.boc();
        String other$boc = other.boc();
        if (this$boc == null ? other$boc != null : !this$boc.equals(other$boc)) {
            return false;
        }
        Instant this$lastPaidUtc = this.lastPaidUtc();
        Instant other$lastPaidUtc = other.lastPaidUtc();
        return !(this$lastPaidUtc == null ? other$lastPaidUtc != null : !((Object)this$lastPaidUtc).equals(other$lastPaidUtc));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.status();
        Sdk $sdk = this.sdk();
        result = result * 59 + ($sdk == null ? 43 : ((Object)$sdk).hashCode());
        Address $address = this.address();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        ContractAbi $abi = this.abi();
        result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
        BigDecimal $balance = this.balance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        String $boc = this.boc();
        result = result * 59 + ($boc == null ? 43 : $boc.hashCode());
        Instant $lastPaidUtc = this.lastPaidUtc();
        result = result * 59 + ($lastPaidUtc == null ? 43 : ((Object)$lastPaidUtc).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Account(sdk=" + this.sdk() + ", address=" + this.address() + ", abi=" + this.abi() + ", status=" + this.status() + ", balance=" + this.balance() + ", boc=" + this.boc() + ", lastPaidUtc=" + this.lastPaidUtc() + ")";
    }

    private static final class AccountQueryCollection {
        private final String id;
        private final int acc_type;
        private final String balance;
        private final String boc;
        private final long last_paid;

        @Generated
        public AccountQueryCollection(String id, int acc_type, String balance, String boc, long last_paid) {
            this.id = id;
            this.acc_type = acc_type;
            this.balance = balance;
            this.boc = boc;
            this.last_paid = last_paid;
        }

        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public int acc_type() {
            return this.acc_type;
        }

        @Generated
        public String balance() {
            return this.balance;
        }

        @Generated
        public String boc() {
            return this.boc;
        }

        @Generated
        public long last_paid() {
            return this.last_paid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountQueryCollection)) {
                return false;
            }
            AccountQueryCollection other = (AccountQueryCollection)o;
            if (this.acc_type() != other.acc_type()) {
                return false;
            }
            if (this.last_paid() != other.last_paid()) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$balance = this.balance();
            String other$balance = other.balance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            String this$boc = this.boc();
            String other$boc = other.boc();
            return !(this$boc == null ? other$boc != null : !this$boc.equals(other$boc));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.acc_type();
            long $last_paid = this.last_paid();
            result = result * 59 + (int)($last_paid >>> 32 ^ $last_paid);
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $balance = this.balance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            String $boc = this.boc();
            result = result * 59 + ($boc == null ? 43 : $boc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Account.AccountQueryCollection(id=" + this.id() + ", acc_type=" + this.acc_type() + ", balance=" + this.balance() + ", boc=" + this.boc() + ", last_paid=" + this.last_paid() + ")";
        }
    }
}

