/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.gql.QueryExecutorBuilder;
import tech.deplant.java4ever.binding.io.JsonResource;
import tech.deplant.java4ever.binding.reference.gql.GqlSchemaRoot;
import tech.deplant.javapoet.ClassName;
import tech.deplant.javapoet.CodeBlock;
import tech.deplant.javapoet.JavaFile;
import tech.deplant.javapoet.MethodSpec;
import tech.deplant.javapoet.ParameterSpec;
import tech.deplant.javapoet.ParameterizedTypeName;
import tech.deplant.javapoet.TypeName;
import tech.deplant.javapoet.TypeSpec;

public class ParseGql {
    public static final ObjectMapper MAPPER = JsonContext.ABI_JSON_MAPPER();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateFromSchema(String jsonPath) throws IOException {
        GqlSchemaRoot.GqlSchema schema = ((GqlSchemaRoot)MAPPER.readValue(new JsonResource(jsonPath).get(), GqlSchemaRoot.class)).data().__schema();
        TypeSpec.Builder subscriptionClass = TypeSpec.classBuilder((String)"Subscription").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        TypeSpec.Builder mutationClass = TypeSpec.classBuilder((String)"Mutation").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        Iterator<GqlSchemaRoot.GqlType> iterator = schema.types().stream().filter(type -> type.kind().equals((Object)GqlSchemaRoot.GqlKind.OBJECT) || type.kind().equals((Object)GqlSchemaRoot.GqlKind.INPUT_OBJECT) || type.kind().equals((Object)GqlSchemaRoot.GqlKind.INTERFACE) || type.kind().equals((Object)GqlSchemaRoot.GqlKind.ENUM)).filter(type -> !type.name().startsWith("__")).toList().iterator();
        while (iterator.hasNext()) {
            GqlSchemaRoot.GqlType gqlType;
            GqlSchemaRoot.GqlType type3 = iterator.next();
            Objects.requireNonNull(type3);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GqlSchemaRoot.GqlType.GqlObject.class, GqlSchemaRoot.GqlType.GqlInputObject.class, GqlSchemaRoot.GqlType.GqlInterface.class, GqlSchemaRoot.GqlType.GqlEnum.class}, (Object)gqlType, n)) {
                case 0: {
                    GqlSchemaRoot.GqlType.GqlObject obj = (GqlSchemaRoot.GqlType.GqlObject)gqlType;
                    if (!obj.interfaces().isEmpty()) break;
                    TypeSpec.Builder recordBuilder = ParseGql.processObjects(obj);
                    JavaFile.builder((String)"tech.deplant.java4ever.binding.gql", (TypeSpec)recordBuilder.build()).build().writeTo(Paths.get("src/gen/java", new String[0]));
                    break;
                }
                case 1: {
                    GqlSchemaRoot.GqlType.GqlInputObject input = (GqlSchemaRoot.GqlType.GqlInputObject)gqlType;
                    TypeSpec.Builder recordBuilder = ParseGql.processObjects(input);
                    JavaFile.builder((String)"tech.deplant.java4ever.binding.gql", (TypeSpec)recordBuilder.build()).build().writeTo(Paths.get("src/gen/java", new String[0]));
                    break;
                }
                case 2: {
                    Object intDescription;
                    Object intName;
                    GqlSchemaRoot.GqlType.GqlInterface gqlInterface = (GqlSchemaRoot.GqlType.GqlInterface)gqlType;
                    try {
                        Object object;
                        GqlSchemaRoot.GqlKind kind = object = gqlInterface.kind();
                        intName = object = gqlInterface.name();
                        intDescription = object = gqlInterface.description();
                        Object possibleTypes = object = gqlInterface.possibleTypes();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)intName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.SEALED});
                    Optional.ofNullable(intDescription).ifPresent(arg_0 -> ParseGql.lambda$generateFromSchema$2(interfaceBuilder, (String)intDescription, arg_0));
                    for (GqlSchemaRoot.GqlType.GqlObject dependentRecord : schema.types().stream().filter(type1 -> type1.kind().equals((Object)GqlSchemaRoot.GqlKind.OBJECT)).map(type2 -> (GqlSchemaRoot.GqlType.GqlObject)type2).filter(arg_0 -> ParseGql.lambda$generateFromSchema$6((String)intName, arg_0)).toList()) {
                        TypeSpec.Builder dependentRecordBuilder = ParseGql.processObjects(dependentRecord);
                        dependentRecordBuilder.addSuperinterface((TypeName)ClassName.get((String)"tech.deplant.java4ever.binding.gql", (String)intName, (String[])new String[0]));
                        interfaceBuilder.addType(dependentRecordBuilder.build());
                    }
                    JavaFile.builder((String)"tech.deplant.java4ever.binding.gql", (TypeSpec)interfaceBuilder.build()).build().writeTo(Paths.get("src/gen/java", new String[0]));
                    break;
                }
                case 3: {
                    GqlSchemaRoot.GqlType.GqlEnum enu = (GqlSchemaRoot.GqlType.GqlEnum)gqlType;
                    TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((String)enu.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                    Optional.ofNullable(enu.description()).ifPresent(description -> enumBuilder.addJavadoc(CodeBlock.builder().addStatement(description, new Object[0]).build()));
                    for (GqlSchemaRoot.GqlEnumValue enumValue : enu.enumValues()) {
                        enumBuilder.addEnumConstant(enumValue.name());
                    }
                    JavaFile.builder((String)"tech.deplant.java4ever.binding.gql", (TypeSpec)enumBuilder.build()).build().writeTo(Paths.get("src/gen/java", new String[0]));
                    break;
                }
            }
        }
        return;
    }

    private static TypeSpec.Builder processObjects(GqlSchemaRoot.GqlType.GqlInputObject input) {
        TypeSpec.Builder recordBuilder = TypeSpec.recordBuilder((String)input.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional.ofNullable(input.description()).ifPresent(description -> recordBuilder.addJavadoc(CodeBlock.builder().addStatement(description, new Object[0]).build()));
        for (GqlSchemaRoot.GqlInputField field : input.inputFields()) {
            recordBuilder.addRecordComponent(ParserUtils.processReservedNames(ParseGql.getClassName(field.type()), field.name()).build());
        }
        return recordBuilder;
    }

    private static TypeSpec.Builder processObjects(GqlSchemaRoot.GqlType.GqlObject obj) throws IOException {
        TypeSpec.Builder recordBuilder = TypeSpec.recordBuilder((String)obj.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional.ofNullable(obj.description()).ifPresent(description -> recordBuilder.addJavadoc(CodeBlock.builder().addStatement(description, new Object[0]).build()));
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(obj.name() + "Executor"));
        for (GqlSchemaRoot.GqlField field : obj.fields()) {
            recordBuilder.addRecordComponent(ParserUtils.processReservedNames(ParseGql.getClassName(field.type()), field.name()).build());
            if (field.args().isEmpty()) continue;
            ClassName queryExecutorBuilderClass = ClassName.get(QueryExecutorBuilder.class);
            MethodSpec.Builder functionBuilder = MethodSpec.methodBuilder((String)field.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)queryExecutorBuilderClass);
            functionBuilder.addCode(CodeBlock.builder().addStatement("var builder = new $T($S, objectFieldsTree)", new Object[]{queryExecutorBuilderClass, field.name()}).build());
            functionBuilder.addParameter(ParameterSpec.builder((TypeName)ClassName.STRING, (String)"objectFieldsTree", (Modifier[])new Modifier[0]).build());
            for (GqlSchemaRoot.GqlInputField arg : field.args()) {
                functionBuilder.addParameter(ParserUtils.processReservedNames(ParseGql.getClassName(arg.type()), arg.name()).build());
                functionBuilder.addCode(CodeBlock.builder().addStatement("$T.ofNullable(" + arg.name() + ").ifPresent(ar -> builder.addToQuery($S,ar))", new Object[]{ClassName.get(Optional.class), arg.name()}).build());
            }
            functionBuilder.addCode(CodeBlock.builder().addStatement("return builder", new Object[0]).build());
            if (obj.name().equals("Query") || obj.name().equals("Mutation") || obj.name().equals("Subscription")) {
                classBuilder.addMethod(functionBuilder.build());
                continue;
            }
            recordBuilder.addMethod(functionBuilder.build());
        }
        if (obj.name().equals("Query") || obj.name().equals("Mutation") || obj.name().equals("Subscription")) {
            JavaFile.builder((String)"tech.deplant.java4ever.binding.gql", (TypeSpec)classBuilder.build()).build().writeTo(Paths.get("src/gen/java", new String[0]));
        }
        return recordBuilder;
    }

    private static TypeName getClassName(GqlSchemaRoot.GqlParam param) {
        return switch (param.kind()) {
            case "LIST" -> ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParseGql.getClassName(param.ofType())});
            case "NON_NULL" -> ParseGql.getClassName(param.ofType());
            case "SCALAR" -> {
                String v1 = switch (param.name()) {
                    case "Int" -> "Integer";
                    case "ID", "RempReceiptJson" -> "String";
                    default -> param.name();
                };
                String typeName = v1;
                yield ClassName.bestGuess((String)typeName);
            }
            default -> List.of("BlockchainAccount", "BlockchainBlock", "BlockchainMessage", "BlockchainTransaction").contains(param.name()) ? ClassName.bestGuess((String)("Node." + param.name())) : ClassName.bestGuess((String)param.name());
        };
    }

    private static String httpRequest(String url, String query, String method, String ... headers) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(15L)).followRedirects(HttpClient.Redirect.NEVER).build();
        HttpResponse<String> response = null;
        if (method.equals("GET")) {
            HttpRequest.Builder builder = HttpRequest.newBuilder().GET().uri(URI.create(url));
            Arrays.stream(headers).toList().forEach(header -> {
                String[] nameValue = header.split(":");
                builder.header(nameValue[0].trim(), nameValue[1].trim());
            });
            HttpRequest request = builder.build();
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        } else if (method.equals("POST")) {
            client = HttpClient.newHttpClient();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(query)).version(HttpClient.Version.HTTP_1_1);
            Arrays.stream(headers).toList().forEach(header -> {
                String[] nameValue = header.split(":");
                builder.header(nameValue[0].trim(), nameValue[1].trim());
            });
            HttpRequest request = builder.build();
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        if (Objs.isNull((Object)response.statusCode()) || response.statusCode() != 200) {
            throw new RuntimeException("Failed : HTTP Error code : " + response.statusCode());
        }
        return (String)response.body();
    }

    public static String getSchemaFromGraphQL(String endpoint) throws IOException, InterruptedException {
        String introspectionQueryText = "{\n\t\"operationName\": \"IntrospectionQuery\",\n\t\"variables\": {},\n\t\"query\": \"query IntrospectionQuery {\n\t\t\t             __schema {\n\t\t\t               queryType {\n\t\t\t                 name\n\t\t\t               }\n\t\t\t               mutationType {\n\t\t\t                 name\n\t\t\t               }\n\t\t\t               subscriptionType {\n\t\t\t                 name\n\t\t\t               }\n\t\t\t               types {\n\t\t\t                 ...FullType\n\t\t\t               }\n\t\t\t               directives {\n\t\t\t                 name\n\t\t\t                 description\n\t\t\t                 locations\n\t\t\t                 args {\n\t\t\t                   ...InputValue\n\t\t\t                 }\n\t\t\t               }\n\t\t\t             }\n\t\t\t           }\n\t\t\t           fragment FullType on __Type {\n\t\t\t             kind\n\t\t\t             name\n\t\t\t             description\n\t\t\t             fields(includeDeprecated: true) {\n\t\t\t               name\n\t\t\t               description\n\t\t\t               args {\n\t\t\t                 ...InputValue\n\t\t\t               }\n\t\t\t               type {\n\t\t\t                 ...TypeRef\n\t\t\t               }\n\t\t\t               isDeprecated\n\t\t\t               deprecationReason\n\t\t\t             }\n\t\t\t             inputFields {\n\t\t\t               ...InputValue\n\t\t\t             }\n\t\t\t             interfaces {\n\t\t\t               ...TypeRef\n\t\t\t             }\n\t\t\t             enumValues(includeDeprecated: true) {\n\t\t\t               name\n\t\t\t               description\n\t\t\t               isDeprecated\n\t\t\t               deprecationReason\n\t\t\t             }\n\t\t\t             possibleTypes {\n\t\t\t               ...TypeRef\n\t\t\t             }\n\t\t\t           }\n\t\t\t           fragment InputValue on __InputValue {\n\t\t\t             name\n\t\t\t             description\n\t\t\t             type {\n\t\t\t               ...TypeRef\n\t\t\t             }\n\t\t\t             defaultValue\n\t\t\t           }\n\t\t\t           fragment TypeRef on __Type {\n\t\t\t             kind\n\t\t\t             name\n\t\t\t             ofType {\n\t\t\t               kind\n\t\t\t               name\n\t\t\t               ofType {\n\t\t\t                 kind\n\t\t\t                 name\n\t\t\t                 ofType {\n\t\t\t                   kind\n\t\t\t                   name\n\t\t\t                   ofType {\n\t\t\t                     kind\n\t\t\t                     name\n\t\t\t                     ofType {\n\t\t\t                       kind\n\t\t\t                       name\n\t\t\t                       ofType {\n\t\t\t                         kind\n\t\t\t                         name\n\t\t\t                         ofType {\n\t\t\t                           kind\n\t\t\t                           name\n\t\t\t                         }\n\t\t\t                       }\n\t\t\t                     }\n\t\t\t                   }\n\t\t\t                 }\n\t\t\t               }\n\t\t\t             }\n\t\t\t           }\"\n}\n";
        String jsonRequest = "{\"query\":" + MAPPER.writeValueAsString((Object)"{messages(filter: {msg_type: {eq:2}}) { id body boc src created_at }}") + "}";
        return ParseGql.httpRequest(endpoint, introspectionQueryText, "POST", "Accept: application/json", "Content-Type: application/json");
    }

    private static /* synthetic */ boolean lambda$generateFromSchema$6(String intName, GqlSchemaRoot.GqlType.GqlObject obj1) {
        return obj1.interfaces().stream().anyMatch(depInt -> depInt.name().equals(intName));
    }

    private static /* synthetic */ void lambda$generateFromSchema$2(TypeSpec.Builder interfaceBuilder, String intDescription, String description) {
        interfaceBuilder.addJavadoc(CodeBlock.builder().addStatement(intDescription, new Object[0]).build());
    }
}

