/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import tech.deplant.java4ever.binding.ffi.tc_string_data_t;

class NativeStrings {
    NativeStrings() {
    }

    public static MemorySegment toRust(String text, Arena nativeSession) {
        MemorySegment nativeString = nativeSession.allocateFrom(text);
        int strlen = (int)nativeString.byteSize() - 1;
        MemorySegment stringDataSegment = nativeSession.allocate(tc_string_data_t.layout());
        tc_string_data_t.content(stringDataSegment, nativeString);
        tc_string_data_t.len(stringDataSegment, strlen);
        return stringDataSegment;
    }

    public static String toJava(MemorySegment seg) {
        if (tc_string_data_t.len(seg) > 0) {
            MemorySegment content = tc_string_data_t.content(seg).asSlice(0L, tc_string_data_t.len(seg));
            return new String(content.toArray(ValueLayout.JAVA_BYTE), StandardCharsets.UTF_8);
        }
        return "";
    }
}

