/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import tech.deplant.java4ever.binding.AppObject;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;

public abstract class AppPasswordProvider
implements AppObject {
    public abstract Crypto.ResultOfAppPasswordProvider.GetPassword getPassword(String var1);

    @Override
    public final void consumeParams(int contextId, long appRequestId, JsonNode jsonNode) throws EverSdkException {
        try (ExecutorService exec = Executors.newVirtualThreadPerTaskExecutor();){
            exec.submit(() -> {
                try {
                    String requestMethod = jsonNode.get("type").asText();
                    if (!"GetPassword".equals(requestMethod)) {
                        throw new IllegalStateException("Unexpected value: " + jsonNode.get("type").asText());
                    }
                    Crypto.ResultOfAppPasswordProvider.GetPassword password = this.getPassword(jsonNode.get("encryptionPublicKey").asText());
                    JsonNode resultNode = JsonContext.SDK_JSON_MAPPER().valueToTree((Object)password);
                    Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Ok(resultNode));
                }
                catch (Exception e) {
                    try {
                        Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error(e.getMessage()));
                    }
                    catch (EverSdkException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            exec.shutdown();
            if (!exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error("Unsuccessful completion"));
            }
        }
        catch (Exception e) {
            Client.resolveAppRequest(contextId, appRequestId, new Client.AppRequestResult.Error(e.getMessage()));
        }
    }
}

