/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import javax.lang.model.element.Modifier;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.jtype.SdkDocs;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.jtype.SdkParam;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.javapoet.AnnotationSpec;
import tech.deplant.javapoet.ClassName;
import tech.deplant.javapoet.MethodSpec;
import tech.deplant.javapoet.TypeName;
import tech.deplant.javapoet.TypeSpec;

public record SdkRecord(StructType originalType, String name, ParserEngine.SdkInterfaceParent superInterface, boolean isSimpleWrapper, boolean isParams, boolean isResult, Map<ParserEngine.SdkType, SdkObject> typeLibrary) implements SdkObject
{
    private static final System.Logger logger = System.getLogger(SdkRecord.class.getName());

    public static SdkRecord ofApiType(StructType struct, Map<ParserEngine.SdkType, SdkObject> typeLibrary, ParserEngine.SdkInterfaceParent superInterface) {
        boolean isParams = false;
        boolean isResult = false;
        if (struct.name().length() >= 8) {
            isParams = "ParamsOf".equals(struct.name().substring(0, 8));
            isResult = "ResultOf".equals(struct.name().substring(0, 8));
        }
        boolean isSimpleWrapper = struct.struct_fields().length == 1;
        return new SdkRecord(struct, struct.name(), superInterface, isSimpleWrapper, isParams, isResult, typeLibrary);
    }

    @Override
    public TypeSpec.Builder poeticize() {
        TypeSpec.Builder structBuilder = TypeSpec.recordBuilder((String)this.originalType.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (ApiType component : this.originalType.struct_fields()) {
            structBuilder.addRecordComponent(SdkParam.ofApiType(component, this.typeLibrary()).poeticize().build());
        }
        structBuilder.addJavadoc(new SdkDocs(this.originalType().summary(), this.originalType().description()).poeticize().build());
        if (Objs.isNotNull((Object)this.superInterface())) {
            structBuilder.addSuperinterface((TypeName)ClassName.bestGuess((String)this.superInterface().name()));
            structBuilder.addMethod(this.virtualTypeField(this.superInterface().variantName()).build());
        }
        if ("AbiEvent".equals(this.name())) {
            structBuilder.addAnnotation(AnnotationSpec.builder(JsonIgnoreProperties.class).addMember("value", "$S", new Object[]{"outputs"}).build());
        }
        return structBuilder;
    }

    @Override
    public ApiType type() {
        return this.originalType();
    }

    @Override
    public boolean isFlatType() {
        return false;
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    private MethodSpec.Builder virtualTypeField(String typeName) {
        return MethodSpec.methodBuilder((String)"type").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.STRING).addStatement("return \"" + typeName + "\"", new Object[0]).addAnnotation(SdkParam.renamedFieldAnnotation("type"));
    }

    public SdkRecord withSuperInterface(ParserEngine.SdkInterfaceParent superInterface) {
        return new SdkRecord(this.originalType(), this.name(), superInterface, this.isSimpleWrapper(), this.isParams(), this.isResult(), this.typeLibrary());
    }
}

