/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

public class EverSdkException
extends Exception {
    private static final long serialVersionUID = 7830266012832686185L;
    private final ErrorResult errorResponse;

    public EverSdkException(ErrorResult errorResponse) {
        this.errorResponse = errorResponse;
    }

    public EverSdkException(ErrorResult errorResponse, String message) {
        super(message);
        this.errorResponse = errorResponse;
    }

    public EverSdkException(ErrorResult errorResponse, String message, Throwable cause) {
        super(message, cause);
        this.errorResponse = errorResponse;
    }

    public EverSdkException(ErrorResult errorResponse, Throwable cause) {
        super(cause);
        this.errorResponse = errorResponse;
    }

    public ErrorResult errorResponse() {
        return this.errorResponse;
    }

    public record ErrorResult(long code, String message, ErrorResultData data) {
        public ErrorResult(long code, String message) {
            this(code, message, null);
        }

        public String toLog() {
            if (this.data() != null && this.data().localError() != null && this.data().localError().data() != null && this.data().localError().data().exitCode() > 0) {
                return "%d (exit: %d) %s".formatted(this.data().localError().code(), this.data().localError().data().exitCode(), this.data().localError().message());
            }
            return "%d %s".formatted(this.code(), this.message());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ErrorResultData(String coreVersion, String phase, int exitCode, int exitArg, String functionName, String accountAddress, Number accountBalance, int gasUsed, String description, String contractError, String[] configServers, String queryUrl, String queryIpAddress, String transactionId, String messageId, String shardBlockId, String waitingExpirationTime, String blockTime, ErrorResult localError, Integer resultCode, String bindingLibrary, String bindingVersion, String serverCode) {
    }
}

