/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Net {
    public static CompletableFuture<ResultOfQuery> query(int ctxId, String query, JsonNode variables) throws EverSdkException {
        return EverSdk.async(ctxId, "net.query", new ParamsOfQuery(query, variables), ResultOfQuery.class);
    }

    public static CompletableFuture<ResultOfBatchQuery> batchQuery(int ctxId, ParamsOfQueryOperation[] operations) throws EverSdkException {
        return EverSdk.async(ctxId, "net.batch_query", new ParamsOfBatchQuery(operations), ResultOfBatchQuery.class);
    }

    public static CompletableFuture<ResultOfQueryCollection> queryCollection(int ctxId, String collection, JsonNode filter, String result, OrderBy[] order, Long limit) throws EverSdkException {
        return EverSdk.async(ctxId, "net.query_collection", new ParamsOfQueryCollection(collection, filter, result, order, limit), ResultOfQueryCollection.class);
    }

    public static CompletableFuture<ResultOfAggregateCollection> aggregateCollection(int ctxId, String collection, JsonNode filter, FieldAggregation[] fields) throws EverSdkException {
        return EverSdk.async(ctxId, "net.aggregate_collection", new ParamsOfAggregateCollection(collection, filter, fields), ResultOfAggregateCollection.class);
    }

    public static CompletableFuture<ResultOfWaitForCollection> waitForCollection(int ctxId, String collection, JsonNode filter, String result, Long timeout) throws EverSdkException {
        return EverSdk.async(ctxId, "net.wait_for_collection", new ParamsOfWaitForCollection(collection, filter, result, timeout), ResultOfWaitForCollection.class);
    }

    public static void unsubscribe(int ctxId, ResultOfSubscribeCollection params) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "net.unsubscribe", params);
    }

    public static CompletableFuture<ResultOfSubscribeCollection> subscribeCollection(int ctxId, String collection, JsonNode filter, String result, Consumer<JsonNode> callback) throws EverSdkException {
        return EverSdk.asyncCallback(ctxId, "net.subscribe_collection", new ParamsOfSubscribeCollection(collection, filter, result), ResultOfSubscribeCollection.class, callback);
    }

    public static CompletableFuture<ResultOfSubscribeCollection> subscribe(int ctxId, String subscription, JsonNode variables, Consumer<JsonNode> callback) throws EverSdkException {
        return EverSdk.asyncCallback(ctxId, "net.subscribe", new ParamsOfSubscribe(subscription, variables), ResultOfSubscribeCollection.class, callback);
    }

    public static void suspend(int ctxId) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "net.suspend", null);
    }

    public static void resume(int ctxId) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "net.resume", null);
    }

    public static CompletableFuture<ResultOfFindLastShardBlock> findLastShardBlock(int ctxId, String address) throws EverSdkException {
        return EverSdk.async(ctxId, "net.find_last_shard_block", new ParamsOfFindLastShardBlock(address), ResultOfFindLastShardBlock.class);
    }

    public static CompletableFuture<EndpointsSet> fetchEndpoints(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "net.fetch_endpoints", null, EndpointsSet.class);
    }

    public static void setEndpoints(int ctxId, EndpointsSet params) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "net.set_endpoints", params);
    }

    public static CompletableFuture<ResultOfGetEndpoints> getEndpoints(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "net.get_endpoints", null, ResultOfGetEndpoints.class);
    }

    public static CompletableFuture<ResultOfQueryCollection> queryCounterparties(int ctxId, String account, String result, Long first, String after) throws EverSdkException {
        return EverSdk.async(ctxId, "net.query_counterparties", new ParamsOfQueryCounterparties(account, result, first, after), ResultOfQueryCollection.class);
    }

    public static CompletableFuture<ResultOfQueryTransactionTree> queryTransactionTree(int ctxId, String inMsg, Abi.ABI[] abiRegistry, Long timeout, Long transactionMaxCount) throws EverSdkException {
        return EverSdk.async(ctxId, "net.query_transaction_tree", new ParamsOfQueryTransactionTree(inMsg, abiRegistry, timeout, transactionMaxCount), ResultOfQueryTransactionTree.class);
    }

    public static CompletableFuture<RegisteredIterator> createBlockIterator(int ctxId, Long startTime, Long endTime, String[] shardFilter, String result) throws EverSdkException {
        return EverSdk.async(ctxId, "net.create_block_iterator", new ParamsOfCreateBlockIterator(startTime, endTime, shardFilter, result), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> resumeBlockIterator(int ctxId, JsonNode resumeState) throws EverSdkException {
        return EverSdk.async(ctxId, "net.resume_block_iterator", new ParamsOfResumeBlockIterator(resumeState), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> createTransactionIterator(int ctxId, Long startTime, Long endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) throws EverSdkException {
        return EverSdk.async(ctxId, "net.create_transaction_iterator", new ParamsOfCreateTransactionIterator(startTime, endTime, shardFilter, accountsFilter, result, includeTransfers), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> resumeTransactionIterator(int ctxId, JsonNode resumeState, String[] accountsFilter) throws EverSdkException {
        return EverSdk.async(ctxId, "net.resume_transaction_iterator", new ParamsOfResumeTransactionIterator(resumeState, accountsFilter), RegisteredIterator.class);
    }

    public static CompletableFuture<ResultOfIteratorNext> iteratorNext(int ctxId, Long iterator, Long limit, Boolean returnResumeState) throws EverSdkException {
        return EverSdk.async(ctxId, "net.iterator_next", new ParamsOfIteratorNext(iterator, limit, returnResumeState), ResultOfIteratorNext.class);
    }

    public static void removeIterator(int ctxId, RegisteredIterator params) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "net.remove_iterator", params);
    }

    public static CompletableFuture<ResultOfGetSignatureId> getSignatureId(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "net.get_signature_id", null, ResultOfGetSignatureId.class);
    }

    public record ParamsOfQuery(String query, JsonNode variables) {
    }

    public record ResultOfQuery(JsonNode result) {
    }

    public record ParamsOfBatchQuery(ParamsOfQueryOperation[] operations) {
    }

    public static sealed interface ParamsOfQueryOperation
    permits ParamsOfQueryCollection, ParamsOfWaitForCollection, ParamsOfQueryCounterparties, ParamsOfAggregateCollection {
    }

    public record ResultOfBatchQuery(JsonNode[] results) {
    }

    public record ParamsOfQueryCollection(String collection, JsonNode filter, String result, OrderBy[] order, Long limit) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCollection";
        }
    }

    public record OrderBy(String path, SortDirection direction) {
    }

    public record ResultOfQueryCollection(JsonNode[] result) {
    }

    public record ParamsOfAggregateCollection(String collection, JsonNode filter, FieldAggregation[] fields) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "AggregateCollection";
        }
    }

    public record FieldAggregation(String field, AggregationFn fn) {
    }

    public record ResultOfAggregateCollection(JsonNode values) {
    }

    public record ParamsOfWaitForCollection(String collection, JsonNode filter, String result, Long timeout) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "WaitForCollection";
        }
    }

    public record ResultOfWaitForCollection(JsonNode result) {
    }

    public record ParamsOfSubscribeCollection(String collection, JsonNode filter, String result) {
    }

    public record ResultOfSubscribeCollection(Long handle) {
    }

    public record ParamsOfSubscribe(String subscription, JsonNode variables) {
    }

    public record ParamsOfFindLastShardBlock(String address) {
    }

    public record ResultOfFindLastShardBlock(String blockId) {
    }

    public record EndpointsSet(String[] endpoints) {
    }

    public record ResultOfGetEndpoints(String query, String[] endpoints) {
    }

    public record ParamsOfQueryCounterparties(String account, String result, Long first, String after) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCounterparties";
        }
    }

    public record ParamsOfQueryTransactionTree(String inMsg, Abi.ABI[] abiRegistry, Long timeout, Long transactionMaxCount) {
    }

    public record ResultOfQueryTransactionTree(MessageNode[] messages, TransactionNode[] transactions) {
    }

    public record ParamsOfCreateBlockIterator(Long startTime, Long endTime, String[] shardFilter, String result) {
    }

    public record RegisteredIterator(Long handle) {
    }

    public record ParamsOfResumeBlockIterator(JsonNode resumeState) {
    }

    public record ParamsOfCreateTransactionIterator(Long startTime, Long endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
    }

    public record ParamsOfResumeTransactionIterator(JsonNode resumeState, String[] accountsFilter) {
    }

    public record ParamsOfIteratorNext(Long iterator, Long limit, Boolean returnResumeState) {
    }

    public record ResultOfIteratorNext(JsonNode[] items, Boolean hasMore, JsonNode resumeState) {
    }

    public record ResultOfGetSignatureId(Long signatureId) {
    }

    public record TransactionNode(String id, String inMsg, String[] outMsgs, String accountAddr, String totalFees, Boolean aborted, Long exitCode) {
    }

    public static enum NetErrorCode {
        QueryFailed(601),
        SubscribeFailed(602),
        WaitForFailed(603),
        GetSubscriptionResultFailed(604),
        InvalidServerResponse(605),
        ClockOutOfSync(606),
        WaitForTimeout(607),
        GraphqlError(608),
        NetworkModuleSuspended(609),
        WebsocketDisconnected(610),
        NotSupported(611),
        NoEndpointsProvided(612),
        GraphqlWebsocketInitError(613),
        NetworkModuleResumed(614),
        Unauthorized(615),
        QueryTransactionTreeTimeout(616),
        GraphqlConnectionError(617),
        WrongWebscoketProtocolSequence(618);

        private final Integer value;

        private NetErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record MessageNode(String id, String srcTransactionId, String dstTransactionId, String src, String dst, String value, Boolean bounce, Abi.DecodedMessageBody decodedBody) {
    }

    public static enum AggregationFn {
        COUNT,
        MIN,
        MAX,
        SUM,
        AVERAGE;

    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

