/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.gql;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import tech.deplant.java4ever.binding.JsonContext;

public class QueryExecutorBuilder {
    String method;
    String fields;
    Map<String, String> args = new HashMap<String, String>();

    public QueryExecutorBuilder(String method, String fields) {
        this.method = method;
        this.fields = fields;
    }

    public <T> void addToQuery(String name, T someValue) {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER().configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            this.args.put(name, mapper.writeValueAsString(someValue));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toGraphQLQuery() {
        String filters = this.args.entrySet().stream().map(entrySet -> (String)entrySet.getKey() + ": " + (String)entrySet.getValue()).collect(Collectors.joining(", "));
        return "%s( %s ){\n  %s\n}\n".formatted(this.method, filters, this.fields);
    }
}

