/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.foreign.Arena;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.ffi.SdkResponseHandler;
import tech.deplant.java4ever.binding.loader.DefaultLoaderContext;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public record EverSdkContext(int id, @JsonIgnore ObjectMapper mapper, long timeout, AtomicInteger requestCount, Map<Integer, SdkResponseHandler> responses, ExecutorService executor) {
    private static final System.Logger logger = System.getLogger(EverSdkContext.class.getName());

    public EverSdkContext(int id, int requestCount, long timeout, ObjectMapper mapper) {
        this(id, mapper, timeout, new AtomicInteger(requestCount), new ConcurrentHashMap<Integer, SdkResponseHandler>(), Executors.newVirtualThreadPerTaskExecutor());
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T, P, A> T callAppObject(String functionName, P params, A appObject, Class<T> clazz) throws EverSdkException {
        return this.call(functionName, params, clazz);
    }

    public <T, P> T callEvent(String functionName, P params, Consumer<String> consumer, Class<T> clazz) throws EverSdkException {
        int requestId = this.requestCount().incrementAndGet();
        SdkResponseHandler handler = new SdkResponseHandler(this, requestId, functionName, this.processParams(params), consumer, null);
        T result = this.processResult(this.processRequest(handler), clazz);
        if (result instanceof Net.ResultOfSubscribeCollection) {
            Net.ResultOfSubscribeCollection resultOfSubscribeCollection = (Net.ResultOfSubscribeCollection)result;
            handler.saveHandle(resultOfSubscribeCollection.handle());
            logger.log(System.Logger.Level.TRACE, () -> "Subscription handle saved: " + resultOfSubscribeCollection.handle());
        }
        return result;
    }

    public <T, P> T call(String functionName, P params, Class<T> clazz) throws EverSdkException {
        int requestId = this.requestCount().incrementAndGet();
        T result = this.processResult(this.processRequest(new SdkResponseHandler(this, requestId, functionName, this.processParams(params), null, null)), clazz);
        this.responses().remove(requestId);
        logger.log(System.Logger.Level.TRACE, () -> "Removing request by result acception: " + requestId);
        return result;
    }

    public <P> void callVoid(String functionName, P params) throws EverSdkException {
        int requestId = this.requestCount().incrementAndGet();
        this.processRequest(new SdkResponseHandler(this, requestId, functionName, this.processParams(params), null, null));
        this.responses().remove(requestId);
    }

    private SdkResponseHandler processRequest(SdkResponseHandler handler) throws EverSdkException {
        this.responses().put(handler.requestId(), handler);
        try (Arena offHeapMemory = Arena.openShared();){
            handler.request(this.executor(), offHeapMemory.scope());
        }
        return handler;
    }

    private <P> String processParams(P params) throws EverSdkException {
        try {
            return null == params ? "" : this.mapper.writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Parameters serialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-501L, "Parameters serialization failed!"), (Throwable)e);
        }
    }

    private <T> T processResult(SdkResponseHandler handler, Class<T> clazz) throws EverSdkException {
        try {
            return (T)this.mapper.readValue(handler.result(this.mapper, this.timeout(), TimeUnit.MILLISECONDS), clazz);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Successful response deserialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-500L, "Successful response deserialization failed! Check getCause() for actual response."), (Throwable)e);
        }
    }

    public static class Builder {
        private long timeout = 60000L;
        private String configJson = "{}";
        private ObjectMapper jsonMapper;

        public Builder setConfigJson(String configJson) {
            this.configJson = configJson;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        public EverSdkContext buildFromExisting(int existingContextId, int existingContextRequestCount) {
            return new EverSdkContext(existingContextId, existingContextRequestCount, this.timeout, this.jsonMapper);
        }

        public EverSdkContext buildNew(LibraryLoader loader) throws JsonProcessingException {
            Client.ClientConfig defaults;
            Client.ClientConfig mergedConfig;
            String mergedJson;
            ResultOfCreateContext createContextResponse;
            if (this.jsonMapper == null) {
                this.jsonMapper = JsonContext.SDK_JSON_MAPPER();
            }
            if ((createContextResponse = (ResultOfCreateContext)this.jsonMapper.readValue(SdkBridge.tcCreateContext(loader, mergedJson = this.jsonMapper.writeValueAsString((Object)(mergedConfig = new Client.ClientConfig(new Client.BindingConfig("java4ever", "2.5.0"), (defaults = (Client.ClientConfig)this.jsonMapper.readValue(this.configJson, Client.ClientConfig.class)).network(), defaults.crypto(), defaults.abi(), defaults.boc(), defaults.proofs(), defaults.localStoragePath())))), ResultOfCreateContext.class)).result() == null || createContextResponse.result() < 1) {
                throw new RuntimeException("sdk.create_context failed!");
            }
            return new EverSdkContext(createContextResponse.result(), 0, this.timeout, this.jsonMapper);
        }

        public EverSdkContext buildNew() throws JsonProcessingException {
            return this.buildNew(DefaultLoaderContext.SINGLETON(this.getClass().getClassLoader()));
        }

        public record ResultOfCreateContext(Integer result, String error) {
        }
    }
}

