/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Abi {
    public static ResultOfEncodeMessageBody encodeMessageBody(EverSdkContext ctx, ABI abi, CallSet callSet, Boolean isInternal, Signer signer, Integer processingTryIndex, String address, Long signatureId) throws EverSdkException {
        return ctx.call("abi.encode_message_body", new ParamsOfEncodeMessageBody(abi, callSet, isInternal, signer, processingTryIndex, address, signatureId), ResultOfEncodeMessageBody.class);
    }

    public static ResultOfAttachSignatureToMessageBody attachSignatureToMessageBody(EverSdkContext ctx, ABI abi, String publicKey, String message, String signature) throws EverSdkException {
        return ctx.call("abi.attach_signature_to_message_body", new ParamsOfAttachSignatureToMessageBody(abi, publicKey, message, signature), ResultOfAttachSignatureToMessageBody.class);
    }

    public static ResultOfEncodeMessage encodeMessage(EverSdkContext ctx, ABI abi, String address, DeploySet deploySet, CallSet callSet, Signer signer, Integer processingTryIndex, Long signatureId) throws EverSdkException {
        return ctx.call("abi.encode_message", new ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex, signatureId), ResultOfEncodeMessage.class);
    }

    public static ResultOfEncodeInternalMessage encodeInternalMessage(EverSdkContext ctx, ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, String value, Boolean bounce, Boolean enableIhr) throws EverSdkException {
        return ctx.call("abi.encode_internal_message", new ParamsOfEncodeInternalMessage(abi, address, srcAddress, deploySet, callSet, value, bounce, enableIhr), ResultOfEncodeInternalMessage.class);
    }

    public static ResultOfAttachSignature attachSignature(EverSdkContext ctx, ABI abi, String publicKey, String message, String signature) throws EverSdkException {
        return ctx.call("abi.attach_signature", new ParamsOfAttachSignature(abi, publicKey, message, signature), ResultOfAttachSignature.class);
    }

    public static DecodedMessageBody decodeMessage(EverSdkContext ctx, ABI abi, String message, Boolean allowPartial, String functionName, DataLayout dataLayout) throws EverSdkException {
        return ctx.call("abi.decode_message", new ParamsOfDecodeMessage(abi, message, allowPartial, functionName, dataLayout), DecodedMessageBody.class);
    }

    public static DecodedMessageBody decodeMessageBody(EverSdkContext ctx, ABI abi, String body, Boolean isInternal, Boolean allowPartial, String functionName, DataLayout dataLayout) throws EverSdkException {
        return ctx.call("abi.decode_message_body", new ParamsOfDecodeMessageBody(abi, body, isInternal, allowPartial, functionName, dataLayout), DecodedMessageBody.class);
    }

    public static ResultOfEncodeAccount encodeAccount(EverSdkContext ctx, StateInitSource stateInit, BigInteger balance, BigInteger lastTransLt, Long lastPaid, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_account", new ParamsOfEncodeAccount(stateInit, balance, lastTransLt, lastPaid, bocCache), ResultOfEncodeAccount.class);
    }

    public static ResultOfDecodeAccountData decodeAccountData(EverSdkContext ctx, ABI abi, String data, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_account_data", new ParamsOfDecodeAccountData(abi, data, allowPartial), ResultOfDecodeAccountData.class);
    }

    public static ResultOfUpdateInitialData updateInitialData(EverSdkContext ctx, ABI abi, String data, JsonNode initialData, String initialPubkey, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.update_initial_data", new ParamsOfUpdateInitialData(abi, data, initialData, initialPubkey, bocCache), ResultOfUpdateInitialData.class);
    }

    public static ResultOfEncodeInitialData encodeInitialData(EverSdkContext ctx, ABI abi, JsonNode initialData, String initialPubkey, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_initial_data", new ParamsOfEncodeInitialData(abi, initialData, initialPubkey, bocCache), ResultOfEncodeInitialData.class);
    }

    public static ResultOfDecodeInitialData decodeInitialData(EverSdkContext ctx, ABI abi, String data, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_initial_data", new ParamsOfDecodeInitialData(abi, data, allowPartial), ResultOfDecodeInitialData.class);
    }

    public static ResultOfDecodeBoc decodeBoc(EverSdkContext ctx, AbiParam[] params, String boc, Boolean allowPartial) throws EverSdkException {
        return ctx.call("abi.decode_boc", new ParamsOfDecodeBoc(params, boc, allowPartial), ResultOfDecodeBoc.class);
    }

    public static ResultOfAbiEncodeBoc encodeBoc(EverSdkContext ctx, AbiParam[] params, JsonNode data, Boc.BocCacheType bocCache) throws EverSdkException {
        return ctx.call("abi.encode_boc", new ParamsOfAbiEncodeBoc(params, data, bocCache), ResultOfAbiEncodeBoc.class);
    }

    public static ResultOfCalcFunctionId calcFunctionId(EverSdkContext ctx, ABI abi, String functionName, Boolean output) throws EverSdkException {
        return ctx.call("abi.calc_function_id", new ParamsOfCalcFunctionId(abi, functionName, output), ResultOfCalcFunctionId.class);
    }

    public static ResultOfGetSignatureData getSignatureData(EverSdkContext ctx, ABI abi, String message, Long signatureId) throws EverSdkException {
        return ctx.call("abi.get_signature_data", new ParamsOfGetSignatureData(abi, message, signatureId), ResultOfGetSignatureData.class);
    }

    public record ParamsOfEncodeMessageBody(ABI abi, CallSet callSet, Boolean isInternal, Signer signer, Integer processingTryIndex, String address, Long signatureId) {
    }

    public static sealed interface ABI {

        public record Serialized(AbiContract value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Serialized";
            }
        }

        public record Handle(Long value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Handle";
            }
        }

        public record Json(String value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Json";
            }
        }

        public record Contract(AbiContract value) implements ABI
        {
            @JsonProperty(value="type")
            public String type() {
                return "Contract";
            }
        }
    }

    public record CallSet(String functionName, FunctionHeader header, JsonNode input) {
    }

    public static sealed interface Signer {

        public record SigningBox(Long handle) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "SigningBox";
            }
        }

        public record Keys(Crypto.KeyPair keys) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "Keys";
            }
        }

        public record External(String publicKey) implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "External";
            }
        }

        public record None() implements Signer
        {
            @JsonProperty(value="type")
            public String type() {
                return "None";
            }
        }
    }

    public record ResultOfEncodeMessageBody(String body, String dataToSign) {
    }

    public record ParamsOfAttachSignatureToMessageBody(ABI abi, String publicKey, String message, String signature) {
    }

    public record ResultOfAttachSignatureToMessageBody(String body) {
    }

    public record ParamsOfEncodeMessage(ABI abi, String address, DeploySet deploySet, CallSet callSet, Signer signer, Integer processingTryIndex, Long signatureId) implements MessageSource
    {
        @JsonProperty(value="type")
        public String type() {
            return "EncodingParams";
        }
    }

    public record DeploySet(String tvc, String code, String stateInit, Long workchainId, JsonNode initialData, String initialPubkey) {
    }

    public record ResultOfEncodeMessage(String message, String dataToSign, String address, String messageId) {
    }

    public record ParamsOfEncodeInternalMessage(ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, String value, Boolean bounce, Boolean enableIhr) {
    }

    public record ResultOfEncodeInternalMessage(String message, String address, String messageId) {
    }

    public record ParamsOfAttachSignature(ABI abi, String publicKey, String message, String signature) {
    }

    public record ResultOfAttachSignature(String message, String messageId) {
    }

    public record ParamsOfDecodeMessage(ABI abi, String message, Boolean allowPartial, String functionName, DataLayout dataLayout) {
    }

    public static enum DataLayout {
        Input,
        Output;

    }

    public record DecodedMessageBody(MessageBodyType bodyType, String name, JsonNode value, FunctionHeader header) {
    }

    public record ParamsOfDecodeMessageBody(ABI abi, String body, Boolean isInternal, Boolean allowPartial, String functionName, DataLayout dataLayout) {
    }

    public record ParamsOfEncodeAccount(StateInitSource stateInit, BigInteger balance, BigInteger lastTransLt, Long lastPaid, Boc.BocCacheType bocCache) {
    }

    public static sealed interface StateInitSource {

        public record Tvc(String tvc, String publicKey, StateInitParams initParams) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Tvc";
            }
        }

        public record StateInit(String code, String data, String library) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "StateInit";
            }
        }

        public record Message(MessageSource source) implements StateInitSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Message";
            }
        }
    }

    public record ResultOfEncodeAccount(String account, String id) {
    }

    public record ParamsOfDecodeAccountData(ABI abi, String data, Boolean allowPartial) {
    }

    public record ResultOfDecodeAccountData(JsonNode data) {
    }

    public record ParamsOfUpdateInitialData(ABI abi, String data, JsonNode initialData, String initialPubkey, Boc.BocCacheType bocCache) {
    }

    public record ResultOfUpdateInitialData(String data) {
    }

    public record ParamsOfEncodeInitialData(ABI abi, JsonNode initialData, String initialPubkey, Boc.BocCacheType bocCache) {
    }

    public record ResultOfEncodeInitialData(String data) {
    }

    public record ParamsOfDecodeInitialData(ABI abi, String data, Boolean allowPartial) {
    }

    public record ResultOfDecodeInitialData(JsonNode initialData, String initialPubkey) {
    }

    public record ParamsOfDecodeBoc(AbiParam[] params, String boc, Boolean allowPartial) {
    }

    public record AbiParam(String name, String type, AbiParam[] components) {
    }

    public record ResultOfDecodeBoc(JsonNode data) {
    }

    public record ParamsOfAbiEncodeBoc(AbiParam[] params, JsonNode data, Boc.BocCacheType bocCache) {
    }

    public record ResultOfAbiEncodeBoc(String boc) {
    }

    public record ParamsOfCalcFunctionId(ABI abi, String functionName, Boolean output) {
    }

    public record ResultOfCalcFunctionId(Long functionId) {
    }

    public record ParamsOfGetSignatureData(ABI abi, String message, Long signatureId) {
    }

    public record ResultOfGetSignatureData(String signature, String unsigned) {
    }

    public record FunctionHeader(Long expire, BigInteger time, String pubkey) {
    }

    public static enum AbiErrorCode {
        RequiredAddressMissingForEncodeMessage(301),
        RequiredCallSetMissingForEncodeMessage(302),
        InvalidJson(303),
        InvalidMessage(304),
        EncodeDeployMessageFailed(305),
        EncodeRunMessageFailed(306),
        AttachSignatureFailed(307),
        InvalidTvcImage(308),
        RequiredPublicKeyMissingForFunctionHeader(309),
        InvalidSigner(310),
        InvalidAbi(311),
        InvalidFunctionId(312),
        InvalidData(313),
        EncodeInitialDataFailed(314),
        InvalidFunctionName(315);

        private final Integer value;

        private AbiErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record StateInitParams(ABI abi, JsonNode value) {
    }

    public record AbiData(Long key, String name, String type, AbiParam[] components) {
    }

    public static sealed interface MessageSource
    permits Encoded, ParamsOfEncodeMessage {

        public record Encoded(String message, ABI abi) implements MessageSource
        {
            @JsonProperty(value="type")
            public String type() {
                return "Encoded";
            }
        }
    }

    @JsonIgnoreProperties(value={"outputs"})
    public record AbiEvent(String name, AbiParam[] inputs, String id) {
    }

    public record AbiFunction(String name, AbiParam[] inputs, AbiParam[] outputs, String id) {
    }

    public static enum MessageBodyType {
        Input,
        Output,
        InternalOutput,
        Event;

    }

    public record AbiContract(@JsonProperty(value="ABI version") Long abiVersionMajor, Long abiVersion, String version, String[] header, AbiFunction[] functions, AbiEvent[] events, AbiData[] data, AbiParam[] fields) {
    }
}

