/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Utils {
    public static ResultOfConvertAddress convertAddress(EverSdkContext ctx, String address, AddressStringFormat outputFormat) throws EverSdkException {
        return ctx.call("utils.convert_address", new ParamsOfConvertAddress(address, outputFormat), ResultOfConvertAddress.class);
    }

    public static ResultOfGetAddressType getAddressType(EverSdkContext ctx, String address) throws EverSdkException {
        return ctx.call("utils.get_address_type", new ParamsOfGetAddressType(address), ResultOfGetAddressType.class);
    }

    public static ResultOfCalcStorageFee calcStorageFee(EverSdkContext ctx, String account, Integer period) throws EverSdkException {
        return ctx.call("utils.calc_storage_fee", new ParamsOfCalcStorageFee(account, period), ResultOfCalcStorageFee.class);
    }

    public static ResultOfCompressZstd compressZstd(EverSdkContext ctx, String uncompressed, Integer level) throws EverSdkException {
        return ctx.call("utils.compress_zstd", new ParamsOfCompressZstd(uncompressed, level), ResultOfCompressZstd.class);
    }

    public static ResultOfDecompressZstd decompressZstd(EverSdkContext ctx, String compressed) throws EverSdkException {
        return ctx.call("utils.decompress_zstd", new ParamsOfDecompressZstd(compressed), ResultOfDecompressZstd.class);
    }

    public record ParamsOfConvertAddress(String address, AddressStringFormat outputFormat) {
    }

    public static sealed interface AddressStringFormat {

        public record Base64(Boolean url, Boolean test, Boolean bounce) implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "Base64";
            }
        }

        public record Hex() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "Hex";
            }
        }

        public record AccountId() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "AccountId";
            }
        }
    }

    public record ResultOfConvertAddress(String address) {
    }

    public record ParamsOfGetAddressType(String address) {
    }

    public record ResultOfGetAddressType(AccountAddressType addressType) {
    }

    public record ParamsOfCalcStorageFee(String account, Integer period) {
    }

    public record ResultOfCalcStorageFee(String fee) {
    }

    public record ParamsOfCompressZstd(String uncompressed, Integer level) {
    }

    public record ResultOfCompressZstd(String compressed) {
    }

    public record ParamsOfDecompressZstd(String compressed) {
    }

    public record ResultOfDecompressZstd(String decompressed) {
    }

    public static enum AccountAddressType {
        AccountId,
        Hex,
        Base64;

    }
}

