/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Boc {
    public static ResultOfDecodeTvc decodeTvc(EverSdkContext ctx, String tvc) throws EverSdkException {
        return ctx.call("boc.decode_tvc", new ParamsOfDecodeTvc(tvc), ResultOfDecodeTvc.class);
    }

    public static ResultOfParse parseMessage(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_message", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseTransaction(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_transaction", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseAccount(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_account", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseBlock(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_block", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseShardstate(EverSdkContext ctx, String boc, String id, Integer workchainId) throws EverSdkException {
        return ctx.call("boc.parse_shardstate", new ParamsOfParseShardstate(boc, id, workchainId), ResultOfParse.class);
    }

    public static ResultOfGetBlockchainConfig getBlockchainConfig(EverSdkContext ctx, String blockBoc) throws EverSdkException {
        return ctx.call("boc.get_blockchain_config", new ParamsOfGetBlockchainConfig(blockBoc), ResultOfGetBlockchainConfig.class);
    }

    public static ResultOfGetBocHash getBocHash(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.get_boc_hash", new ParamsOfGetBocHash(boc), ResultOfGetBocHash.class);
    }

    public static ResultOfGetBocDepth getBocDepth(EverSdkContext ctx, String boc) throws EverSdkException {
        return ctx.call("boc.get_boc_depth", new ParamsOfGetBocDepth(boc), ResultOfGetBocDepth.class);
    }

    public static ResultOfGetCodeFromTvc getCodeFromTvc(EverSdkContext ctx, String tvc) throws EverSdkException {
        return ctx.call("boc.get_code_from_tvc", new ParamsOfGetCodeFromTvc(tvc), ResultOfGetCodeFromTvc.class);
    }

    public static ResultOfBocCacheGet cacheGet(EverSdkContext ctx, String bocRef) throws EverSdkException {
        return ctx.call("boc.cache_get", new ParamsOfBocCacheGet(bocRef), ResultOfBocCacheGet.class);
    }

    public static ResultOfBocCacheSet cacheSet(EverSdkContext ctx, String boc, BocCacheType cacheType) throws EverSdkException {
        return ctx.call("boc.cache_set", new ParamsOfBocCacheSet(boc, cacheType), ResultOfBocCacheSet.class);
    }

    public static void cacheUnpin(EverSdkContext ctx, String pin, String bocRef) throws EverSdkException {
        ctx.callVoid("boc.cache_unpin", new ParamsOfBocCacheUnpin(pin, bocRef));
    }

    public static ResultOfEncodeBoc encodeBoc(EverSdkContext ctx, BuilderOp[] builder, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_boc", new ParamsOfEncodeBoc(builder, bocCache), ResultOfEncodeBoc.class);
    }

    public static ResultOfGetCodeSalt getCodeSalt(EverSdkContext ctx, String code, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.get_code_salt", new ParamsOfGetCodeSalt(code, bocCache), ResultOfGetCodeSalt.class);
    }

    public static ResultOfSetCodeSalt setCodeSalt(EverSdkContext ctx, String code, String salt, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.set_code_salt", new ParamsOfSetCodeSalt(code, salt, bocCache), ResultOfSetCodeSalt.class);
    }

    public static ResultOfDecodeStateInit decodeStateInit(EverSdkContext ctx, String stateInit, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.decode_state_init", new ParamsOfDecodeStateInit(stateInit, bocCache), ResultOfDecodeStateInit.class);
    }

    public static ResultOfEncodeStateInit encodeStateInit(EverSdkContext ctx, String code, String data, String library, Boolean tick, Boolean tock, Integer splitDepth, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_state_init", new ParamsOfEncodeStateInit(code, data, library, tick, tock, splitDepth, bocCache), ResultOfEncodeStateInit.class);
    }

    public static ResultOfEncodeExternalInMessage encodeExternalInMessage(EverSdkContext ctx, String src, String dst, String init, String body, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_external_in_message", new ParamsOfEncodeExternalInMessage(src, dst, init, body, bocCache), ResultOfEncodeExternalInMessage.class);
    }

    public static ResultOfGetCompilerVersion getCompilerVersion(EverSdkContext ctx, String code) throws EverSdkException {
        return ctx.call("boc.get_compiler_version", new ParamsOfGetCompilerVersion(code), ResultOfGetCompilerVersion.class);
    }

    public record ParamsOfDecodeTvc(String tvc) {
    }

    public record ResultOfDecodeTvc(Tvc tvc) {
    }

    public record ParamsOfParse(String boc) {
    }

    public record ResultOfParse(Map<String, Object> parsed) {
    }

    public record ParamsOfParseShardstate(String boc, String id, Integer workchainId) {
    }

    public record ParamsOfGetBlockchainConfig(String blockBoc) {
    }

    public record ResultOfGetBlockchainConfig(String configBoc) {
    }

    public record ParamsOfGetBocHash(String boc) {
    }

    public record ResultOfGetBocHash(String hash) {
    }

    public record ParamsOfGetBocDepth(String boc) {
    }

    public record ResultOfGetBocDepth(Integer depth) {
    }

    public record ParamsOfGetCodeFromTvc(String tvc) {
    }

    public record ResultOfGetCodeFromTvc(String code) {
    }

    public record ParamsOfBocCacheGet(String bocRef) {
    }

    public record ResultOfBocCacheGet(String boc) {
    }

    public record ParamsOfBocCacheSet(String boc, BocCacheType cacheType) {
    }

    public static sealed interface BocCacheType {

        public record Unpinned() implements BocCacheType
        {
            @JsonProperty(value="type")
            public String type() {
                return "Unpinned";
            }
        }

        public record Pinned(String pin) implements BocCacheType
        {
            @JsonProperty(value="type")
            public String type() {
                return "Pinned";
            }
        }
    }

    public record ResultOfBocCacheSet(String bocRef) {
    }

    public record ParamsOfBocCacheUnpin(String pin, String bocRef) {
    }

    public record ParamsOfEncodeBoc(BuilderOp[] builder, BocCacheType bocCache) {
    }

    public static sealed interface BuilderOp {

        public record Address(String address) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return "Address";
            }
        }

        public record CellBoc(String boc) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return "CellBoc";
            }
        }

        public record Cell(BuilderOp[] builder) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return "Cell";
            }
        }

        public record BitString(String value) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return "BitString";
            }
        }

        public record Integer(java.lang.Integer size, String value) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return "Integer";
            }
        }
    }

    public record ResultOfEncodeBoc(String boc) {
    }

    public record ParamsOfGetCodeSalt(String code, BocCacheType bocCache) {
    }

    public record ResultOfGetCodeSalt(String salt) {
    }

    public record ParamsOfSetCodeSalt(String code, String salt, BocCacheType bocCache) {
    }

    public record ResultOfSetCodeSalt(String code) {
    }

    public record ParamsOfDecodeStateInit(String stateInit, BocCacheType bocCache) {
    }

    public record ResultOfDecodeStateInit(String code, String codeHash, Integer codeDepth, String data, String dataHash, Integer dataDepth, String library, Boolean tick, Boolean tock, Integer splitDepth, String compilerVersion) {
    }

    public record ParamsOfEncodeStateInit(String code, String data, String library, Boolean tick, Boolean tock, Integer splitDepth, BocCacheType bocCache) {
    }

    public record ResultOfEncodeStateInit(String stateInit) {
    }

    public record ParamsOfEncodeExternalInMessage(String src, String dst, String init, String body, BocCacheType bocCache) {
    }

    public record ResultOfEncodeExternalInMessage(String message, String messageId) {
    }

    public record ParamsOfGetCompilerVersion(String code) {
    }

    public record ResultOfGetCompilerVersion(String version) {
    }

    public record TvcV1(String code, String description) {
    }

    public static sealed interface Tvc {

        public record V1(TvcV1 value) implements Tvc
        {
            @JsonProperty(value="type")
            public String type() {
                return "V1";
            }
        }
    }

    public static enum BocErrorCode {
        InvalidBoc(201),
        SerializationError(202),
        InappropriateBlock(203),
        MissingSourceBoc(204),
        InsufficientCacheSize(205),
        BocRefNotFound(206),
        InvalidBocRef(207);

        private final Integer value;

        private BocErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }
}

