/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Tvm;

public final class Processing {
    public static void monitorMessages(Context ctx, String queue, MessageMonitoringParams[] messages) throws EverSdkException {
        ctx.callVoid("processing.monitor_messages", new ParamsOfMonitorMessages(queue, messages));
    }

    public static MonitoringQueueInfo getMonitorInfo(Context ctx, String queue) throws EverSdkException {
        return ctx.call("processing.get_monitor_info", new ParamsOfGetMonitorInfo(queue), MonitoringQueueInfo.class);
    }

    public static ResultOfFetchNextMonitorResults fetchNextMonitorResults(Context ctx, String queue, MonitorFetchWaitMode waitMode) throws EverSdkException {
        return ctx.call("processing.fetch_next_monitor_results", new ParamsOfFetchNextMonitorResults(queue, waitMode), ResultOfFetchNextMonitorResults.class);
    }

    public static void cancelMonitor(Context ctx, String queue) throws EverSdkException {
        ctx.callVoid("processing.cancel_monitor", new ParamsOfCancelMonitor(queue));
    }

    public static ResultOfSendMessages sendMessages(Context ctx, MessageSendingParams[] messages, String monitorQueue) throws EverSdkException {
        return ctx.call("processing.send_messages", new ParamsOfSendMessages(messages, monitorQueue), ResultOfSendMessages.class);
    }

    public static ResultOfSendMessage sendMessage(Context ctx, String message, Abi.ABI abi, Boolean sendEvents) throws EverSdkException {
        return ctx.call("processing.send_message", new ParamsOfSendMessage(message, abi, sendEvents), ResultOfSendMessage.class);
    }

    public static ResultOfProcessMessage waitForTransaction(Context ctx, Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints) throws EverSdkException {
        return ctx.call("processing.wait_for_transaction", new ParamsOfWaitForTransaction(abi, message, shardBlockId, sendEvents, sendingEndpoints), ResultOfProcessMessage.class);
    }

    public static ResultOfProcessMessage processMessage(Context ctx, Abi.ABI abi, String address, Abi.DeploySet deploySet, Abi.CallSet callSet, Abi.Signer signer, Integer processingTryIndex, Integer signatureId, Boolean sendEvents) throws EverSdkException {
        return ctx.call("processing.process_message", new ParamsOfProcessMessage(new Abi.ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex, signatureId), sendEvents), ResultOfProcessMessage.class);
    }

    public record ParamsOfMonitorMessages(String queue, MessageMonitoringParams[] messages) {
    }

    public record MessageMonitoringParams(MonitoredMessage message, Integer waitUntil, Map<String, Object> userData) {
    }

    public record ParamsOfGetMonitorInfo(String queue) {
    }

    public record MonitoringQueueInfo(Integer unresolved, Integer resolved) {
    }

    public record ParamsOfFetchNextMonitorResults(String queue, MonitorFetchWaitMode waitMode) {
    }

    public static enum MonitorFetchWaitMode {
        AtLeastOne,
        All,
        NoWait;

    }

    public record ResultOfFetchNextMonitorResults(MessageMonitoringResult[] results) {
    }

    public record ParamsOfCancelMonitor(String queue) {
    }

    public record ParamsOfSendMessages(MessageSendingParams[] messages, String monitorQueue) {
    }

    public record MessageSendingParams(String boc, Integer waitUntil, Map<String, Object> userData) {
    }

    public record ResultOfSendMessages(MessageMonitoringParams[] messages) {
    }

    public record ParamsOfSendMessage(String message, Abi.ABI abi, Boolean sendEvents) {
    }

    public record ResultOfSendMessage(String shardBlockId, String[] sendingEndpoints) {
    }

    public record ParamsOfWaitForTransaction(Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints) {
    }

    public record ResultOfProcessMessage(Map<String, Object> transaction, String[] outMessages, DecodedOutput decoded, Tvm.TransactionFees fees) {
    }

    public record ParamsOfProcessMessage(Abi.ParamsOfEncodeMessage messageEncodeParams, Boolean sendEvents) {
    }

    public static enum ProcessingErrorCode {
        MessageAlreadyExpired(501),
        MessageHasNotDestinationAddress(502),
        CanNotBuildMessageCell(503),
        FetchBlockFailed(504),
        SendMessageFailed(505),
        InvalidMessageBoc(506),
        MessageExpired(507),
        TransactionWaitTimeout(508),
        InvalidBlockReceived(509),
        CanNotCheckBlockShard(510),
        BlockNotFound(511),
        InvalidData(512),
        ExternalSignerMustNotBeUsed(513),
        MessageRejected(514),
        InvalidRempStatus(515),
        NextRempStatusTimeout(516);

        private final Integer value;

        private ProcessingErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record MessageMonitoringResult(String hash, MessageMonitoringStatus status, MessageMonitoringTransaction transaction, String error, Map<String, Object> userData) {
    }

    public static enum MessageMonitoringStatus {
        Finalized,
        Timeout,
        Reserved;

    }

    public record MessageMonitoringTransactionCompute(Integer exitCode) {
    }

    public static sealed interface ProcessingEvent {

        public record RempError(String messageId, String messageDst, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempError";
            }
        }

        public record RempOther(String messageId, String messageDst, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempOther";
            }
        }

        public record RempIncludedIntoAcceptedBlock(String messageId, String messageDst, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoAcceptedBlock";
            }
        }

        public record RempIncludedIntoBlock(String messageId, String messageDst, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoBlock";
            }
        }

        public record RempSentToValidators(String messageId, String messageDst, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempSentToValidators";
            }
        }

        public record MessageExpired(String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "MessageExpired";
            }
        }

        public record FetchNextBlockFailed(String shardBlockId, String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchNextBlockFailed";
            }
        }

        public record WillFetchNextBlock(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchNextBlock";
            }
        }

        public record SendFailed(String shardBlockId, String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "SendFailed";
            }
        }

        public record DidSend(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "DidSend";
            }
        }

        public record WillSend(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillSend";
            }
        }

        public record FetchFirstBlockFailed(Client.ClientError error, String messageId, String messageDst) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchFirstBlockFailed";
            }
        }

        public record WillFetchFirstBlock(String messageId, String messageDst) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchFirstBlock";
            }
        }
    }

    public record MessageMonitoringTransaction(String hash, Boolean aborted, MessageMonitoringTransactionCompute compute) {
    }

    public static sealed interface MonitoredMessage {

        public record HashAddress(String hash, String address) implements MonitoredMessage
        {
            @JsonProperty(value="type")
            public String type() {
                return "HashAddress";
            }
        }

        public record Boc(String boc) implements MonitoredMessage
        {
            @JsonProperty(value="type")
            public String type() {
                return "Boc";
            }
        }
    }

    public record DecodedOutput(Abi.DecodedMessageBody[] outMessages, Map<String, Object> output) {
    }
}

