/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Net {
    public static ResultOfQuery query(Context ctx, String query, Map<String, Object> variables) throws EverSdkException {
        return ctx.call("net.query", new ParamsOfQuery(query, variables), ResultOfQuery.class);
    }

    public static ResultOfBatchQuery batchQuery(Context ctx, ParamsOfQueryOperation[] operations) throws EverSdkException {
        return ctx.call("net.batch_query", new ParamsOfBatchQuery(operations), ResultOfBatchQuery.class);
    }

    public static ResultOfQueryCollection queryCollection(Context ctx, String collection, Map<String, Object> filter, String result, OrderBy[] order, Integer limit) throws EverSdkException {
        return ctx.call("net.query_collection", new ParamsOfQueryCollection(collection, filter, result, order, limit), ResultOfQueryCollection.class);
    }

    public static ResultOfAggregateCollection aggregateCollection(Context ctx, String collection, Map<String, Object> filter, FieldAggregation[] fields) throws EverSdkException {
        return ctx.call("net.aggregate_collection", new ParamsOfAggregateCollection(collection, filter, fields), ResultOfAggregateCollection.class);
    }

    public static ResultOfWaitForCollection waitForCollection(Context ctx, String collection, Map<String, Object> filter, String result, Integer timeout) throws EverSdkException {
        return ctx.call("net.wait_for_collection", new ParamsOfWaitForCollection(collection, filter, result, timeout), ResultOfWaitForCollection.class);
    }

    public static void unsubscribe(Context ctx, ResultOfSubscribeCollection params) throws EverSdkException {
        ctx.callVoid("net.unsubscribe", params);
    }

    public static ResultOfSubscribeCollection subscribeCollection(Context ctx, String collection, Map<String, Object> filter, String result) throws EverSdkException {
        return ctx.call("net.subscribe_collection", new ParamsOfSubscribeCollection(collection, filter, result), ResultOfSubscribeCollection.class);
    }

    public static ResultOfSubscribeCollection subscribe(Context ctx, String subscription, Map<String, Object> variables) throws EverSdkException {
        return ctx.call("net.subscribe", new ParamsOfSubscribe(subscription, variables), ResultOfSubscribeCollection.class);
    }

    public static void suspend(Context ctx) throws EverSdkException {
        ctx.callVoid("net.suspend", null);
    }

    public static void resume(Context ctx) throws EverSdkException {
        ctx.callVoid("net.resume", null);
    }

    public static ResultOfFindLastShardBlock findLastShardBlock(Context ctx, String address) throws EverSdkException {
        return ctx.call("net.find_last_shard_block", new ParamsOfFindLastShardBlock(address), ResultOfFindLastShardBlock.class);
    }

    public static EndpointsSet fetchEndpoints(Context ctx) throws EverSdkException {
        return ctx.call("net.fetch_endpoints", null, EndpointsSet.class);
    }

    public static void setEndpoints(Context ctx, EndpointsSet params) throws EverSdkException {
        ctx.callVoid("net.set_endpoints", params);
    }

    public static ResultOfGetEndpoints getEndpoints(Context ctx) throws EverSdkException {
        return ctx.call("net.get_endpoints", null, ResultOfGetEndpoints.class);
    }

    public static ResultOfQueryCollection queryCounterparties(Context ctx, String account, String result, Integer first, String after) throws EverSdkException {
        return ctx.call("net.query_counterparties", new ParamsOfQueryCounterparties(account, result, first, after), ResultOfQueryCollection.class);
    }

    public static ResultOfQueryTransactionTree queryTransactionTree(Context ctx, String inMsg, Abi.ABI[] abiRegistry, Integer timeout, Integer transactionMaxCount) throws EverSdkException {
        return ctx.call("net.query_transaction_tree", new ParamsOfQueryTransactionTree(inMsg, abiRegistry, timeout, transactionMaxCount), ResultOfQueryTransactionTree.class);
    }

    public static RegisteredIterator createBlockIterator(Context ctx, Integer startTime, Integer endTime, String[] shardFilter, String result) throws EverSdkException {
        return ctx.call("net.create_block_iterator", new ParamsOfCreateBlockIterator(startTime, endTime, shardFilter, result), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeBlockIterator(Context ctx, Map<String, Object> resumeState) throws EverSdkException {
        return ctx.call("net.resume_block_iterator", new ParamsOfResumeBlockIterator(resumeState), RegisteredIterator.class);
    }

    public static RegisteredIterator createTransactionIterator(Context ctx, Integer startTime, Integer endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) throws EverSdkException {
        return ctx.call("net.create_transaction_iterator", new ParamsOfCreateTransactionIterator(startTime, endTime, shardFilter, accountsFilter, result, includeTransfers), RegisteredIterator.class);
    }

    public static RegisteredIterator resumeTransactionIterator(Context ctx, Map<String, Object> resumeState, String[] accountsFilter) throws EverSdkException {
        return ctx.call("net.resume_transaction_iterator", new ParamsOfResumeTransactionIterator(resumeState, accountsFilter), RegisteredIterator.class);
    }

    public static ResultOfIteratorNext iteratorNext(Context ctx, Integer iterator, Integer limit, Boolean returnResumeState) throws EverSdkException {
        return ctx.call("net.iterator_next", new ParamsOfIteratorNext(iterator, limit, returnResumeState), ResultOfIteratorNext.class);
    }

    public static void removeIterator(Context ctx, RegisteredIterator params) throws EverSdkException {
        ctx.callVoid("net.remove_iterator", params);
    }

    public static ResultOfGetSignatureId getSignatureId(Context ctx) throws EverSdkException {
        return ctx.call("net.get_signature_id", null, ResultOfGetSignatureId.class);
    }

    public record ParamsOfQuery(String query, Map<String, Object> variables) {
    }

    public record ResultOfQuery(Map<String, Object> result) {
    }

    public record ParamsOfBatchQuery(ParamsOfQueryOperation[] operations) {
    }

    public static sealed interface ParamsOfQueryOperation
    permits ParamsOfQueryCollection, ParamsOfWaitForCollection, ParamsOfQueryCounterparties, ParamsOfAggregateCollection {
    }

    public record ResultOfBatchQuery(Map<String, Object>[] results) {
    }

    public record ParamsOfQueryCollection(String collection, Map<String, Object> filter, String result, OrderBy[] order, Integer limit) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCollection";
        }
    }

    public record OrderBy(String path, SortDirection direction) {
    }

    public record ResultOfQueryCollection(Map<String, Object>[] result) {
    }

    public record ParamsOfAggregateCollection(String collection, Map<String, Object> filter, FieldAggregation[] fields) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "AggregateCollection";
        }
    }

    public record FieldAggregation(String field, AggregationFn fn) {
    }

    public record ResultOfAggregateCollection(Map<String, Object> values) {
    }

    public record ParamsOfWaitForCollection(String collection, Map<String, Object> filter, String result, Integer timeout) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "WaitForCollection";
        }
    }

    public record ResultOfWaitForCollection(Map<String, Object> result) {
    }

    public record ParamsOfSubscribeCollection(String collection, Map<String, Object> filter, String result) {
    }

    public record ResultOfSubscribeCollection(Integer handle) {
    }

    public record ParamsOfSubscribe(String subscription, Map<String, Object> variables) {
    }

    public record ParamsOfFindLastShardBlock(String address) {
    }

    public record ResultOfFindLastShardBlock(String blockId) {
    }

    public record EndpointsSet(String[] endpoints) {
    }

    public record ResultOfGetEndpoints(String query, String[] endpoints) {
    }

    public record ParamsOfQueryCounterparties(String account, String result, Integer first, String after) implements ParamsOfQueryOperation
    {
        @JsonProperty(value="type")
        public String type() {
            return "QueryCounterparties";
        }
    }

    public record ParamsOfQueryTransactionTree(String inMsg, Abi.ABI[] abiRegistry, Integer timeout, Integer transactionMaxCount) {
    }

    public record ResultOfQueryTransactionTree(MessageNode[] messages, TransactionNode[] transactions) {
    }

    public record ParamsOfCreateBlockIterator(Integer startTime, Integer endTime, String[] shardFilter, String result) {
    }

    public record RegisteredIterator(Integer handle) {
    }

    public record ParamsOfResumeBlockIterator(Map<String, Object> resumeState) {
    }

    public record ParamsOfCreateTransactionIterator(Integer startTime, Integer endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
    }

    public record ParamsOfResumeTransactionIterator(Map<String, Object> resumeState, String[] accountsFilter) {
    }

    public record ParamsOfIteratorNext(Integer iterator, Integer limit, Boolean returnResumeState) {
    }

    public record ResultOfIteratorNext(Map<String, Object>[] items, Boolean hasMore, Map<String, Object> resumeState) {
    }

    public record ResultOfGetSignatureId(Integer signatureId) {
    }

    public record TransactionNode(String id, String inMsg, String[] outMsgs, String accountAddr, String totalFees, Boolean aborted, Integer exitCode) {
    }

    public static enum NetErrorCode {
        QueryFailed(601),
        SubscribeFailed(602),
        WaitForFailed(603),
        GetSubscriptionResultFailed(604),
        InvalidServerResponse(605),
        ClockOutOfSync(606),
        WaitForTimeout(607),
        GraphqlError(608),
        NetworkModuleSuspended(609),
        WebsocketDisconnected(610),
        NotSupported(611),
        NoEndpointsProvided(612),
        GraphqlWebsocketInitError(613),
        NetworkModuleResumed(614),
        Unauthorized(615),
        QueryTransactionTreeTimeout(616),
        GraphqlConnectionError(617);

        private final Integer value;

        private NetErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record MessageNode(String id, String srcTransactionId, String dstTransactionId, String src, String dst, String value, Boolean bounce, Abi.DecodedMessageBody decodedBody) {
    }

    public static enum AggregationFn {
        COUNT,
        MIN,
        MAX,
        SUM,
        AVERAGE;

    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

