/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.AppSigningBox;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Unstable;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.javapoet.AnnotationSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ClassName;
import tech.deplant.java4ever.binding.generator.javapoet.CodeBlock;
import tech.deplant.java4ever.binding.generator.javapoet.MethodSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ParameterSpec;
import tech.deplant.java4ever.binding.generator.javapoet.TypeName;
import tech.deplant.java4ever.binding.generator.jtype.JavaDocs;
import tech.deplant.java4ever.binding.generator.jtype.JavaParam;
import tech.deplant.java4ever.binding.generator.jtype.JavaType;
import tech.deplant.java4ever.binding.generator.reference.ApiFunction;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.java4ever.utils.Objs;
import tech.deplant.java4ever.utils.Strings;

public record JavaFunction(String functionModule, ApiFunction function, Map<ParserEngine.SdkType, JavaType> typeLibrary) {
    private static final System.Logger logger = System.getLogger(JavaFunction.class.getName());

    private String constructCallParams(MethodSpec.Builder methodBuilder, List<Object> statementArgs, JavaParam param) {
        StringBuilder template = new StringBuilder();
        if (Objs.isNotNull((Object)param.libType()) && param.libType().isStructure() && Strings.safeSubstrEquals((String)param.libType().name(), (int)0, (int)8, (boolean)false, (String)"ParamsOf")) {
            StructType structType = (StructType)param.libType().type();
            template.append("new $T(");
            statementArgs.add(param.refClassName());
            String innerFields = Arrays.stream(structType.struct_fields()).map(apiType -> this.constructCallParams(methodBuilder, statementArgs, JavaParam.ofApiType(apiType, this.typeLibrary()))).collect(Collectors.joining(", "));
            template.append(innerFields);
            template.append(")");
        } else {
            template.append("$N");
            ParameterSpec spec = param.poeticize().build();
            methodBuilder.addParameter(spec);
            statementArgs.add(spec);
        }
        return template.toString();
    }

    public MethodSpec.Builder poeticize() {
        TypeReference resultReference;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(ParserUtils.camelCase(this.function().name())).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addException(ClassName.get(EverSdkException.class));
        ArrayList<Object> statementArgs = new ArrayList<Object>();
        methodBuilder.addParameter(ClassName.get(Context.class), "ctx", new Modifier[0]);
        statementArgs.add(String.format("%s.%s", this.functionModule().toLowerCase(), this.function().name()));
        String templateString = "%RETURN_KEY%ctx.%CALL_TYPE%($S, %PARAMS%%APP_OBJ%%RETURN_CLASS%)";
        block12: for (ApiType param : this.function().params()) {
            logger.log(System.Logger.Level.DEBUG, this.function().name() + "\\" + param.name() + "\\" + param.type());
            JavaParam parsedParam = JavaParam.ofApiType(param, this.typeLibrary());
            switch (param.name()) {
                case "context": 
                case "_context": {
                    continue block12;
                }
                case "params": {
                    templateString = templateString.replace("%PARAMS%", this.constructCallParams(methodBuilder, statementArgs, parsedParam));
                    continue block12;
                }
                case "app_object": 
                case "password_provider": {
                    templateString = templateString.replace("%APP_OBJ%", ", appObject");
                    templateString = templateString.replace("%CALL_TYPE%", "callAppObject");
                    methodBuilder.addParameter(ClassName.get(AppSigningBox.class), "appObject", new Modifier[0]);
                    continue block12;
                }
                default: {
                    logger.log(System.Logger.Level.ERROR, "Unknown parameter: " + param.name());
                }
            }
        }
        templateString = templateString.replace("%APP_OBJ%", "");
        templateString = templateString.replace("%PARAMS%", "null");
        if (Objs.isNotNull((Object)this.function().result()) && !(resultReference = TypeReference.fromApiType(this.function().result())).isVoid()) {
            templateString = templateString.replace("%RETURN_KEY%", "return ");
            templateString = templateString.replace("%CALL_TYPE%", "call");
            templateString = templateString.replace("%RETURN_CLASS%", ", $T.class");
            TypeName typeName = resultReference.toTypeName();
            methodBuilder.returns(typeName);
            statementArgs.add(typeName);
        }
        templateString = templateString.replace("%RETURN_KEY%", "");
        templateString = templateString.replace("%CALL_TYPE%", "callVoid");
        templateString = templateString.replace("%RETURN_CLASS%", "");
        logger.log(System.Logger.Level.DEBUG, "Template: " + templateString);
        statementArgs.forEach(arg -> logger.log(System.Logger.Level.DEBUG, "Arg[]: " + arg.toString()));
        methodBuilder.addCode(CodeBlock.builder().addStatement(templateString, statementArgs.toArray()).build());
        if (Objs.isNotNull((Object)this.function().summary()) && this.function().summary().toUpperCase().contains("UNSTABLE") || Objs.isNotNull((Object)this.function().description()) && this.function().description().toUpperCase().contains("UNSTABLE")) {
            methodBuilder.addAnnotation(AnnotationSpec.builder(Unstable.class).build());
        }
        if (Objs.isNotNull((Object)this.function().summary()) && this.function().summary().toUpperCase().contains("DEPRECATED") || Objs.isNotNull((Object)this.function().description()) && this.function().description().toUpperCase().contains("DEPRECATED")) {
            methodBuilder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        methodBuilder.addJavadoc(new JavaDocs(this.function().summary(), this.function().description()).poeticize().build());
        return methodBuilder;
    }
}

