/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.generator.ParserOfModule;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.javapoet.JavaFile;
import tech.deplant.java4ever.binding.generator.javapoet.TypeSpec;
import tech.deplant.java4ever.binding.generator.jtype.JavaDocs;
import tech.deplant.java4ever.binding.generator.jtype.JavaDummy;
import tech.deplant.java4ever.binding.generator.jtype.JavaEnum;
import tech.deplant.java4ever.binding.generator.jtype.JavaFunction;
import tech.deplant.java4ever.binding.generator.jtype.JavaInterface;
import tech.deplant.java4ever.binding.generator.jtype.JavaRecord;
import tech.deplant.java4ever.binding.generator.jtype.JavaType;
import tech.deplant.java4ever.binding.generator.reference.ApiFunction;
import tech.deplant.java4ever.binding.generator.reference.ApiModule;
import tech.deplant.java4ever.binding.generator.reference.ApiReference;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.EnumOfConsts;
import tech.deplant.java4ever.binding.generator.reference.EnumOfTypes;
import tech.deplant.java4ever.binding.generator.reference.RefType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.java4ever.binding.io.JsonResource;
import tech.deplant.java4ever.binding.loader.AbsolutePathLoader;
import tech.deplant.java4ever.binding.loader.LibraryLoader;
import tech.deplant.java4ever.utils.Objs;

public class ParserEngine {
    private static final System.Logger logger = System.getLogger(ParserEngine.class.getName());

    public static ApiReference ofJsonResource(String resourceName) throws JsonProcessingException {
        return (ApiReference)ContextBuilder.DEFAULT_MAPPER.readValue(new JsonResource(resourceName).get(), ApiReference.class);
    }

    public static ApiReference ofEverSdkLibrary(LibraryLoader loader) throws JsonProcessingException, EverSdkException, EverSdkException {
        Context ctx = new ContextBuilder().setConfigJson("{}").buildNew(AbsolutePathLoader.ofSystemEnv("TON_CLIENT_LIB"));
        return (ApiReference)ContextBuilder.DEFAULT_MAPPER.convertValue(Client.getApiReference(ctx).api(), ApiReference.class);
    }

    public static void parse(ApiReference parsedApiReference) throws IOException {
        String apiVersion = parsedApiReference.version();
        HashMap<SdkType, JavaType> typeLibrary = new HashMap<SdkType, JavaType>();
        HashMap<SdkType, SdkInterfaceParent> eotReferences = new HashMap<SdkType, SdkInterfaceParent>();
        for (ApiModule module : parsedApiReference.modules()) {
            String moduleCapitalName = ParserUtils.capitalize(module.name());
            block10: for (ApiType type : module.types()) {
                ApiType apiType;
                Objects.requireNonNull(type);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnumOfConsts.class, StructType.class, EnumOfTypes.class}, (Object)apiType, n)) {
                    case 0: {
                        EnumOfConsts en = (EnumOfConsts)apiType;
                        JavaEnum jEnum = new JavaEnum(en.name(), en.enum_consts(), new JavaDocs(en.summary(), en.description()));
                        typeLibrary.put(new SdkType(moduleCapitalName, en.name()), jEnum);
                        continue block10;
                    }
                    case 1: {
                        StructType struct = (StructType)apiType;
                        boolean isParams = false;
                        boolean isResult = false;
                        if (struct.name().length() >= 8) {
                            isParams = "ParamsOf".equals(struct.name().substring(0, 8));
                            isResult = "ResultOf".equals(struct.name().substring(0, 8));
                        }
                        boolean isSimpleWrapper = struct.struct_fields().length == 1;
                        typeLibrary.put(new SdkType(moduleCapitalName, struct.name()), new JavaRecord(struct, struct.name(), null, isSimpleWrapper, isParams, isResult, typeLibrary));
                        continue block10;
                    }
                    case 2: {
                        EnumOfTypes eot = (EnumOfTypes)apiType;
                        ArrayList<JavaRecord> records = new ArrayList<JavaRecord>();
                        String interfaceName = "Abi".equals(eot.name()) ? "ABI" : eot.name();
                        block11: for (ApiType eotChildType : eot.enum_types()) {
                            ApiType apiType2;
                            Objects.requireNonNull(eotChildType);
                            int n2 = 0;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructType.class, RefType.class}, (Object)apiType2, n2)) {
                                case 0: {
                                    StructType str = (StructType)apiType2;
                                    records.add(JavaRecord.ofApiType(str, typeLibrary, new SdkInterfaceParent(moduleCapitalName, interfaceName, str.name())));
                                    continue block11;
                                }
                                case 1: {
                                    RefType ref = (RefType)apiType2;
                                    eotReferences.put(TypeReference.fromApiType(ref).toSdkType(), new SdkInterfaceParent(moduleCapitalName, interfaceName, ref.name()));
                                    continue block11;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected value: " + String.valueOf(eotChildType));
                                }
                            }
                        }
                        JavaInterface javaInterface = new JavaInterface(eot, interfaceName, new JavaDocs(eot.summary(), eot.description()), records);
                        typeLibrary.put(new SdkType(moduleCapitalName, interfaceName), javaInterface);
                        continue block10;
                    }
                    default: {
                        typeLibrary.put(new SdkType(moduleCapitalName, type.name()), new JavaDummy(type));
                    }
                }
            }
        }
        eotReferences.forEach((typ, sup) -> Objs.notNullDo((Object)((JavaType)typeLibrary.get(typ)), jtype -> typeLibrary.put((SdkType)typ, ((JavaRecord)jtype).withSuperInterface((SdkInterfaceParent)sup))));
        for (ApiModule module : parsedApiReference.modules()) {
            TypeSpec.Builder moduleBuilder = ParserOfModule.classOfModule(module, ParserUtils.capitalize(module.name()), apiVersion);
            String moduleCapitalName = ParserUtils.capitalize(module.name());
            List<JavaType> types = typeLibrary.entrySet().stream().filter(entry -> moduleCapitalName.equals(((SdkType)entry.getKey()).module())).map(Map.Entry::getValue).toList();
            eotReferences.forEach((typ, sup) -> {});
            for (JavaType typeRef : types) {
                TypeSpec.Builder builder = typeRef.poeticize();
                if (Objects.isNull(builder)) continue;
                moduleBuilder.addType(builder.build());
            }
            for (ApiFunction function : module.functions()) {
                moduleBuilder.addMethod(new JavaFunction(module.name().toLowerCase(), function, typeLibrary).poeticize().build());
            }
            JavaFile javaFile = JavaFile.builder("tech.deplant.java4ever.binding", moduleBuilder.build()).build();
            javaFile.writeTo(Paths.get("src/gen/java", new String[0]));
        }
    }

    public record SdkType(String module, String name) {
    }

    public record SdkInterfaceParent(String module, String name, String variantName) {
    }
}

