/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Tvm;

public final class Processing {
    public static ResultOfSendMessage sendMessage(Context ctx, String message, Abi.ABI abi, Boolean sendEvents) throws EverSdkException {
        return ctx.call("processing.send_message", new ParamsOfSendMessage(message, abi, sendEvents), ResultOfSendMessage.class);
    }

    public static ResultOfProcessMessage waitForTransaction(Context ctx, Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints) throws EverSdkException {
        return ctx.call("processing.wait_for_transaction", new ParamsOfWaitForTransaction(abi, message, shardBlockId, sendEvents, sendingEndpoints), ResultOfProcessMessage.class);
    }

    public static ResultOfProcessMessage processMessage(Context ctx, Abi.ABI abi, String address, Abi.DeploySet deploySet, Abi.CallSet callSet, Abi.Signer signer, Integer processingTryIndex, Boolean sendEvents) throws EverSdkException {
        return ctx.call("processing.process_message", new ParamsOfProcessMessage(new Abi.ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex), sendEvents), ResultOfProcessMessage.class);
    }

    public record ParamsOfSendMessage(String message, Abi.ABI abi, Boolean sendEvents) {
    }

    public record ResultOfSendMessage(String shardBlockId, String[] sendingEndpoints) {
    }

    public record ParamsOfWaitForTransaction(Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints) {
    }

    public record ResultOfProcessMessage(Map<String, Object> transaction, String[] outMessages, DecodedOutput decoded, Tvm.TransactionFees fees) {
    }

    public record ParamsOfProcessMessage(Abi.ParamsOfEncodeMessage messageEncodeParams, Boolean sendEvents) {
    }

    public static enum ProcessingErrorCode {
        MessageAlreadyExpired(501),
        MessageHasNotDestinationAddress(502),
        CanNotBuildMessageCell(503),
        FetchBlockFailed(504),
        SendMessageFailed(505),
        InvalidMessageBoc(506),
        MessageExpired(507),
        TransactionWaitTimeout(508),
        InvalidBlockReceived(509),
        CanNotCheckBlockShard(510),
        BlockNotFound(511),
        InvalidData(512),
        ExternalSignerMustNotBeUsed(513),
        MessageRejected(514),
        InvalidRempStatus(515),
        NextRempStatusTimeout(516);

        private final Integer value;

        private ProcessingErrorCode(Integer value) {
            this.value = value;
        }

        public Integer value() {
            return this.value;
        }
    }

    public static sealed interface ProcessingEvent {

        public record RempError(Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempError";
            }
        }

        public record RempOther(String messageId, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempOther";
            }
        }

        public record RempIncludedIntoAcceptedBlock(String messageId, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoAcceptedBlock";
            }
        }

        public record RempIncludedIntoBlock(String messageId, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoBlock";
            }
        }

        public record RempSentToValidators(String messageId, Long timestamp, Map<String, Object> json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempSentToValidators";
            }
        }

        public record MessageExpired(String messageId, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "MessageExpired";
            }
        }

        public record FetchNextBlockFailed(String shardBlockId, String messageId, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchNextBlockFailed";
            }
        }

        public record WillFetchNextBlock(String shardBlockId, String messageId, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchNextBlock";
            }
        }

        public record SendFailed(String shardBlockId, String messageId, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "SendFailed";
            }
        }

        public record DidSend(String shardBlockId, String messageId, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "DidSend";
            }
        }

        public record WillSend(String shardBlockId, String messageId, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillSend";
            }
        }

        public record FetchFirstBlockFailed(Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchFirstBlockFailed";
            }
        }

        public record WillFetchFirstBlock() implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchFirstBlock";
            }
        }
    }

    public record DecodedOutput(Abi.DecodedMessageBody[] outMessages, Map<String, Object> output) {
    }
}

