/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.ffi;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.CLinker;
import jdk.incubator.foreign.FunctionDescriptor;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import jdk.incubator.foreign.SegmentAllocator;
import jdk.incubator.foreign.SymbolLookup;

final class LinkerApi {
    private static final CLinker LINKER = CLinker.getInstance();
    private static final ClassLoader LOADER = LinkerApi.class.getClassLoader();
    private static final MethodHandles.Lookup MH_LOOKUP = MethodHandles.lookup();
    private static final SegmentAllocator THROWING_ALLOCATOR = (x, y) -> {
        throw new AssertionError((Object)"should not reach here");
    };

    private LinkerApi() {
    }

    static <T> T requireNonNull(T obj, String symbolName) {
        if (obj == null) {
            throw new UnsatisfiedLinkError("unresolved symbol: " + symbolName);
        }
        return obj;
    }

    static MemorySegment lookupGlobalVariable(SymbolLookup LOOKUP, String name, MemoryLayout layout) {
        return LOOKUP.lookup(name).map(s -> s.address().asSegment(layout.byteSize(), ResourceScope.newImplicitScope())).orElse(null);
    }

    static MethodHandle downcallHandle(SymbolLookup LOOKUP, String name, String desc, FunctionDescriptor fdesc, boolean variadic) {
        return LOOKUP.lookup(name).map(addr -> {
            MethodType mt = MethodType.fromMethodDescriptorString(desc, LOADER);
            return variadic ? VarargsInvoker.make((Addressable)addr, mt, fdesc) : LINKER.downcallHandle((Addressable)addr, mt, fdesc);
        }).orElse(null);
    }

    static MethodHandle downcallHandle(String desc, FunctionDescriptor fdesc, boolean variadic) {
        if (variadic) {
            throw new AssertionError((Object)"Cannot get here!");
        }
        MethodType mt = MethodType.fromMethodDescriptorString(desc, LOADER);
        return LINKER.downcallHandle(mt, fdesc);
    }

    static <Z> MemoryAddress upcallStub(Class<Z> fi, Z z, FunctionDescriptor fdesc, String mtypeDesc) {
        return LinkerApi.upcallStub(fi, z, fdesc, mtypeDesc, ResourceScope.newImplicitScope());
    }

    static <Z> MemoryAddress upcallStub(Class<Z> fi, Z z, FunctionDescriptor fdesc, String mtypeDesc, ResourceScope scope) {
        try {
            MethodHandle handle = MH_LOOKUP.findVirtual(fi, "apply", MethodType.fromMethodDescriptorString(mtypeDesc, LOADER));
            handle = handle.bindTo(z);
            return LINKER.upcallStub(handle, fdesc, scope);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemorySegment asArray(MemoryAddress addr, MemoryLayout layout, int numElements, ResourceScope scope) {
        return addr.asSegment((long)numElements * layout.byteSize(), scope);
    }

    private static class VarargsInvoker {
        private static final MethodHandle INVOKE_MH;
        private final Addressable symbol;
        private final MethodType varargs;
        private final FunctionDescriptor function;

        private VarargsInvoker(Addressable symbol, MethodType type, FunctionDescriptor function) {
            this.symbol = symbol;
            this.varargs = type;
            this.function = function;
        }

        static MethodHandle make(Addressable symbol, MethodType type, FunctionDescriptor function) {
            VarargsInvoker invoker = new VarargsInvoker(symbol, type, function);
            MethodHandle handle = INVOKE_MH.bindTo(invoker).asCollector(Object[].class, type.parameterCount());
            if (type.returnType().equals(MemorySegment.class)) {
                type = type.insertParameterTypes(0, SegmentAllocator.class);
            } else {
                handle = MethodHandles.insertArguments(handle, 0, THROWING_ALLOCATOR);
            }
            return handle.asType(type);
        }

        private static Class<?> unboxIfNeeded(Class<?> clazz) {
            if (clazz == Boolean.class) {
                return Boolean.TYPE;
            }
            if (clazz == Void.class) {
                return Void.TYPE;
            }
            if (clazz == Byte.class) {
                return Byte.TYPE;
            }
            if (clazz == Character.class) {
                return Character.TYPE;
            }
            if (clazz == Short.class) {
                return Short.TYPE;
            }
            if (clazz == Integer.class) {
                return Integer.TYPE;
            }
            if (clazz == Long.class) {
                return Long.TYPE;
            }
            if (clazz == Float.class) {
                return Float.TYPE;
            }
            if (clazz == Double.class) {
                return Double.TYPE;
            }
            return clazz;
        }

        private Object invoke(SegmentAllocator allocator, Object[] args) throws Throwable {
            int nNamedArgs = this.function.argumentLayouts().size();
            assert (args.length == nNamedArgs + 1);
            Object[] unnamedArgs = (Object[])args[args.length - 1];
            int argsCount = nNamedArgs + unnamedArgs.length;
            Class[] argTypes = new Class[argsCount];
            MemoryLayout[] argLayouts = new MemoryLayout[nNamedArgs + unnamedArgs.length];
            int pos = 0;
            for (pos = 0; pos < nNamedArgs; ++pos) {
                argTypes[pos] = this.varargs.parameterType(pos);
                argLayouts[pos] = (MemoryLayout)this.function.argumentLayouts().get(pos);
            }
            assert (pos == nNamedArgs);
            for (Object o : unnamedArgs) {
                argTypes[pos] = this.normalize(o.getClass());
                argLayouts[pos] = this.variadicLayout(argTypes[pos]);
                ++pos;
            }
            assert (pos == argsCount);
            MethodType mt = MethodType.methodType(this.varargs.returnType(), argTypes);
            FunctionDescriptor f = this.function.returnLayout().isEmpty() ? FunctionDescriptor.ofVoid((MemoryLayout[])argLayouts) : FunctionDescriptor.of((MemoryLayout)((MemoryLayout)this.function.returnLayout().get()), (MemoryLayout[])argLayouts);
            MethodHandle mh = LINKER.downcallHandle(this.symbol, allocator, mt, f);
            Object[] allArgs = new Object[nNamedArgs + unnamedArgs.length];
            System.arraycopy(args, 0, allArgs, 0, nNamedArgs);
            System.arraycopy(unnamedArgs, 0, allArgs, nNamedArgs, unnamedArgs.length);
            return mh.asSpreader(Object[].class, argsCount).invoke(allArgs);
        }

        private Class<?> promote(Class<?> c) {
            if (c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE || c == Integer.TYPE) {
                return Long.TYPE;
            }
            if (c == Float.TYPE) {
                return Double.TYPE;
            }
            return c;
        }

        private Class<?> normalize(Class<?> c) {
            if ((c = VarargsInvoker.unboxIfNeeded(c)).isPrimitive()) {
                return this.promote(c);
            }
            if (MemoryAddress.class.isAssignableFrom(c)) {
                return MemoryAddress.class;
            }
            if (MemorySegment.class.isAssignableFrom(c)) {
                return MemorySegment.class;
            }
            throw new IllegalArgumentException("Invalid type for ABI: " + c.getTypeName());
        }

        private MemoryLayout variadicLayout(Class<?> c) {
            if (c == Long.TYPE) {
                return CLinker.C_LONG_LONG;
            }
            if (c == Double.TYPE) {
                return CLinker.C_DOUBLE;
            }
            if (MemoryAddress.class.isAssignableFrom(c)) {
                return CLinker.C_POINTER;
            }
            throw new IllegalArgumentException("Unhandled variadic argument class: " + c);
        }

        static {
            try {
                INVOKE_MH = MethodHandles.lookup().findVirtual(VarargsInvoker.class, "invoke", MethodType.methodType(Object.class, SegmentAllocator.class, Object[].class));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

