/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.SubscribeCollectionEvent;
import tech.deplant.java4ever.binding.json.JsonData;

public class Net {
    public static CompletableFuture<ResultOfQuery> query(@NonNull Context context, @NonNull String query, Map<String, Object> variables) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return context.future("net.query", new ParamsOfQuery(query, variables), ResultOfQuery.class);
    }

    public static CompletableFuture<ResultOfBatchQuery> batchQuery(@NonNull Context context, @NonNull ParamsOfQueryOperation[] operations) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        return context.future("net.batch_query", new ParamsOfBatchQuery(operations), ResultOfBatchQuery.class);
    }

    public static CompletableFuture<ResultOfQueryCollection> queryCollection(@NonNull Context context, @NonNull String collection, Map<String, Object> filter, @NonNull String result, OrderBy[] order, Number limit) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return context.future("net.query_collection", new ParamsOfQueryCollection(collection, filter, result, order, limit), ResultOfQueryCollection.class);
    }

    public static CompletableFuture<ResultOfAggregateCollection> aggregateCollection(@NonNull Context context, @NonNull String collection, Map<String, Object> filter, FieldAggregation[] fields) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        return context.future("net.aggregate_collection", new ParamsOfAggregateCollection(collection, filter, fields), ResultOfAggregateCollection.class);
    }

    public static CompletableFuture<ResultOfWaitForCollection> waitForCollection(@NonNull Context context, @NonNull String collection, Map<String, Object> filter, @NonNull String result, Number timeout) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return context.future("net.wait_for_collection", new ParamsOfWaitForCollection(collection, filter, result, timeout), ResultOfWaitForCollection.class);
    }

    public static CompletableFuture<Void> unsubscribe(@NonNull Context context, @NonNull Number handle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        return context.future("net.unsubscribe", new ResultOfSubscribeCollection(handle), Void.class);
    }

    public static CompletableFuture<ResultOfSubscribeCollection> subscribeCollection(@NonNull Context context, @NonNull String collection, Map<String, Object> filter, @NonNull String result, Consumer<SubscribeCollectionEvent> consumer) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return Context.futureCallback("net.subscribe_collection", context, new ParamsOfSubscribeCollection(collection, filter, result), ResultOfSubscribeCollection.class);
    }

    public static CompletableFuture<Void> suspend(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.suspend", null, Void.class);
    }

    public static CompletableFuture<Void> resume(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.resume", null, Void.class);
    }

    public static CompletableFuture<ResultOfFindLastShardBlock> findLastShardBlock(@NonNull Context context, @NonNull String address) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return context.future("net.find_last_shard_block", new ParamsOfFindLastShardBlock(address), ResultOfFindLastShardBlock.class);
    }

    public static CompletableFuture<EndpointsSet> fetchEndpoints(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.fetch_endpoints", null, EndpointsSet.class);
    }

    public static CompletableFuture<Void> setEndpoints(@NonNull Context context, @NonNull String[] endpoints) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (endpoints == null) {
            throw new NullPointerException("endpoints is marked non-null but is null");
        }
        return context.future("net.set_endpoints", new EndpointsSet(endpoints), Void.class);
    }

    public static CompletableFuture<ResultOfGetEndpoints> getEndpoints(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.get_endpoints", null, ResultOfGetEndpoints.class);
    }

    public static CompletableFuture<ResultOfQueryCollection> queryCounterparties(@NonNull Context context, @NonNull String account, @NonNull String result, Number first, String after) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return context.future("net.query_counterparties", new ParamsOfQueryCounterparties(account, result, first, after), ResultOfQueryCollection.class);
    }

    public static CompletableFuture<ResultOfQueryTransactionTree> queryTransactionTree(@NonNull Context context, @NonNull String inMsg, Abi.ABI[] abiRegistry, Number timeout) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (inMsg == null) {
            throw new NullPointerException("inMsg is marked non-null but is null");
        }
        return context.future("net.query_transaction_tree", new ParamsOfQueryTransactionTree(inMsg, abiRegistry, timeout), ResultOfQueryTransactionTree.class);
    }

    public static CompletableFuture<RegisteredIterator> createBlockIterator(@NonNull Context context, Number startTime, Number endTime, String[] shardFilter, String result) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.create_block_iterator", new ParamsOfCreateBlockIterator(startTime, endTime, shardFilter, result), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> resumeBlockIterator(@NonNull Context context, @NonNull Map<String, Object> resumeState) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (resumeState == null) {
            throw new NullPointerException("resumeState is marked non-null but is null");
        }
        return context.future("net.resume_block_iterator", new ParamsOfResumeBlockIterator(resumeState), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> createTransactionIterator(@NonNull Context context, Number startTime, Number endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("net.create_transaction_iterator", new ParamsOfCreateTransactionIterator(startTime, endTime, shardFilter, accountsFilter, result, includeTransfers), RegisteredIterator.class);
    }

    public static CompletableFuture<RegisteredIterator> resumeTransactionIterator(@NonNull Context context, @NonNull Map<String, Object> resumeState, String[] accountsFilter) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (resumeState == null) {
            throw new NullPointerException("resumeState is marked non-null but is null");
        }
        return context.future("net.resume_transaction_iterator", new ParamsOfResumeTransactionIterator(resumeState, accountsFilter), RegisteredIterator.class);
    }

    public static CompletableFuture<ResultOfIteratorNext> iteratorNext(@NonNull Context context, @NonNull Number iterator, Number limit, Boolean returnResumeState) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        return context.future("net.iterator_next", new ParamsOfIteratorNext(iterator, limit, returnResumeState), ResultOfIteratorNext.class);
    }

    public static CompletableFuture<Void> removeIterator(@NonNull Context context, @NonNull Number handle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        return context.future("net.remove_iterator", new RegisteredIterator(handle), Void.class);
    }

    public static final class ParamsOfQuery
    extends JsonData {
        @SerializedName(value="query")
        @NonNull
        private final String query;
        @SerializedName(value="variables")
        private final Map<String, Object> variables;

        public Optional<Map<String, Object>> variables() {
            return Optional.ofNullable(this.variables);
        }

        @Generated
        public ParamsOfQuery(@NonNull String query, Map<String, Object> variables) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            this.variables = variables;
        }

        @NonNull
        @Generated
        public String query() {
            return this.query;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfQuery)) {
                return false;
            }
            ParamsOfQuery other = (ParamsOfQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$query = this.query();
            String other$query = other.query();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Optional<Map<String, Object>> this$variables = this.variables();
            Optional<Map<String, Object>> other$variables = other.variables();
            return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $query = this.query();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Optional<Map<String, Object>> $variables = this.variables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfQuery(query=" + this.query() + ", variables=" + this.variables() + ")";
        }
    }

    public static final class ResultOfQuery
    extends JsonData {
        @SerializedName(value="result")
        @NonNull
        private final Map<String, Object> result;

        @Generated
        public ResultOfQuery(@NonNull Map<String, Object> result) {
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.result = result;
        }

        @NonNull
        @Generated
        public Map<String, Object> result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfQuery)) {
                return false;
            }
            ResultOfQuery other = (ResultOfQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$result = this.result();
            Map<String, Object> other$result = other.result();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $result = this.result();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfQuery(result=" + this.result() + ")";
        }
    }

    public static final class ParamsOfBatchQuery
    extends JsonData {
        @SerializedName(value="operations")
        @NonNull
        private final ParamsOfQueryOperation[] operations;

        @Generated
        public ParamsOfBatchQuery(@NonNull ParamsOfQueryOperation[] operations) {
            if (operations == null) {
                throw new NullPointerException("operations is marked non-null but is null");
            }
            this.operations = operations;
        }

        @NonNull
        @Generated
        public ParamsOfQueryOperation[] operations() {
            return this.operations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfBatchQuery)) {
                return false;
            }
            ParamsOfBatchQuery other = (ParamsOfBatchQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return Arrays.deepEquals(this.operations(), other.operations());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfBatchQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.operations());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfBatchQuery(operations=" + Arrays.deepToString(this.operations()) + ")";
        }
    }

    public static abstract class ParamsOfQueryOperation {

        public static final class QueryCounterparties
        extends ParamsOfQueryOperation {
            @SerializedName(value="account")
            @NonNull
            private final String account;
            @SerializedName(value="result")
            @NonNull
            private final String result;
            @SerializedName(value="first")
            private final Number first;
            @SerializedName(value="after")
            private final String after;

            public Optional<Number> first() {
                return Optional.ofNullable(this.first);
            }

            public Optional<String> after() {
                return Optional.ofNullable(this.after);
            }

            @Generated
            public QueryCounterparties(@NonNull String account, @NonNull String result, Number first, String after) {
                if (account == null) {
                    throw new NullPointerException("account is marked non-null but is null");
                }
                if (result == null) {
                    throw new NullPointerException("result is marked non-null but is null");
                }
                this.account = account;
                this.result = result;
                this.first = first;
                this.after = after;
            }

            @NonNull
            @Generated
            public String account() {
                return this.account;
            }

            @NonNull
            @Generated
            public String result() {
                return this.result;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof QueryCounterparties)) {
                    return false;
                }
                QueryCounterparties other = (QueryCounterparties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$account = this.account();
                String other$account = other.account();
                if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                    return false;
                }
                String this$result = this.result();
                String other$result = other.result();
                if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                    return false;
                }
                Optional<Number> this$first = this.first();
                Optional<Number> other$first = other.first();
                if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
                    return false;
                }
                Optional<String> this$after = this.after();
                Optional<String> other$after = other.after();
                return !(this$after == null ? other$after != null : !((Object)this$after).equals(other$after));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof QueryCounterparties;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $account = this.account();
                result = result * 59 + ($account == null ? 43 : $account.hashCode());
                String $result = this.result();
                result = result * 59 + ($result == null ? 43 : $result.hashCode());
                Optional<Number> $first = this.first();
                result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
                Optional<String> $after = this.after();
                result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Net.ParamsOfQueryOperation.QueryCounterparties(account=" + this.account() + ", result=" + this.result() + ", first=" + this.first() + ", after=" + this.after() + ")";
            }
        }

        public static final class AggregateCollection
        extends ParamsOfQueryOperation {
            @SerializedName(value="collection")
            @NonNull
            private final String collection;
            @SerializedName(value="filter")
            private final Map<String, Object> filter;
            @SerializedName(value="fields")
            private final FieldAggregation[] fields;

            public Optional<Map<String, Object>> filter() {
                return Optional.ofNullable(this.filter);
            }

            public Optional<FieldAggregation[]> fields() {
                return Optional.ofNullable(this.fields);
            }

            @Generated
            public AggregateCollection(@NonNull String collection, Map<String, Object> filter, FieldAggregation[] fields) {
                if (collection == null) {
                    throw new NullPointerException("collection is marked non-null but is null");
                }
                this.collection = collection;
                this.filter = filter;
                this.fields = fields;
            }

            @NonNull
            @Generated
            public String collection() {
                return this.collection;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AggregateCollection)) {
                    return false;
                }
                AggregateCollection other = (AggregateCollection)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$collection = this.collection();
                String other$collection = other.collection();
                if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                    return false;
                }
                Optional<Map<String, Object>> this$filter = this.filter();
                Optional<Map<String, Object>> other$filter = other.filter();
                if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                    return false;
                }
                Optional<FieldAggregation[]> this$fields = this.fields();
                Optional<FieldAggregation[]> other$fields = other.fields();
                return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AggregateCollection;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $collection = this.collection();
                result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
                Optional<Map<String, Object>> $filter = this.filter();
                result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
                Optional<FieldAggregation[]> $fields = this.fields();
                result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Net.ParamsOfQueryOperation.AggregateCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", fields=" + this.fields() + ")";
            }
        }

        public static final class WaitForCollection
        extends ParamsOfQueryOperation {
            @SerializedName(value="collection")
            @NonNull
            private final String collection;
            @SerializedName(value="filter")
            private final Map<String, Object> filter;
            @SerializedName(value="result")
            @NonNull
            private final String result;
            @SerializedName(value="timeout")
            private final Number timeout;

            public Optional<Map<String, Object>> filter() {
                return Optional.ofNullable(this.filter);
            }

            public Optional<Number> timeout() {
                return Optional.ofNullable(this.timeout);
            }

            @Generated
            public WaitForCollection(@NonNull String collection, Map<String, Object> filter, @NonNull String result, Number timeout) {
                if (collection == null) {
                    throw new NullPointerException("collection is marked non-null but is null");
                }
                if (result == null) {
                    throw new NullPointerException("result is marked non-null but is null");
                }
                this.collection = collection;
                this.filter = filter;
                this.result = result;
                this.timeout = timeout;
            }

            @NonNull
            @Generated
            public String collection() {
                return this.collection;
            }

            @NonNull
            @Generated
            public String result() {
                return this.result;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WaitForCollection)) {
                    return false;
                }
                WaitForCollection other = (WaitForCollection)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$collection = this.collection();
                String other$collection = other.collection();
                if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                    return false;
                }
                Optional<Map<String, Object>> this$filter = this.filter();
                Optional<Map<String, Object>> other$filter = other.filter();
                if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                    return false;
                }
                String this$result = this.result();
                String other$result = other.result();
                if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                    return false;
                }
                Optional<Number> this$timeout = this.timeout();
                Optional<Number> other$timeout = other.timeout();
                return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WaitForCollection;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $collection = this.collection();
                result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
                Optional<Map<String, Object>> $filter = this.filter();
                result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
                String $result = this.result();
                result = result * 59 + ($result == null ? 43 : $result.hashCode());
                Optional<Number> $timeout = this.timeout();
                result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Net.ParamsOfQueryOperation.WaitForCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", result=" + this.result() + ", timeout=" + this.timeout() + ")";
            }
        }

        public static final class QueryCollection
        extends ParamsOfQueryOperation {
            @SerializedName(value="collection")
            @NonNull
            private final String collection;
            @SerializedName(value="filter")
            private final Map<String, Object> filter;
            @SerializedName(value="result")
            @NonNull
            private final String result;
            @SerializedName(value="order")
            private final OrderBy[] order;
            @SerializedName(value="limit")
            private final Number limit;

            public Optional<Map<String, Object>> filter() {
                return Optional.ofNullable(this.filter);
            }

            public Optional<OrderBy[]> order() {
                return Optional.ofNullable(this.order);
            }

            public Optional<Number> limit() {
                return Optional.ofNullable(this.limit);
            }

            @Generated
            public QueryCollection(@NonNull String collection, Map<String, Object> filter, @NonNull String result, OrderBy[] order, Number limit) {
                if (collection == null) {
                    throw new NullPointerException("collection is marked non-null but is null");
                }
                if (result == null) {
                    throw new NullPointerException("result is marked non-null but is null");
                }
                this.collection = collection;
                this.filter = filter;
                this.result = result;
                this.order = order;
                this.limit = limit;
            }

            @NonNull
            @Generated
            public String collection() {
                return this.collection;
            }

            @NonNull
            @Generated
            public String result() {
                return this.result;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof QueryCollection)) {
                    return false;
                }
                QueryCollection other = (QueryCollection)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$collection = this.collection();
                String other$collection = other.collection();
                if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                    return false;
                }
                Optional<Map<String, Object>> this$filter = this.filter();
                Optional<Map<String, Object>> other$filter = other.filter();
                if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                    return false;
                }
                String this$result = this.result();
                String other$result = other.result();
                if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                    return false;
                }
                Optional<OrderBy[]> this$order = this.order();
                Optional<OrderBy[]> other$order = other.order();
                if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                    return false;
                }
                Optional<Number> this$limit = this.limit();
                Optional<Number> other$limit = other.limit();
                return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof QueryCollection;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $collection = this.collection();
                result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
                Optional<Map<String, Object>> $filter = this.filter();
                result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
                String $result = this.result();
                result = result * 59 + ($result == null ? 43 : $result.hashCode());
                Optional<OrderBy[]> $order = this.order();
                result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
                Optional<Number> $limit = this.limit();
                result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Net.ParamsOfQueryOperation.QueryCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", result=" + this.result() + ", order=" + this.order() + ", limit=" + this.limit() + ")";
            }
        }
    }

    public static final class ResultOfBatchQuery
    extends JsonData {
        @SerializedName(value="results")
        @NonNull
        private final Map<String, Object>[] results;

        @Generated
        public ResultOfBatchQuery(@NonNull Map<String, Object>[] results) {
            if (results == null) {
                throw new NullPointerException("results is marked non-null but is null");
            }
            this.results = results;
        }

        @NonNull
        @Generated
        public Map<String, Object>[] results() {
            return this.results;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfBatchQuery)) {
                return false;
            }
            ResultOfBatchQuery other = (ResultOfBatchQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return Arrays.deepEquals(this.results(), other.results());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfBatchQuery;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.results());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfBatchQuery(results=" + Arrays.deepToString(this.results()) + ")";
        }
    }

    public static final class ParamsOfQueryCollection
    extends JsonData {
        @SerializedName(value="collection")
        @NonNull
        private final String collection;
        @SerializedName(value="filter")
        private final Map<String, Object> filter;
        @SerializedName(value="result")
        @NonNull
        private final String result;
        @SerializedName(value="order")
        private final OrderBy[] order;
        @SerializedName(value="limit")
        private final Number limit;

        public Optional<Map<String, Object>> filter() {
            return Optional.ofNullable(this.filter);
        }

        public Optional<OrderBy[]> order() {
            return Optional.ofNullable(this.order);
        }

        public Optional<Number> limit() {
            return Optional.ofNullable(this.limit);
        }

        @Generated
        public ParamsOfQueryCollection(@NonNull String collection, Map<String, Object> filter, @NonNull String result, OrderBy[] order, Number limit) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.collection = collection;
            this.filter = filter;
            this.result = result;
            this.order = order;
            this.limit = limit;
        }

        @NonNull
        @Generated
        public String collection() {
            return this.collection;
        }

        @NonNull
        @Generated
        public String result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfQueryCollection)) {
                return false;
            }
            ParamsOfQueryCollection other = (ParamsOfQueryCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$collection = this.collection();
            String other$collection = other.collection();
            if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                return false;
            }
            Optional<Map<String, Object>> this$filter = this.filter();
            Optional<Map<String, Object>> other$filter = other.filter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            String this$result = this.result();
            String other$result = other.result();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Optional<OrderBy[]> this$order = this.order();
            Optional<OrderBy[]> other$order = other.order();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            Optional<Number> this$limit = this.limit();
            Optional<Number> other$limit = other.limit();
            return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfQueryCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $collection = this.collection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            Optional<Map<String, Object>> $filter = this.filter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            String $result = this.result();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Optional<OrderBy[]> $order = this.order();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            Optional<Number> $limit = this.limit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfQueryCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", result=" + this.result() + ", order=" + this.order() + ", limit=" + this.limit() + ")";
        }
    }

    public static final class OrderBy
    extends JsonData {
        @SerializedName(value="path")
        @NonNull
        private final String path;
        @SerializedName(value="direction")
        @NonNull
        private final SortDirection direction;

        @Generated
        public OrderBy(@NonNull String path, @NonNull SortDirection direction) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            this.path = path;
            this.direction = direction;
        }

        @NonNull
        @Generated
        public String path() {
            return this.path;
        }

        @NonNull
        @Generated
        public SortDirection direction() {
            return this.direction;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderBy)) {
                return false;
            }
            OrderBy other = (OrderBy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$path = this.path();
            String other$path = other.path();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            SortDirection this$direction = this.direction();
            SortDirection other$direction = other.direction();
            return !(this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OrderBy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $path = this.path();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            SortDirection $direction = this.direction();
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.OrderBy(path=" + this.path() + ", direction=" + this.direction() + ")";
        }
    }

    public static final class ResultOfQueryCollection
    extends JsonData {
        @SerializedName(value="result")
        @NonNull
        private final Map<String, Object>[] result;

        @Generated
        public ResultOfQueryCollection(@NonNull Map<String, Object>[] result) {
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.result = result;
        }

        @NonNull
        @Generated
        public Map<String, Object>[] result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfQueryCollection)) {
                return false;
            }
            ResultOfQueryCollection other = (ResultOfQueryCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return Arrays.deepEquals(this.result(), other.result());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfQueryCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.result());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfQueryCollection(result=" + Arrays.deepToString(this.result()) + ")";
        }
    }

    public static final class ParamsOfAggregateCollection
    extends JsonData {
        @SerializedName(value="collection")
        @NonNull
        private final String collection;
        @SerializedName(value="filter")
        private final Map<String, Object> filter;
        @SerializedName(value="fields")
        private final FieldAggregation[] fields;

        public Optional<Map<String, Object>> filter() {
            return Optional.ofNullable(this.filter);
        }

        public Optional<FieldAggregation[]> fields() {
            return Optional.ofNullable(this.fields);
        }

        @Generated
        public ParamsOfAggregateCollection(@NonNull String collection, Map<String, Object> filter, FieldAggregation[] fields) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            this.collection = collection;
            this.filter = filter;
            this.fields = fields;
        }

        @NonNull
        @Generated
        public String collection() {
            return this.collection;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfAggregateCollection)) {
                return false;
            }
            ParamsOfAggregateCollection other = (ParamsOfAggregateCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$collection = this.collection();
            String other$collection = other.collection();
            if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                return false;
            }
            Optional<Map<String, Object>> this$filter = this.filter();
            Optional<Map<String, Object>> other$filter = other.filter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            Optional<FieldAggregation[]> this$fields = this.fields();
            Optional<FieldAggregation[]> other$fields = other.fields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfAggregateCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $collection = this.collection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            Optional<Map<String, Object>> $filter = this.filter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            Optional<FieldAggregation[]> $fields = this.fields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfAggregateCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", fields=" + this.fields() + ")";
        }
    }

    public static final class FieldAggregation
    extends JsonData {
        @SerializedName(value="field")
        @NonNull
        private final String field;
        @SerializedName(value="fn")
        @NonNull
        private final AggregationFn fn;

        @Generated
        public FieldAggregation(@NonNull String field, @NonNull AggregationFn fn) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            if (fn == null) {
                throw new NullPointerException("fn is marked non-null but is null");
            }
            this.field = field;
            this.fn = fn;
        }

        @NonNull
        @Generated
        public String field() {
            return this.field;
        }

        @NonNull
        @Generated
        public AggregationFn fn() {
            return this.fn;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAggregation)) {
                return false;
            }
            FieldAggregation other = (FieldAggregation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$field = this.field();
            String other$field = other.field();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            AggregationFn this$fn = this.fn();
            AggregationFn other$fn = other.fn();
            return !(this$fn == null ? other$fn != null : !((Object)((Object)this$fn)).equals((Object)other$fn));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FieldAggregation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $field = this.field();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            AggregationFn $fn = this.fn();
            result = result * 59 + ($fn == null ? 43 : ((Object)((Object)$fn)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.FieldAggregation(field=" + this.field() + ", fn=" + this.fn() + ")";
        }
    }

    public static final class ResultOfAggregateCollection
    extends JsonData {
        @SerializedName(value="values")
        @NonNull
        private final Map<String, Object> values;

        @Generated
        public ResultOfAggregateCollection(@NonNull Map<String, Object> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            this.values = values;
        }

        @NonNull
        @Generated
        public Map<String, Object> values() {
            return this.values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfAggregateCollection)) {
                return false;
            }
            ResultOfAggregateCollection other = (ResultOfAggregateCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$values = this.values();
            Map<String, Object> other$values = other.values();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfAggregateCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $values = this.values();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfAggregateCollection(values=" + this.values() + ")";
        }
    }

    public static final class ParamsOfWaitForCollection
    extends JsonData {
        @SerializedName(value="collection")
        @NonNull
        private final String collection;
        @SerializedName(value="filter")
        private final Map<String, Object> filter;
        @SerializedName(value="result")
        @NonNull
        private final String result;
        @SerializedName(value="timeout")
        private final Number timeout;

        public Optional<Map<String, Object>> filter() {
            return Optional.ofNullable(this.filter);
        }

        public Optional<Number> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        @Generated
        public ParamsOfWaitForCollection(@NonNull String collection, Map<String, Object> filter, @NonNull String result, Number timeout) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.collection = collection;
            this.filter = filter;
            this.result = result;
            this.timeout = timeout;
        }

        @NonNull
        @Generated
        public String collection() {
            return this.collection;
        }

        @NonNull
        @Generated
        public String result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfWaitForCollection)) {
                return false;
            }
            ParamsOfWaitForCollection other = (ParamsOfWaitForCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$collection = this.collection();
            String other$collection = other.collection();
            if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                return false;
            }
            Optional<Map<String, Object>> this$filter = this.filter();
            Optional<Map<String, Object>> other$filter = other.filter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            String this$result = this.result();
            String other$result = other.result();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Optional<Number> this$timeout = this.timeout();
            Optional<Number> other$timeout = other.timeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfWaitForCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $collection = this.collection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            Optional<Map<String, Object>> $filter = this.filter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            String $result = this.result();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Optional<Number> $timeout = this.timeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfWaitForCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", result=" + this.result() + ", timeout=" + this.timeout() + ")";
        }
    }

    public static final class ResultOfWaitForCollection
    extends JsonData {
        @SerializedName(value="result")
        @NonNull
        private final Map<String, Object> result;

        @Generated
        public ResultOfWaitForCollection(@NonNull Map<String, Object> result) {
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.result = result;
        }

        @NonNull
        @Generated
        public Map<String, Object> result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfWaitForCollection)) {
                return false;
            }
            ResultOfWaitForCollection other = (ResultOfWaitForCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$result = this.result();
            Map<String, Object> other$result = other.result();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfWaitForCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $result = this.result();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfWaitForCollection(result=" + this.result() + ")";
        }
    }

    public static final class ResultOfSubscribeCollection
    extends JsonData {
        @SerializedName(value="handle")
        @NonNull
        private final Number handle;

        @Generated
        public ResultOfSubscribeCollection(@NonNull Number handle) {
            if (handle == null) {
                throw new NullPointerException("handle is marked non-null but is null");
            }
            this.handle = handle;
        }

        @NonNull
        @Generated
        public Number handle() {
            return this.handle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfSubscribeCollection)) {
                return false;
            }
            ResultOfSubscribeCollection other = (ResultOfSubscribeCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Number this$handle = this.handle();
            Number other$handle = other.handle();
            return !(this$handle == null ? other$handle != null : !this$handle.equals(other$handle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfSubscribeCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Number $handle = this.handle();
            result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfSubscribeCollection(handle=" + this.handle() + ")";
        }
    }

    public static final class ParamsOfSubscribeCollection
    extends JsonData {
        @SerializedName(value="collection")
        @NonNull
        private final String collection;
        @SerializedName(value="filter")
        private final Map<String, Object> filter;
        @SerializedName(value="result")
        @NonNull
        private final String result;

        public Optional<Map<String, Object>> filter() {
            return Optional.ofNullable(this.filter);
        }

        @Generated
        public ParamsOfSubscribeCollection(@NonNull String collection, Map<String, Object> filter, @NonNull String result) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.collection = collection;
            this.filter = filter;
            this.result = result;
        }

        @NonNull
        @Generated
        public String collection() {
            return this.collection;
        }

        @NonNull
        @Generated
        public String result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfSubscribeCollection)) {
                return false;
            }
            ParamsOfSubscribeCollection other = (ParamsOfSubscribeCollection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$collection = this.collection();
            String other$collection = other.collection();
            if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
                return false;
            }
            Optional<Map<String, Object>> this$filter = this.filter();
            Optional<Map<String, Object>> other$filter = other.filter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            String this$result = this.result();
            String other$result = other.result();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfSubscribeCollection;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $collection = this.collection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            Optional<Map<String, Object>> $filter = this.filter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            String $result = this.result();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfSubscribeCollection(collection=" + this.collection() + ", filter=" + this.filter() + ", result=" + this.result() + ")";
        }
    }

    public static final class ParamsOfFindLastShardBlock
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;

        @Generated
        public ParamsOfFindLastShardBlock(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfFindLastShardBlock)) {
                return false;
            }
            ParamsOfFindLastShardBlock other = (ParamsOfFindLastShardBlock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfFindLastShardBlock;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfFindLastShardBlock(address=" + this.address() + ")";
        }
    }

    public static final class ResultOfFindLastShardBlock
    extends JsonData {
        @SerializedName(value="block_id")
        @NonNull
        private final String blockId;

        @Generated
        public ResultOfFindLastShardBlock(@NonNull String blockId) {
            if (blockId == null) {
                throw new NullPointerException("blockId is marked non-null but is null");
            }
            this.blockId = blockId;
        }

        @NonNull
        @Generated
        public String blockId() {
            return this.blockId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfFindLastShardBlock)) {
                return false;
            }
            ResultOfFindLastShardBlock other = (ResultOfFindLastShardBlock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$blockId = this.blockId();
            String other$blockId = other.blockId();
            return !(this$blockId == null ? other$blockId != null : !this$blockId.equals(other$blockId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfFindLastShardBlock;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $blockId = this.blockId();
            result = result * 59 + ($blockId == null ? 43 : $blockId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfFindLastShardBlock(blockId=" + this.blockId() + ")";
        }
    }

    public static final class EndpointsSet
    extends JsonData {
        @SerializedName(value="endpoints")
        @NonNull
        private final String[] endpoints;

        @Generated
        public EndpointsSet(@NonNull String[] endpoints) {
            if (endpoints == null) {
                throw new NullPointerException("endpoints is marked non-null but is null");
            }
            this.endpoints = endpoints;
        }

        @NonNull
        @Generated
        public String[] endpoints() {
            return this.endpoints;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndpointsSet)) {
                return false;
            }
            EndpointsSet other = (EndpointsSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return Arrays.deepEquals(this.endpoints(), other.endpoints());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EndpointsSet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.endpoints());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.EndpointsSet(endpoints=" + Arrays.deepToString(this.endpoints()) + ")";
        }
    }

    public static final class ResultOfGetEndpoints
    extends JsonData {
        @SerializedName(value="query")
        @NonNull
        private final String query;
        @SerializedName(value="endpoints")
        @NonNull
        private final String[] endpoints;

        @Generated
        public ResultOfGetEndpoints(@NonNull String query, @NonNull String[] endpoints) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            if (endpoints == null) {
                throw new NullPointerException("endpoints is marked non-null but is null");
            }
            this.query = query;
            this.endpoints = endpoints;
        }

        @NonNull
        @Generated
        public String query() {
            return this.query;
        }

        @NonNull
        @Generated
        public String[] endpoints() {
            return this.endpoints;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfGetEndpoints)) {
                return false;
            }
            ResultOfGetEndpoints other = (ResultOfGetEndpoints)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$query = this.query();
            String other$query = other.query();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            return Arrays.deepEquals(this.endpoints(), other.endpoints());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfGetEndpoints;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $query = this.query();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.endpoints());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfGetEndpoints(query=" + this.query() + ", endpoints=" + Arrays.deepToString(this.endpoints()) + ")";
        }
    }

    public static final class ParamsOfQueryCounterparties
    extends JsonData {
        @SerializedName(value="account")
        @NonNull
        private final String account;
        @SerializedName(value="result")
        @NonNull
        private final String result;
        @SerializedName(value="first")
        private final Number first;
        @SerializedName(value="after")
        private final String after;

        public Optional<Number> first() {
            return Optional.ofNullable(this.first);
        }

        public Optional<String> after() {
            return Optional.ofNullable(this.after);
        }

        @Generated
        public ParamsOfQueryCounterparties(@NonNull String account, @NonNull String result, Number first, String after) {
            if (account == null) {
                throw new NullPointerException("account is marked non-null but is null");
            }
            if (result == null) {
                throw new NullPointerException("result is marked non-null but is null");
            }
            this.account = account;
            this.result = result;
            this.first = first;
            this.after = after;
        }

        @NonNull
        @Generated
        public String account() {
            return this.account;
        }

        @NonNull
        @Generated
        public String result() {
            return this.result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfQueryCounterparties)) {
                return false;
            }
            ParamsOfQueryCounterparties other = (ParamsOfQueryCounterparties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$account = this.account();
            String other$account = other.account();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$result = this.result();
            String other$result = other.result();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Optional<Number> this$first = this.first();
            Optional<Number> other$first = other.first();
            if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
                return false;
            }
            Optional<String> this$after = this.after();
            Optional<String> other$after = other.after();
            return !(this$after == null ? other$after != null : !((Object)this$after).equals(other$after));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfQueryCounterparties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $account = this.account();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $result = this.result();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Optional<Number> $first = this.first();
            result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
            Optional<String> $after = this.after();
            result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfQueryCounterparties(account=" + this.account() + ", result=" + this.result() + ", first=" + this.first() + ", after=" + this.after() + ")";
        }
    }

    public static final class ParamsOfQueryTransactionTree
    extends JsonData {
        @SerializedName(value="in_msg")
        @NonNull
        private final String inMsg;
        @SerializedName(value="abi_registry")
        private final Abi.ABI[] abiRegistry;
        @SerializedName(value="timeout")
        private final Number timeout;

        public Optional<Abi.ABI[]> abiRegistry() {
            return Optional.ofNullable(this.abiRegistry);
        }

        public Optional<Number> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        @Generated
        public ParamsOfQueryTransactionTree(@NonNull String inMsg, Abi.ABI[] abiRegistry, Number timeout) {
            if (inMsg == null) {
                throw new NullPointerException("inMsg is marked non-null but is null");
            }
            this.inMsg = inMsg;
            this.abiRegistry = abiRegistry;
            this.timeout = timeout;
        }

        @NonNull
        @Generated
        public String inMsg() {
            return this.inMsg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfQueryTransactionTree)) {
                return false;
            }
            ParamsOfQueryTransactionTree other = (ParamsOfQueryTransactionTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$inMsg = this.inMsg();
            String other$inMsg = other.inMsg();
            if (this$inMsg == null ? other$inMsg != null : !this$inMsg.equals(other$inMsg)) {
                return false;
            }
            Optional<Abi.ABI[]> this$abiRegistry = this.abiRegistry();
            Optional<Abi.ABI[]> other$abiRegistry = other.abiRegistry();
            if (this$abiRegistry == null ? other$abiRegistry != null : !((Object)this$abiRegistry).equals(other$abiRegistry)) {
                return false;
            }
            Optional<Number> this$timeout = this.timeout();
            Optional<Number> other$timeout = other.timeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfQueryTransactionTree;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $inMsg = this.inMsg();
            result = result * 59 + ($inMsg == null ? 43 : $inMsg.hashCode());
            Optional<Abi.ABI[]> $abiRegistry = this.abiRegistry();
            result = result * 59 + ($abiRegistry == null ? 43 : ((Object)$abiRegistry).hashCode());
            Optional<Number> $timeout = this.timeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfQueryTransactionTree(inMsg=" + this.inMsg() + ", abiRegistry=" + this.abiRegistry() + ", timeout=" + this.timeout() + ")";
        }
    }

    public static final class ResultOfQueryTransactionTree
    extends JsonData {
        @SerializedName(value="messages")
        @NonNull
        private final MessageNode[] messages;
        @SerializedName(value="transactions")
        @NonNull
        private final TransactionNode[] transactions;

        @Generated
        public ResultOfQueryTransactionTree(@NonNull MessageNode[] messages, @NonNull TransactionNode[] transactions) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            if (transactions == null) {
                throw new NullPointerException("transactions is marked non-null but is null");
            }
            this.messages = messages;
            this.transactions = transactions;
        }

        @NonNull
        @Generated
        public MessageNode[] messages() {
            return this.messages;
        }

        @NonNull
        @Generated
        public TransactionNode[] transactions() {
            return this.transactions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfQueryTransactionTree)) {
                return false;
            }
            ResultOfQueryTransactionTree other = (ResultOfQueryTransactionTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (!Arrays.deepEquals(this.messages(), other.messages())) {
                return false;
            }
            return Arrays.deepEquals(this.transactions(), other.transactions());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfQueryTransactionTree;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.messages());
            result = result * 59 + Arrays.deepHashCode(this.transactions());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfQueryTransactionTree(messages=" + Arrays.deepToString(this.messages()) + ", transactions=" + Arrays.deepToString(this.transactions()) + ")";
        }
    }

    public static final class ParamsOfCreateBlockIterator
    extends JsonData {
        @SerializedName(value="start_time")
        private final Number startTime;
        @SerializedName(value="end_time")
        private final Number endTime;
        @SerializedName(value="shard_filter")
        private final String[] shardFilter;
        @SerializedName(value="result")
        private final String result;

        public Optional<Number> startTime() {
            return Optional.ofNullable(this.startTime);
        }

        public Optional<Number> endTime() {
            return Optional.ofNullable(this.endTime);
        }

        public Optional<String[]> shardFilter() {
            return Optional.ofNullable(this.shardFilter);
        }

        public Optional<String> result() {
            return Optional.ofNullable(this.result);
        }

        @Generated
        public ParamsOfCreateBlockIterator(Number startTime, Number endTime, String[] shardFilter, String result) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.shardFilter = shardFilter;
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfCreateBlockIterator)) {
                return false;
            }
            ParamsOfCreateBlockIterator other = (ParamsOfCreateBlockIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Number> this$startTime = this.startTime();
            Optional<Number> other$startTime = other.startTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Optional<Number> this$endTime = this.endTime();
            Optional<Number> other$endTime = other.endTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            Optional<String[]> this$shardFilter = this.shardFilter();
            Optional<String[]> other$shardFilter = other.shardFilter();
            if (this$shardFilter == null ? other$shardFilter != null : !((Object)this$shardFilter).equals(other$shardFilter)) {
                return false;
            }
            Optional<String> this$result = this.result();
            Optional<String> other$result = other.result();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfCreateBlockIterator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Number> $startTime = this.startTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Optional<Number> $endTime = this.endTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            Optional<String[]> $shardFilter = this.shardFilter();
            result = result * 59 + ($shardFilter == null ? 43 : ((Object)$shardFilter).hashCode());
            Optional<String> $result = this.result();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfCreateBlockIterator(startTime=" + this.startTime() + ", endTime=" + this.endTime() + ", shardFilter=" + this.shardFilter() + ", result=" + this.result() + ")";
        }
    }

    public static final class RegisteredIterator
    extends JsonData {
        @SerializedName(value="handle")
        @NonNull
        private final Number handle;

        @Generated
        public RegisteredIterator(@NonNull Number handle) {
            if (handle == null) {
                throw new NullPointerException("handle is marked non-null but is null");
            }
            this.handle = handle;
        }

        @NonNull
        @Generated
        public Number handle() {
            return this.handle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredIterator)) {
                return false;
            }
            RegisteredIterator other = (RegisteredIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Number this$handle = this.handle();
            Number other$handle = other.handle();
            return !(this$handle == null ? other$handle != null : !this$handle.equals(other$handle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RegisteredIterator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Number $handle = this.handle();
            result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.RegisteredIterator(handle=" + this.handle() + ")";
        }
    }

    public static final class ParamsOfResumeBlockIterator
    extends JsonData {
        @SerializedName(value="resume_state")
        @NonNull
        private final Map<String, Object> resumeState;

        @Generated
        public ParamsOfResumeBlockIterator(@NonNull Map<String, Object> resumeState) {
            if (resumeState == null) {
                throw new NullPointerException("resumeState is marked non-null but is null");
            }
            this.resumeState = resumeState;
        }

        @NonNull
        @Generated
        public Map<String, Object> resumeState() {
            return this.resumeState;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfResumeBlockIterator)) {
                return false;
            }
            ParamsOfResumeBlockIterator other = (ParamsOfResumeBlockIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$resumeState = this.resumeState();
            Map<String, Object> other$resumeState = other.resumeState();
            return !(this$resumeState == null ? other$resumeState != null : !((Object)this$resumeState).equals(other$resumeState));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfResumeBlockIterator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $resumeState = this.resumeState();
            result = result * 59 + ($resumeState == null ? 43 : ((Object)$resumeState).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfResumeBlockIterator(resumeState=" + this.resumeState() + ")";
        }
    }

    public static final class ParamsOfCreateTransactionIterator
    extends JsonData {
        @SerializedName(value="start_time")
        private final Number startTime;
        @SerializedName(value="end_time")
        private final Number endTime;
        @SerializedName(value="shard_filter")
        private final String[] shardFilter;
        @SerializedName(value="accounts_filter")
        private final String[] accountsFilter;
        @SerializedName(value="result")
        private final String result;
        @SerializedName(value="include_transfers")
        private final Boolean includeTransfers;

        public Optional<Number> startTime() {
            return Optional.ofNullable(this.startTime);
        }

        public Optional<Number> endTime() {
            return Optional.ofNullable(this.endTime);
        }

        public Optional<String[]> shardFilter() {
            return Optional.ofNullable(this.shardFilter);
        }

        public Optional<String[]> accountsFilter() {
            return Optional.ofNullable(this.accountsFilter);
        }

        public Optional<String> result() {
            return Optional.ofNullable(this.result);
        }

        public Optional<Boolean> includeTransfers() {
            return Optional.ofNullable(this.includeTransfers);
        }

        @Generated
        public ParamsOfCreateTransactionIterator(Number startTime, Number endTime, String[] shardFilter, String[] accountsFilter, String result, Boolean includeTransfers) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.shardFilter = shardFilter;
            this.accountsFilter = accountsFilter;
            this.result = result;
            this.includeTransfers = includeTransfers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfCreateTransactionIterator)) {
                return false;
            }
            ParamsOfCreateTransactionIterator other = (ParamsOfCreateTransactionIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Boolean> this$includeTransfers = this.includeTransfers();
            Optional<Boolean> other$includeTransfers = other.includeTransfers();
            if (this$includeTransfers == null ? other$includeTransfers != null : !((Object)this$includeTransfers).equals(other$includeTransfers)) {
                return false;
            }
            Optional<Number> this$startTime = this.startTime();
            Optional<Number> other$startTime = other.startTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Optional<Number> this$endTime = this.endTime();
            Optional<Number> other$endTime = other.endTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            Optional<String[]> this$shardFilter = this.shardFilter();
            Optional<String[]> other$shardFilter = other.shardFilter();
            if (this$shardFilter == null ? other$shardFilter != null : !((Object)this$shardFilter).equals(other$shardFilter)) {
                return false;
            }
            Optional<String[]> this$accountsFilter = this.accountsFilter();
            Optional<String[]> other$accountsFilter = other.accountsFilter();
            if (this$accountsFilter == null ? other$accountsFilter != null : !((Object)this$accountsFilter).equals(other$accountsFilter)) {
                return false;
            }
            Optional<String> this$result = this.result();
            Optional<String> other$result = other.result();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfCreateTransactionIterator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Boolean> $includeTransfers = this.includeTransfers();
            result = result * 59 + ($includeTransfers == null ? 43 : ((Object)$includeTransfers).hashCode());
            Optional<Number> $startTime = this.startTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Optional<Number> $endTime = this.endTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            Optional<String[]> $shardFilter = this.shardFilter();
            result = result * 59 + ($shardFilter == null ? 43 : ((Object)$shardFilter).hashCode());
            Optional<String[]> $accountsFilter = this.accountsFilter();
            result = result * 59 + ($accountsFilter == null ? 43 : ((Object)$accountsFilter).hashCode());
            Optional<String> $result = this.result();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfCreateTransactionIterator(startTime=" + this.startTime() + ", endTime=" + this.endTime() + ", shardFilter=" + this.shardFilter() + ", accountsFilter=" + this.accountsFilter() + ", result=" + this.result() + ", includeTransfers=" + this.includeTransfers() + ")";
        }
    }

    public static final class ParamsOfResumeTransactionIterator
    extends JsonData {
        @SerializedName(value="resume_state")
        @NonNull
        private final Map<String, Object> resumeState;
        @SerializedName(value="accounts_filter")
        private final String[] accountsFilter;

        public Optional<String[]> accountsFilter() {
            return Optional.ofNullable(this.accountsFilter);
        }

        @Generated
        public ParamsOfResumeTransactionIterator(@NonNull Map<String, Object> resumeState, String[] accountsFilter) {
            if (resumeState == null) {
                throw new NullPointerException("resumeState is marked non-null but is null");
            }
            this.resumeState = resumeState;
            this.accountsFilter = accountsFilter;
        }

        @NonNull
        @Generated
        public Map<String, Object> resumeState() {
            return this.resumeState;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfResumeTransactionIterator)) {
                return false;
            }
            ParamsOfResumeTransactionIterator other = (ParamsOfResumeTransactionIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$resumeState = this.resumeState();
            Map<String, Object> other$resumeState = other.resumeState();
            if (this$resumeState == null ? other$resumeState != null : !((Object)this$resumeState).equals(other$resumeState)) {
                return false;
            }
            Optional<String[]> this$accountsFilter = this.accountsFilter();
            Optional<String[]> other$accountsFilter = other.accountsFilter();
            return !(this$accountsFilter == null ? other$accountsFilter != null : !((Object)this$accountsFilter).equals(other$accountsFilter));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfResumeTransactionIterator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $resumeState = this.resumeState();
            result = result * 59 + ($resumeState == null ? 43 : ((Object)$resumeState).hashCode());
            Optional<String[]> $accountsFilter = this.accountsFilter();
            result = result * 59 + ($accountsFilter == null ? 43 : ((Object)$accountsFilter).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfResumeTransactionIterator(resumeState=" + this.resumeState() + ", accountsFilter=" + this.accountsFilter() + ")";
        }
    }

    public static final class ParamsOfIteratorNext
    extends JsonData {
        @SerializedName(value="iterator")
        @NonNull
        private final Number iterator;
        @SerializedName(value="limit")
        private final Number limit;
        @SerializedName(value="return_resume_state")
        private final Boolean returnResumeState;

        public Optional<Number> limit() {
            return Optional.ofNullable(this.limit);
        }

        public Optional<Boolean> returnResumeState() {
            return Optional.ofNullable(this.returnResumeState);
        }

        @Generated
        public ParamsOfIteratorNext(@NonNull Number iterator, Number limit, Boolean returnResumeState) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.iterator = iterator;
            this.limit = limit;
            this.returnResumeState = returnResumeState;
        }

        @NonNull
        @Generated
        public Number iterator() {
            return this.iterator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfIteratorNext)) {
                return false;
            }
            ParamsOfIteratorNext other = (ParamsOfIteratorNext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Boolean> this$returnResumeState = this.returnResumeState();
            Optional<Boolean> other$returnResumeState = other.returnResumeState();
            if (this$returnResumeState == null ? other$returnResumeState != null : !((Object)this$returnResumeState).equals(other$returnResumeState)) {
                return false;
            }
            Number this$iterator = this.iterator();
            Number other$iterator = other.iterator();
            if (this$iterator == null ? other$iterator != null : !this$iterator.equals(other$iterator)) {
                return false;
            }
            Optional<Number> this$limit = this.limit();
            Optional<Number> other$limit = other.limit();
            return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfIteratorNext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Boolean> $returnResumeState = this.returnResumeState();
            result = result * 59 + ($returnResumeState == null ? 43 : ((Object)$returnResumeState).hashCode());
            Number $iterator = this.iterator();
            result = result * 59 + ($iterator == null ? 43 : $iterator.hashCode());
            Optional<Number> $limit = this.limit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ParamsOfIteratorNext(iterator=" + this.iterator() + ", limit=" + this.limit() + ", returnResumeState=" + this.returnResumeState() + ")";
        }
    }

    public static final class ResultOfIteratorNext
    extends JsonData {
        @SerializedName(value="items")
        @NonNull
        private final Map<String, Object>[] items;
        @SerializedName(value="has_more")
        @NonNull
        private final Boolean hasMore;
        @SerializedName(value="resume_state")
        private final Map<String, Object> resumeState;

        public Optional<Map<String, Object>> resumeState() {
            return Optional.ofNullable(this.resumeState);
        }

        @Generated
        public ResultOfIteratorNext(@NonNull Map<String, Object>[] items, @NonNull Boolean hasMore, Map<String, Object> resumeState) {
            if (items == null) {
                throw new NullPointerException("items is marked non-null but is null");
            }
            if (hasMore == null) {
                throw new NullPointerException("hasMore is marked non-null but is null");
            }
            this.items = items;
            this.hasMore = hasMore;
            this.resumeState = resumeState;
        }

        @NonNull
        @Generated
        public Map<String, Object>[] items() {
            return this.items;
        }

        @NonNull
        @Generated
        public Boolean hasMore() {
            return this.hasMore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfIteratorNext)) {
                return false;
            }
            ResultOfIteratorNext other = (ResultOfIteratorNext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$hasMore = this.hasMore();
            Boolean other$hasMore = other.hasMore();
            if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
                return false;
            }
            if (!Arrays.deepEquals(this.items(), other.items())) {
                return false;
            }
            Optional<Map<String, Object>> this$resumeState = this.resumeState();
            Optional<Map<String, Object>> other$resumeState = other.resumeState();
            return !(this$resumeState == null ? other$resumeState != null : !((Object)this$resumeState).equals(other$resumeState));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfIteratorNext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $hasMore = this.hasMore();
            result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.items());
            Optional<Map<String, Object>> $resumeState = this.resumeState();
            result = result * 59 + ($resumeState == null ? 43 : ((Object)$resumeState).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.ResultOfIteratorNext(items=" + Arrays.deepToString(this.items()) + ", hasMore=" + this.hasMore() + ", resumeState=" + this.resumeState() + ")";
        }
    }

    public static final class MessageNode
    extends JsonData {
        @SerializedName(value="id")
        @NonNull
        private final String id;
        @SerializedName(value="src_transaction_id")
        private final String srcTransactionId;
        @SerializedName(value="dst_transaction_id")
        private final String dstTransactionId;
        @SerializedName(value="src")
        private final String src;
        @SerializedName(value="dst")
        private final String dst;
        @SerializedName(value="value")
        private final String value;
        @SerializedName(value="bounce")
        @NonNull
        private final Boolean bounce;
        @SerializedName(value="decoded_body")
        private final Abi.DecodedMessageBody decodedBody;

        public Optional<String> srcTransactionId() {
            return Optional.ofNullable(this.srcTransactionId);
        }

        public Optional<String> dstTransactionId() {
            return Optional.ofNullable(this.dstTransactionId);
        }

        public Optional<String> src() {
            return Optional.ofNullable(this.src);
        }

        public Optional<String> dst() {
            return Optional.ofNullable(this.dst);
        }

        public Optional<String> value() {
            return Optional.ofNullable(this.value);
        }

        public Optional<Abi.DecodedMessageBody> decodedBody() {
            return Optional.ofNullable(this.decodedBody);
        }

        @Generated
        public MessageNode(@NonNull String id, String srcTransactionId, String dstTransactionId, String src, String dst, String value, @NonNull Boolean bounce, Abi.DecodedMessageBody decodedBody) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (bounce == null) {
                throw new NullPointerException("bounce is marked non-null but is null");
            }
            this.id = id;
            this.srcTransactionId = srcTransactionId;
            this.dstTransactionId = dstTransactionId;
            this.src = src;
            this.dst = dst;
            this.value = value;
            this.bounce = bounce;
            this.decodedBody = decodedBody;
        }

        @NonNull
        @Generated
        public String id() {
            return this.id;
        }

        @NonNull
        @Generated
        public Boolean bounce() {
            return this.bounce;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageNode)) {
                return false;
            }
            MessageNode other = (MessageNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$bounce = this.bounce();
            Boolean other$bounce = other.bounce();
            if (this$bounce == null ? other$bounce != null : !((Object)this$bounce).equals(other$bounce)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Optional<String> this$srcTransactionId = this.srcTransactionId();
            Optional<String> other$srcTransactionId = other.srcTransactionId();
            if (this$srcTransactionId == null ? other$srcTransactionId != null : !((Object)this$srcTransactionId).equals(other$srcTransactionId)) {
                return false;
            }
            Optional<String> this$dstTransactionId = this.dstTransactionId();
            Optional<String> other$dstTransactionId = other.dstTransactionId();
            if (this$dstTransactionId == null ? other$dstTransactionId != null : !((Object)this$dstTransactionId).equals(other$dstTransactionId)) {
                return false;
            }
            Optional<String> this$src = this.src();
            Optional<String> other$src = other.src();
            if (this$src == null ? other$src != null : !((Object)this$src).equals(other$src)) {
                return false;
            }
            Optional<String> this$dst = this.dst();
            Optional<String> other$dst = other.dst();
            if (this$dst == null ? other$dst != null : !((Object)this$dst).equals(other$dst)) {
                return false;
            }
            Optional<String> this$value = this.value();
            Optional<String> other$value = other.value();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            Optional<Abi.DecodedMessageBody> this$decodedBody = this.decodedBody();
            Optional<Abi.DecodedMessageBody> other$decodedBody = other.decodedBody();
            return !(this$decodedBody == null ? other$decodedBody != null : !((Object)this$decodedBody).equals(other$decodedBody));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MessageNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $bounce = this.bounce();
            result = result * 59 + ($bounce == null ? 43 : ((Object)$bounce).hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Optional<String> $srcTransactionId = this.srcTransactionId();
            result = result * 59 + ($srcTransactionId == null ? 43 : ((Object)$srcTransactionId).hashCode());
            Optional<String> $dstTransactionId = this.dstTransactionId();
            result = result * 59 + ($dstTransactionId == null ? 43 : ((Object)$dstTransactionId).hashCode());
            Optional<String> $src = this.src();
            result = result * 59 + ($src == null ? 43 : ((Object)$src).hashCode());
            Optional<String> $dst = this.dst();
            result = result * 59 + ($dst == null ? 43 : ((Object)$dst).hashCode());
            Optional<String> $value = this.value();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            Optional<Abi.DecodedMessageBody> $decodedBody = this.decodedBody();
            result = result * 59 + ($decodedBody == null ? 43 : ((Object)$decodedBody).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.MessageNode(id=" + this.id() + ", srcTransactionId=" + this.srcTransactionId() + ", dstTransactionId=" + this.dstTransactionId() + ", src=" + this.src() + ", dst=" + this.dst() + ", value=" + this.value() + ", bounce=" + this.bounce() + ", decodedBody=" + this.decodedBody() + ")";
        }
    }

    public static final class TransactionNode
    extends JsonData {
        @SerializedName(value="id")
        @NonNull
        private final String id;
        @SerializedName(value="in_msg")
        @NonNull
        private final String inMsg;
        @SerializedName(value="out_msgs")
        @NonNull
        private final String[] outMsgs;
        @SerializedName(value="account_addr")
        @NonNull
        private final String accountAddr;
        @SerializedName(value="total_fees")
        @NonNull
        private final String totalFees;
        @SerializedName(value="aborted")
        @NonNull
        private final Boolean aborted;
        @SerializedName(value="exit_code")
        private final Number exitCode;

        public Optional<Number> exitCode() {
            return Optional.ofNullable(this.exitCode);
        }

        @Generated
        public TransactionNode(@NonNull String id, @NonNull String inMsg, @NonNull String[] outMsgs, @NonNull String accountAddr, @NonNull String totalFees, @NonNull Boolean aborted, Number exitCode) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (inMsg == null) {
                throw new NullPointerException("inMsg is marked non-null but is null");
            }
            if (outMsgs == null) {
                throw new NullPointerException("outMsgs is marked non-null but is null");
            }
            if (accountAddr == null) {
                throw new NullPointerException("accountAddr is marked non-null but is null");
            }
            if (totalFees == null) {
                throw new NullPointerException("totalFees is marked non-null but is null");
            }
            if (aborted == null) {
                throw new NullPointerException("aborted is marked non-null but is null");
            }
            this.id = id;
            this.inMsg = inMsg;
            this.outMsgs = outMsgs;
            this.accountAddr = accountAddr;
            this.totalFees = totalFees;
            this.aborted = aborted;
            this.exitCode = exitCode;
        }

        @NonNull
        @Generated
        public String id() {
            return this.id;
        }

        @NonNull
        @Generated
        public String inMsg() {
            return this.inMsg;
        }

        @NonNull
        @Generated
        public String[] outMsgs() {
            return this.outMsgs;
        }

        @NonNull
        @Generated
        public String accountAddr() {
            return this.accountAddr;
        }

        @NonNull
        @Generated
        public String totalFees() {
            return this.totalFees;
        }

        @NonNull
        @Generated
        public Boolean aborted() {
            return this.aborted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionNode)) {
                return false;
            }
            TransactionNode other = (TransactionNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$aborted = this.aborted();
            Boolean other$aborted = other.aborted();
            if (this$aborted == null ? other$aborted != null : !((Object)this$aborted).equals(other$aborted)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$inMsg = this.inMsg();
            String other$inMsg = other.inMsg();
            if (this$inMsg == null ? other$inMsg != null : !this$inMsg.equals(other$inMsg)) {
                return false;
            }
            if (!Arrays.deepEquals(this.outMsgs(), other.outMsgs())) {
                return false;
            }
            String this$accountAddr = this.accountAddr();
            String other$accountAddr = other.accountAddr();
            if (this$accountAddr == null ? other$accountAddr != null : !this$accountAddr.equals(other$accountAddr)) {
                return false;
            }
            String this$totalFees = this.totalFees();
            String other$totalFees = other.totalFees();
            if (this$totalFees == null ? other$totalFees != null : !this$totalFees.equals(other$totalFees)) {
                return false;
            }
            Optional<Number> this$exitCode = this.exitCode();
            Optional<Number> other$exitCode = other.exitCode();
            return !(this$exitCode == null ? other$exitCode != null : !((Object)this$exitCode).equals(other$exitCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $aborted = this.aborted();
            result = result * 59 + ($aborted == null ? 43 : ((Object)$aborted).hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $inMsg = this.inMsg();
            result = result * 59 + ($inMsg == null ? 43 : $inMsg.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.outMsgs());
            String $accountAddr = this.accountAddr();
            result = result * 59 + ($accountAddr == null ? 43 : $accountAddr.hashCode());
            String $totalFees = this.totalFees();
            result = result * 59 + ($totalFees == null ? 43 : $totalFees.hashCode());
            Optional<Number> $exitCode = this.exitCode();
            result = result * 59 + ($exitCode == null ? 43 : ((Object)$exitCode).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Net.TransactionNode(id=" + this.id() + ", inMsg=" + this.inMsg() + ", outMsgs=" + Arrays.deepToString(this.outMsgs()) + ", accountAddr=" + this.accountAddr() + ", totalFees=" + this.totalFees() + ", aborted=" + this.aborted() + ", exitCode=" + this.exitCode() + ")";
        }
    }

    public static enum AggregationFn {
        COUNT,
        MIN,
        MAX,
        SUM,
        AVERAGE;

    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

